/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy.entity.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.NecroEntityBase;
import com.sirolf2009.necromancy.item.ItemBodyPart;

public class NecroEntityCreeper
extends NecroEntityBase {
    public NecroEntityCreeper() {
        super("Creeper");
        this.headItem = new ye(yc.bS, 1, 4);
        this.torsoItem = ItemBodyPart.getItemStackFromName("Creeper Torso", 1);
        this.legItem = ItemBodyPart.getItemStackFromName("Creeper Legs", 1);
        this.texture = new bjo("textures/entity/creeper/creeper.png");
        this.hasArms = false;
    }

    @Override
    public void initRecipes() {
        this.initDefaultRecipes(yc.O);
    }

    @Override
    public BodyPart[] initHead(bbo model) {
        BodyPart head = new BodyPart(this, model, 0, 0);
        head.a(-4.0f, -4.0f, -4.0f, 8, 8, 8, 0.0f);
        head.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{head};
    }

    @Override
    public BodyPart[] initTorso(bbo model) {
        float[] headPos = new float[]{4.0f, -4.0f, 2.0f};
        float[] armLeftPos = new float[]{-4.0f, 0.0f, 2.0f};
        float[] armRightPos = new float[]{8.0f, 0.0f, 2.0f};
        BodyPart torso = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 16, 16);
        torso.a(0.0f, 0.0f, 0.0f, 8, 12, 4, 0.0f);
        torso.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{torso};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-4.0f, 4.0f, -2.0f};
        BodyPart leg1 = new BodyPart(this, torsoPos, model, 0, 16);
        leg1.a(0.0f, 16.0f, 2.0f, 4, 6, 4, 0.0f);
        BodyPart leg2 = new BodyPart(this, torsoPos, model, 0, 16);
        leg2.a(-4.0f, 16.0f, 2.0f, 4, 6, 4, 0.0f);
        BodyPart leg3 = new BodyPart(this, torsoPos, model, 0, 16);
        leg3.a(-4.0f, 16.0f, -6.0f, 4, 6, 4, 0.0f);
        BodyPart leg4 = new BodyPart(this, torsoPos, model, 0, 16);
        leg4.a(0.0f, 16.0f, -6.0f, 4, 6, 4, 0.0f);
        return new BodyPart[]{leg1, leg2, leg3, leg4};
    }

    @Override
    public BodyPart[] initArmLeft(bbo model) {
        return null;
    }

    @Override
    public BodyPart[] initArmRight(bbo model) {
        return null;
    }

    @Override
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn par7Entity, BodyPart[] bodypart, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            bodypart[0].g = par4 / 57.295776f;
            bodypart[0].f = par5 / 57.295776f;
        }
        if (location == BodyPartLocation.Legs) {
            bodypart[0].f = ls.b((float)(par1 * 0.6662f)) * 1.4f * par2;
            bodypart[1].f = ls.b((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
            bodypart[0].g = 0.0f;
            bodypart[1].g = 0.0f;
        }
    }

    @Override
    public void setAttributes(of minion, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            this.head[0].attributes.b(tp.a).a(3.0);
            this.head[0].attributes.b(tp.b).a(16.0);
            this.head[0].attributes.b(tp.c).a(0.0);
            this.head[0].attributes.b(tp.d).a(0.0);
            this.head[0].attributes.b(tp.e).a(2.0);
        } else if (location == BodyPartLocation.Torso) {
            this.torso[0].attributes.b(tp.a).a(14.0);
            this.torso[0].attributes.b(tp.b).a(0.0);
            this.torso[0].attributes.b(tp.c).a(0.0);
            this.torso[0].attributes.b(tp.d).a(0.0);
            this.torso[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Legs) {
            this.legs[0].attributes.b(tp.a).a(3.0);
            this.legs[0].attributes.b(tp.b).a(0.0);
            this.legs[0].attributes.b(tp.c).a(0.0);
            this.legs[0].attributes.b(tp.d).a(0.25);
            this.legs[0].attributes.b(tp.e).a(0.0);
        }
    }
}

