/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy.entity.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.NecroEntityBase;
import com.sirolf2009.necromancy.item.ItemBodyPart;

public class NecroEntitySquid
extends NecroEntityBase {
    public NecroEntitySquid() {
        super("Squid");
        this.headItem = ItemBodyPart.getItemStackFromName("Squid Head", 1);
        this.torsoItem = ItemBodyPart.getItemStackFromName("Squid Torso", 1);
        this.legItem = ItemBodyPart.getItemStackFromName("Squid Legs", 1);
        this.texture = new bjo("textures/entity/squid.png");
        this.hasArms = false;
    }

    @Override
    public void initRecipes() {
        this.initDefaultRecipes(new ye(yc.aY, 1, 0));
    }

    @Override
    public BodyPart[] initHead(bbo model) {
        BodyPart squidBody = new BodyPart(this, model, 0, 0);
        squidBody.a(-6.0f, -20.0f, -6.0f, 12, 16, 12);
        squidBody.d += 8.0f;
        return new BodyPart[]{squidBody};
    }

    @Override
    public BodyPart[] initTorso(bbo model) {
        float[] armLeftPos = new float[]{-6.0f, -4.0f, 0.0f};
        float[] armRightPos = new float[]{10.0f, -4.0f, 0.0f};
        float[] headPos = new float[]{4.0f, -8.0f, 0.0f};
        BodyPart squidBody = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 0, 0);
        squidBody.a(-2.0f, -12.0f, -5.0f, 12, 16, 12);
        squidBody.d += 8.0f;
        return new BodyPart[]{squidBody};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-4.0f, -7.0f, -3.0f};
        BodyPart[] bodyParts = new BodyPart[8];
        for (int i = 0; i < bodyParts.length; ++i) {
            bodyParts[i] = new BodyPart(this, torsoPos, model, 48, 0);
            double d0 = (double)i * Math.PI * 2.0 / (double)bodyParts.length;
            float f = (float)Math.cos(d0) * 5.0f;
            float f1 = (float)Math.sin(d0) * 5.0f;
            bodyParts[i].a(-1.0f, -10.0f, -1.0f, 2, 18, 2);
            bodyParts[i].c = f;
            bodyParts[i].e = f1;
            bodyParts[i].d = 15.0f;
            d0 = (double)i * Math.PI * -2.0 / (double)bodyParts.length + 1.5707963267948966;
            bodyParts[i].g = (float)d0;
        }
        return bodyParts;
    }

    @Override
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn entity, BodyPart[] part, BodyPartLocation location) {
        if (location == BodyPartLocation.Legs) {
            for (BodyPart parts : part) {
                parts.f = par3;
            }
        }
    }

    @Override
    public void setAttributes(of minion, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            this.head[0].attributes.b(tp.a).a(2.0);
            this.head[0].attributes.b(tp.b).a(16.0);
            this.head[0].attributes.b(tp.c).a(0.0);
            this.head[0].attributes.b(tp.d).a(0.0);
            this.head[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Torso) {
            this.torso[0].attributes.b(tp.a).a(6.0);
            this.torso[0].attributes.b(tp.b).a(0.0);
            this.torso[0].attributes.b(tp.c).a(0.0);
            this.torso[0].attributes.b(tp.d).a(0.0);
            this.torso[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Legs) {
            this.legs[0].attributes.b(tp.a).a(2.0);
            this.legs[0].attributes.b(tp.b).a(0.0);
            this.legs[0].attributes.b(tp.c).a(0.0);
            this.legs[0].attributes.b(tp.d).a(0.7);
            this.legs[0].attributes.b(tp.e).a(0.0);
        }
    }
}

