/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy.entity.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.NecroEntityBase;
import com.sirolf2009.necromancy.item.ItemBodyPart;

public class NecroEntityVillager
extends NecroEntityBase {
    public NecroEntityVillager() {
        this("Villager");
    }

    public NecroEntityVillager(String name) {
        super(name);
        this.headItem = ItemBodyPart.getItemStackFromName("Villager Head", 1);
        this.torsoItem = ItemBodyPart.getItemStackFromName("Villager Torso", 1);
        this.armItem = ItemBodyPart.getItemStackFromName("Villager Arm", 1);
        this.legItem = ItemBodyPart.getItemStackFromName("Villager Legs", 1);
        this.texture = new bjo("textures/entity/villager/villager.png");
        this.textureHeight = 64;
    }

    @Override
    public void initRecipes() {
        this.initDefaultRecipes(yc.aN);
    }

    @Override
    public BodyPart[] initHead(bbo model) {
        BodyPart villagerHead = new BodyPart(this, model, 0, 0);
        villagerHead.a(-4.0f, -6.0f, -4.0f, 8, 10, 8, 0.0f);
        BodyPart nose = new BodyPart(this, model, 24, 0);
        nose.a(0.0f, -2.0f, 0.0f);
        nose.a(-1.0f, 3.0f, -6.0f, 2, 4, 2, 0.0f);
        return new BodyPart[]{villagerHead, nose};
    }

    @Override
    public BodyPart[] initTorso(bbo model) {
        float[] headPos = new float[]{4.0f, -4.0f, 2.0f};
        float[] armRightPos = new float[]{8.0f, 0.0f, 0.0f};
        float[] armLeftPos = new float[]{-4.0f, 0.0f, 0.0f};
        BodyPart villagerBody = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 16, 20);
        villagerBody.a(0.0f, 0.0f, -1.0f, 8, 12, 6, 0.0f);
        BodyPart villagerBody2 = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 0, 38);
        villagerBody2.a(0.0f, 0.0f, -1.0f, 8, 18, 6, 0.5f);
        return new BodyPart[]{villagerBody, villagerBody2};
    }

    @Override
    public BodyPart[] initArmLeft(bbo model) {
        BodyPart arm = new BodyPart(this, model, 44, 22);
        arm.a(0.0f, -2.0f, -2.0f, 4, 8, 4, 0.0f);
        arm.a(0.0f, 2.0f, 0.0f);
        arm.a(4.0f, 2.0f, -2.0f, 4, 4, 4, 0.0f);
        return new BodyPart[]{arm};
    }

    @Override
    public BodyPart[] initArmRight(bbo model) {
        BodyPart arm = new BodyPart(this, model, 44, 22);
        arm.a(0.0f, 2.0f, 0.0f);
        arm.a(0.0f, -2.0f, -2.0f, 4, 8, 4, 0.0f);
        arm.a(-4.0f, 2.0f, -2.0f, 4, 4, 4, 0.0f);
        return new BodyPart[]{arm};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-4.0f, 0.0f, -2.0f};
        BodyPart rightVillagerLeg = new BodyPart(this, torsoPos, model, 0, 22);
        rightVillagerLeg.a(-2.0f, 12.0f, 0.0f);
        rightVillagerLeg.a(-2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f);
        BodyPart leftVillagerLeg = new BodyPart(this, torsoPos, model, 0, 22);
        leftVillagerLeg.i = true;
        leftVillagerLeg.a(2.0f, 12.0f, 0.0f);
        leftVillagerLeg.a(-2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f);
        return new BodyPart[]{rightVillagerLeg, leftVillagerLeg};
    }

    @Override
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn entity, BodyPart[] part, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            part[0].g = par4 / 57.295776f;
            part[0].f = par5 / 57.295776f;
            part[1].g = par4 / 57.295776f;
            part[1].f = par5 / 57.295776f;
        }
        if (location == BodyPartLocation.ArmLeft || location == BodyPartLocation.ArmRight) {
            part[0].f = -0.75f;
        }
        if (location == BodyPartLocation.Legs) {
            part[0].f = ls.b((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2 * 0.5f;
            part[1].f = ls.b((float)(par1 * 0.6662f)) * 1.4f * par2 * 0.5f;
        }
    }

    @Override
    public void setAttributes(of minion, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            this.head[0].attributes.b(tp.a).a(2.0);
            this.head[0].attributes.b(tp.b).a(16.0);
            this.head[0].attributes.b(tp.c).a(0.0);
            this.head[0].attributes.b(tp.d).a(0.0);
            this.head[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Torso) {
            this.torso[0].attributes.b(tp.a).a(12.0);
            this.torso[0].attributes.b(tp.b).a(0.0);
            this.torso[0].attributes.b(tp.c).a(0.0);
            this.torso[0].attributes.b(tp.d).a(0.0);
            this.torso[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.ArmLeft) {
            this.armLeft[0].attributes.b(tp.a).a(2.0);
            this.armLeft[0].attributes.b(tp.b).a(0.0);
            this.armLeft[0].attributes.b(tp.c).a(0.0);
            this.armLeft[0].attributes.b(tp.d).a(0.0);
            this.armLeft[0].attributes.b(tp.e).a(1.0);
        } else if (location == BodyPartLocation.ArmRight) {
            this.armRight[0].attributes.b(tp.a).a(2.0);
            this.armRight[0].attributes.b(tp.b).a(0.0);
            this.armRight[0].attributes.b(tp.c).a(0.0);
            this.armRight[0].attributes.b(tp.d).a(0.0);
            this.armRight[0].attributes.b(tp.e).a(1.0);
        } else if (location == BodyPartLocation.Legs) {
            this.legs[0].attributes.b(tp.a).a(2.0);
            this.legs[0].attributes.b(tp.b).a(0.0);
            this.legs[0].attributes.b(tp.c).a(0.0);
            this.legs[0].attributes.b(tp.d).a(0.5);
            this.legs[0].attributes.b(tp.e).a(0.0);
        }
    }
}

