/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy.tileentity;

import java.util.Random;

public class TileEntityScent
extends asp {
    private int[] scents = new int[17];
    private int red;
    private int green;
    private int blue;
    private int alpha;
    private Random rand = new Random();
    private int reach;
    private int[] sourceLocation = new int[3];
    private boolean isMarkedForDespawn;
    public ms[] icons = new ms[6];
    public int iconTimer = 0;

    public void h() {
        if (this.getAir() < 200) {
            if (this.rand.nextInt(4) == 0) {
                this.setAir(this.getAir() + 1);
            }
        } else {
            this.k.a(this.k.r(this.l, this.m, this.n));
            this.isMarkedForDespawn = true;
            return;
        }
        this.calculateColors();
        this.spreadScents();
    }

    public void onChunkUnload() {
        if (this.isMarkedForDespawn) {
            this.k.i(this.l, this.m, this.n);
        }
    }

    public void spreadScents() {
        for (int x2 = 0; x2 < 3; ++x2) {
            for (int y2 = 0; y2 < 3; ++y2) {
                for (int z2 = 0; z2 < 3; ++z2) {
                    TileEntityScent tileEntityScent;
                    int x = x2 + this.l - 1;
                    int y = y2 + this.m - 1;
                    int z3 = z2 + this.n - 1;
                    int ID = this.k.a(x, y, z3);
                    if (this.k.r(x, y, z3) == this) continue;
                    if (ID == this.k.a(this.l, this.m, this.n)) {
                        tileEntityScent = (TileEntityScent)this.k.r(x2 + this.l - 1, y2 + this.m - 1, z2 + this.n - 1);
                        this.spreadScentTo(tileEntityScent);
                        continue;
                    }
                    if (!this.k.I || !((double)this.reach >= Math.sqrt(this.a(this.sourceLocation[0], this.sourceLocation[1], this.sourceLocation[2]))) || ID != 0 || this.rand.nextInt(100) != 0) continue;
                    this.k.c(x, y, z3, this.k.a(this.l, this.m, this.n));
                    tileEntityScent = (TileEntityScent)this.k.r(x, y, z3);
                    tileEntityScent.setSourceLocation(this.sourceLocation);
                    tileEntityScent.setAir(this.getAir() + 10);
                    tileEntityScent.setReach(this.getReach());
                    this.spreadScentTo(tileEntityScent);
                }
            }
        }
    }

    private void spreadScentTo(TileEntityScent tileEntityScent) {
        for (int i = 0; i < 16; ++i) {
            int delta;
            if (this.getScent(i) == tileEntityScent.getScent(i) || (delta = this.getScent(i) - tileEntityScent.getScent(i)) <= 8) continue;
            this.addScent(i, -8);
            tileEntityScent.addScent(i, 8);
        }
        int delta = this.getScent(16) - tileEntityScent.getScent(16);
        if (delta > 8) {
            tileEntityScent.setAir(tileEntityScent.getAir() + 8);
            this.setAir(this.getAir() - 8);
        }
    }

    public void calculateColors() {
        this.red = 0;
        this.blue = 0;
        this.green = 0;
        this.alpha = 255 - 255 * this.scents[16] / 255;
        for (int i = 0; i < xl.c.length; ++i) {
            this.red += xl.c[i] >> 16 & 255 * this.scents[i] / 100;
            this.green += xl.c[i] >> 8 & 255 * this.scents[i] / 100;
            this.blue += xl.c[i] >> 0 & 255 * this.scents[i] / 100;
        }
        this.k.p(this.l, this.m, this.n);
    }

    public void addScent(int scentIndex, int amount) {
        int i;
        if (scentIndex == 16) {
            this.setAir(this.getAir() + amount);
            return;
        }
        int n = scentIndex;
        this.scents[n] = this.scents[n] + amount;
        int oldTotal = 0;
        for (i = 0; i < 16; ++i) {
            oldTotal += this.scents[i];
        }
        if (oldTotal != 0) {
            for (i = 0; i < 16; ++i) {
                double scent = this.scents[i];
                scent /= (double)oldTotal;
                this.scents[i] = (int)(scent *= 100.0);
            }
        }
    }

    public int[] getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(int[] sourceLocation) {
        this.sourceLocation[0] = sourceLocation[0];
        this.sourceLocation[1] = sourceLocation[1];
        this.sourceLocation[2] = sourceLocation[2];
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getScent(int scentIndex) {
        return this.scents[scentIndex];
    }

    public void setAir(int amount) {
        this.scents[16] = amount;
        if (this.getAir() > 255) {
            this.scents[16] = 255;
        }
        if (this.getAir() < 0) {
            this.scents[16] = 0;
        }
    }

    public int getAir() {
        return this.scents[16];
    }

    public int getReach() {
        return this.reach;
    }

    public void setReach(int reach) {
        this.reach = reach;
    }

    public boolean isMarkedForDespawn() {
        return this.isMarkedForDespawn;
    }

    public void setMarkedForDespawn(boolean isMarkedForDespawn) {
        this.isMarkedForDespawn = isMarkedForDespawn;
    }

    public void a(by tagCompound) {
        super.a(tagCompound);
    }

    public void b(by tagCompound) {
        super.b(tagCompound);
    }
}

