/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.BlockCoord;
import net.minecraftforge.fluids.FluidStack;

public class NBTDataWrapper
implements MCDataInput,
MCDataOutput {
    private cg readList;
    private int readTag = 0;
    private cg writeList;

    public NBTDataWrapper(cg input) {
        this.readList = input;
    }

    public NBTDataWrapper() {
        this.writeList = new cg();
    }

    public cg toTag() {
        return this.writeList;
    }

    @Override
    public NBTDataWrapper writeLong(long l) {
        this.writeList.a((cl)new ch(null, l));
        return this;
    }

    @Override
    public NBTDataWrapper writeInt(int i) {
        this.writeList.a((cl)new cf(null, i));
        return this;
    }

    @Override
    public NBTDataWrapper writeShort(int s) {
        this.writeList.a((cl)new cj(null, (short)s));
        return this;
    }

    @Override
    public NBTDataWrapper writeByte(int b) {
        this.writeList.a((cl)new bx(null, (byte)b));
        return this;
    }

    @Override
    public NBTDataWrapper writeDouble(double d) {
        this.writeList.a((cl)new cb(null, d));
        return this;
    }

    @Override
    public NBTDataWrapper writeFloat(float f) {
        this.writeList.a((cl)new cd(null, f));
        return this;
    }

    @Override
    public NBTDataWrapper writeBoolean(boolean b) {
        this.writeList.a((cl)new bx(null, (byte)(b ? 1 : 0)));
        return this;
    }

    @Override
    public NBTDataWrapper writeChar(char c) {
        this.writeList.a((cl)new cj(null, (short)c));
        return this;
    }

    @Override
    public NBTDataWrapper writeByteArray(byte[] array) {
        this.writeList.a((cl)new bw(null, array));
        return this;
    }

    @Override
    public NBTDataWrapper writeString(String s) {
        this.writeList.a((cl)new ck(null, s));
        return this;
    }

    @Override
    public NBTDataWrapper writeCoord(int x, int y, int z) {
        this.writeInt(x);
        this.writeInt(y);
        this.writeInt(z);
        return this;
    }

    @Override
    public NBTDataWrapper writeCoord(BlockCoord coord) {
        this.writeCoord(coord.x, coord.y, coord.z);
        return this;
    }

    @Override
    public NBTDataWrapper writeNBTTagCompound(by tag) {
        this.writeList.a((cl)tag);
        return this;
    }

    @Override
    public NBTDataWrapper writeItemStack(ye stack) {
        this.writeList.a((cl)stack.b(new by()));
        return this;
    }

    @Override
    public NBTDataWrapper writeFluidStack(FluidStack liquid) {
        this.writeList.a((cl)liquid.writeToNBT(new by()));
        return this;
    }

    @Override
    public long readLong() {
        return ((ch)this.readTag()).a;
    }

    @Override
    public int readInt() {
        return ((cf)this.readTag()).a;
    }

    @Override
    public short readShort() {
        return ((cj)this.readTag()).a;
    }

    @Override
    public int readUShort() {
        return ((cj)this.readTag()).a & 0xFFFF;
    }

    @Override
    public byte readByte() {
        return ((bx)this.readTag()).a;
    }

    @Override
    public int readUByte() {
        return ((bx)this.readTag()).a & 0xFF;
    }

    @Override
    public double readDouble() {
        return ((cb)this.readTag()).a;
    }

    @Override
    public float readFloat() {
        return ((cd)this.readTag()).a;
    }

    @Override
    public boolean readBoolean() {
        return ((bx)this.readTag()).a != 0;
    }

    @Override
    public char readChar() {
        return (char)((cj)this.readTag()).a;
    }

    @Override
    public byte[] readByteArray(int length) {
        return ((bw)this.readTag()).a;
    }

    @Override
    public String readString() {
        return ((ck)this.readTag()).a;
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public by readNBTTagCompound() {
        return (by)this.readTag();
    }

    @Override
    public ye readItemStack() {
        return ye.a((by)this.readNBTTagCompound());
    }

    @Override
    public FluidStack readFluidStack() {
        return FluidStack.loadFluidStackFromNBT((by)this.readNBTTagCompound());
    }

    private cl readTag() {
        return this.readList.b(this.readTag++);
    }
}

