/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.entity;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockLandingPadFull;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.event.GCCoreLandingPadRemovalEvent;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class EntityTieredRocket
extends EntityAutoRocket
implements IRocketType,
IDockable,
IInventory,
IWorldTransferCallback {
    public IRocketType.EnumRocketType rocketType;
    public float rumble;
    public int launchCooldown;

    public EntityTieredRocket(World par1World) {
        super(par1World);
        this.func_70105_a(0.98f, 4.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityTieredRocket(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        if (Loader.isModLoaded((String)"ICBM|Explosion")) {
            try {
                Class.forName("icbm.api.RadarRegistry").getMethod("register", Entity.class).invoke(null, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (Loader.isModLoaded((String)"ICBM|Explosion")) {
            try {
                Class.forName("icbm.api.RadarRegistry").getMethod("unregister", Entity.class).invoke(null, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void igniteCheckingCooldown() {
        if (!this.field_70170_p.field_72995_K && this.launchCooldown <= 0) {
            this.ignite();
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.getWaitForPlayer()) {
            if (this.field_70153_n != null) {
                if (this.ticks >= 40L) {
                    if (!this.field_70170_p.field_72995_K) {
                        Entity e = this.field_70153_n;
                        this.field_70153_n.field_70154_o = null;
                        this.field_70153_n = null;
                        e.func_70078_a((Entity)this);
                    }
                    this.setWaitForPlayer(false);
                    this.field_70181_x = -0.5;
                } else {
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    this.field_70153_n.field_70179_y = 0.0;
                    this.field_70153_n.field_70181_x = 0.0;
                    this.field_70153_n.field_70159_w = 0.0;
                }
            } else {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
        }
        super.func_70071_h_();
        if (this.landing) {
            this.field_70177_z = 0.0f;
            this.field_70125_A = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.launchCooldown > 0) {
            --this.launchCooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.getLandingPad() != null && this.getLandingPad().getConnectedTiles() != null) {
            for (ILandingPadAttachable tile : this.getLandingPad().getConnectedTiles()) {
                if (this.field_70170_p.func_72796_p(((TileEntity)tile).field_70329_l, ((TileEntity)tile).field_70330_m, ((TileEntity)tile).field_70327_n) == null || !(this.field_70170_p.func_72796_p(((TileEntity)tile).field_70329_l, ((TileEntity)tile).field_70330_m, ((TileEntity)tile).field_70327_n) instanceof GCCoreTileEntityFuelLoader) || !(tile instanceof GCCoreTileEntityFuelLoader) || !(((GCCoreTileEntityFuelLoader)tile).getEnergyStored() > 0.0f) || this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase()) continue;
                this.setPad(null);
            }
        }
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        }
        if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70165_t += (double)(this.rumble / 30.0f);
            this.field_70153_n.field_70161_v += (double)(this.rumble / 30.0f);
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.getPhase() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.lastLastMotionY = this.lastMotionY;
            this.lastMotionY = this.field_70181_x;
        }
    }

    @Override
    public void readNetworkedData(ByteArrayDataInput dataStream) {
        this.rocketType = IRocketType.EnumRocketType.values()[dataStream.readInt()];
        super.readNetworkedData(dataStream);
        if (dataStream.readBoolean()) {
            this.field_70165_t = dataStream.readDouble() / 8000.0;
            this.field_70163_u = dataStream.readDouble() / 8000.0;
            this.field_70161_v = dataStream.readDouble() / 8000.0;
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> list) {
        list.add(this.rocketType != null ? this.rocketType.getIndex() : 0);
        super.getNetworkedData(list);
        boolean sendPosUpdates = this.ticks < 25L || this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase();
        list.add(sendPosUpdates);
        if (sendPosUpdates) {
            list.add(this.field_70165_t * 8000.0);
            list.add(this.field_70163_u * 8000.0);
            list.add(this.field_70161_v * 8000.0);
        }
        return list;
    }

    @Override
    public void onReachAtmoshpere() {
        if (this.destinationFrequency != -1) {
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            this.setTarget(true, this.destinationFrequency);
            if (this.targetVec != null) {
                if (this.targetDimension != this.field_70170_p.field_73011_w.field_76574_g) {
                    WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.targetDimension);
                    if (!this.field_70170_p.field_72995_K && worldServer != null && this.field_70153_n != null) {
                        WorldUtil.transferEntityToDimension(this.field_70153_n, this.targetDimension, worldServer, false, this);
                    }
                } else {
                    this.func_70107_b(this.targetVec.x + 0.5, this.targetVec.y + 800.0, this.targetVec.z + 0.5);
                    this.landing = true;
                }
            } else {
                this.func_70106_y();
            }
        } else if (this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
            GCCorePlayerMP player = (GCCorePlayerMP)this.field_70153_n;
            HashMap<String, Integer> map = WorldUtil.getArrayOfPossibleDimensions(WorldUtil.getPossibleDimensionsForSpaceshipTier(this.getRocketTier()), player);
            String temp = "";
            int count = 0;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                temp = temp.concat(entry.getKey() + (count < map.entrySet().size() - 1 ? "." : ""));
                ++count;
            }
            player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.UPDATE_DIMENSION_LIST, new Object[]{player.field_71092_bJ, temp}));
            player.setSpaceshipTier(this.getRocketTier());
            player.setUsingPlanetGui();
            this.onTeleport(player);
            player.func_70078_a(this);
            if (!this.field_70128_L) {
                this.func_70106_y();
            }
        }
    }

    @Override
    protected boolean shouldCancelExplosion() {
        return this.hasValidFuel() && Math.abs(this.lastLastMotionY) < 4.0;
    }

    public void onTeleport(EntityPlayerMP player) {
    }

    @Override
    protected void onRocketLand(int x, int y, int z) {
        super.onRocketLand(x, y, z);
        this.launchCooldown = 40;
        this.func_70080_a((double)x + 0.5, (double)y + 1.8, (double)z + 0.5, this.field_70177_z, 0.0f);
    }

    @Override
    public void onLaunch() {
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            if (!(this.field_70170_p.field_73011_w instanceof IOrbitDimension) && this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
                ((GCCorePlayerMP)this.field_70153_n).setCoordsTeleportedFromX(this.field_70153_n.field_70165_t);
                ((GCCorePlayerMP)this.field_70153_n).setCoordsTeleportedFromZ(this.field_70153_n.field_70161_v);
            }
            int amountRemoved = 0;
            for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                        int id = this.field_70170_p.func_72798_a(x, y, z);
                        Block block = Block.field_71973_m[id];
                        if (block == null || !(block instanceof GCCoreBlockLandingPadFull) || amountRemoved >= 9) continue;
                        GCCoreLandingPadRemovalEvent event = new GCCoreLandingPadRemovalEvent(this.field_70170_p, x, y, z);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) continue;
                        this.field_70170_p.func_94571_i(x, y, z);
                        amountRemoved = 9;
                    }
                }
            }
            this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    @Override
    protected boolean shouldMoveClientSide() {
        return true;
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.getPhase()) {
            return false;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof GCCorePlayerMP) {
            if (!this.field_70170_p.field_72995_K) {
                Object[] toSend = new Object[]{((EntityPlayerMP)this.field_70153_n).field_71092_bJ};
                ((EntityPlayerMP)this.field_70153_n).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.RESET_THIRD_PERSON, toSend));
                Object[] toSend2 = new Object[]{0};
                ((EntityPlayerMP)par1EntityPlayer).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.ZOOM_CAMERA, toSend2));
                ((GCCorePlayerMP)par1EntityPlayer).setChatCooldown(0);
                par1EntityPlayer.func_70078_a(null);
            }
            return true;
        }
        if (par1EntityPlayer instanceof GCCorePlayerMP) {
            if (!this.field_70170_p.field_72995_K) {
                Object[] toSend = new Object[]{par1EntityPlayer.field_71092_bJ};
                ((EntityPlayerMP)par1EntityPlayer).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.MOUNT_ROCKET, toSend));
                Object[] toSend2 = new Object[]{1};
                ((EntityPlayerMP)par1EntityPlayer).field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.ZOOM_CAMERA, toSend2));
                ((GCCorePlayerMP)par1EntityPlayer).setChatCooldown(0);
                par1EntityPlayer.func_70078_a((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Type", this.rocketType.getIndex());
        super.func_70014_b(nbt);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        super.func_70037_a(nbt);
    }

    @Override
    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public int func_70302_i_() {
        return this.rocketType.getInventorySpace();
    }

    @Override
    public void onWorldTransferred(World world) {
        if (this.targetVec != null) {
            this.func_70107_b(this.targetVec.x + 0.5, this.targetVec.y + 800.0, this.targetVec.z + 0.5);
            this.landing = true;
            this.setWaitForPlayer(true);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        } else {
            this.func_70106_y();
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    @Override
    public boolean isPlayerRocket() {
        return true;
    }
}

