/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.core.item;

import java.util.List;
import micdoodle8.mods.galacticraft.api.transmission.ElectricityDisplay;
import micdoodle8.mods.galacticraft.api.transmission.core.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.transmission.core.item.IItemElectric;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.world.World;

public abstract class ItemElectric
extends Item
implements IItemElectric {
    public ItemElectric(int id) {
        super(id);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        String color = "";
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? "\u00a74" : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? "\u00a72" : "\u00a76");
        list.add(color + ElectricityDisplay.getDisplayShort(joules, ElectricityDisplay.ElectricUnit.JOULES) + "/" + ElectricityDisplay.getDisplayShort(this.getMaxElectricityStored(itemStack), ElectricityDisplay.ElectricUnit.JOULES));
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setElectricity(itemStack, 0.0f);
    }

    @Override
    public float recharge(ItemStack itemStack, float energy, boolean doReceive) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (doReceive) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    @Override
    public float discharge(ItemStack itemStack, float energy, boolean doTransfer) {
        float energyToTransfer = Math.min(this.getElectricityStored(itemStack), energy);
        if (doTransfer) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    @Override
    public float getVoltage(ItemStack itemStack) {
        return 0.12f;
    }

    @Override
    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    @Override
    public float getTransfer(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack);
    }

    @Override
    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = (float)((NBTTagDouble)obj).field_74755_a;
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).field_74750_a;
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(ElectricItemHelper.getUncharged(new ItemStack((Item)this)));
        par3List.add(ElectricItemHelper.getWithCharge(new ItemStack((Item)this), this.getMaxElectricityStored(new ItemStack((Item)this))));
    }
}

