/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.core.GCCoreCompatibilityManager;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenPipe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreBlockEnclosed
extends BlockContainer
implements IPartialSealableBlock,
ITileEntityProvider {
    private Icon[] enclosedIcons;

    public static EnumEnclosedBlock getTypeFromMeta(int metadata) {
        for (EnumEnclosedBlock type : EnumEnclosedBlock.values()) {
            if (type.getMetadata() != metadata) continue;
            return type;
        }
        return null;
    }

    public GCCoreBlockEnclosed(int id, String assetName) {
        super(id, Material.field_76253_m);
        this.func_71894_b(0.2f);
        this.func_71848_c(0.4f);
        this.func_71884_a(Block.field_71976_h);
        this.func_111022_d(GalacticraftCore.ASSET_PREFIX + assetName);
        this.func_71864_b(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.ALUMINUM_WIRE.getMetadata()));
        par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.ALUMINUM_WIRE_HEAVY.getMetadata()));
        par3List.add(new ItemStack(par1, 1, 1));
        if (GCCoreCompatibilityManager.isTELoaded()) {
            // empty if block
        }
        if (GCCoreCompatibilityManager.isIc2Loaded()) {
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_COPPER_CABLE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_GOLD_CABLE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_HV_CABLE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_GLASS_FIBRE_CABLE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_LV_CABLE.getMetadata()));
        }
        if (GCCoreCompatibilityManager.isBCraftLoaded()) {
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_ITEM_COBBLESTONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_ITEM_STONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_FLUIDS_COBBLESTONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_FLUIDS_STONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_POWER_STONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_POWER_GOLDPIPE.getMetadata()));
        }
        if (GCCoreCompatibilityManager.isAppEngLoaded()) {
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.ME_CABLE.getMetadata()));
        }
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        return par2 >= this.enclosedIcons.length ? this.field_94336_cN : this.enclosedIcons[par2];
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public void func_94332_a(IconRegister par1IconRegister) {
        this.enclosedIcons = new Icon[16];
        for (int i = 0; i < EnumEnclosedBlock.values().length; ++i) {
            this.enclosedIcons[EnumEnclosedBlock.values()[i].getMetadata()] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + EnumEnclosedBlock.values()[i].getTexture());
        }
        this.field_94336_cN = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "" + EnumEnclosedBlock.OXYGEN_PIPE.getTexture());
    }

    public void func_71861_g(World world, int x, int y, int z) {
        block13: {
            super.func_71861_g(world, x, y, z);
            int metadata = world.func_72805_g(x, y, z);
            TileEntity tileEntity = world.func_72796_p(x, y, z);
            if (metadata != EnumEnclosedBlock.TE_CONDUIT.getMetadata() && (metadata <= 0 || metadata > EnumEnclosedBlock.OXYGEN_PIPE.getMetadata())) {
                if (metadata <= EnumEnclosedBlock.IC2_LV_CABLE.getMetadata()) {
                    if (GCCoreCompatibilityManager.isIc2Loaded()) {
                        try {
                            Class<?> clazz = Class.forName("ic2.core.block.wiring.TileEntityCable");
                            if (clazz == null || !clazz.isInstance(tileEntity)) break block13;
                            try {
                                Method method = clazz.getMethod("onNeighborBlockChange", new Class[0]);
                                method.invoke((Object)tileEntity, new Object[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (metadata > EnumEnclosedBlock.BC_POWER_GOLDPIPE.getMetadata() && metadata > EnumEnclosedBlock.ME_CABLE.getMetadata()) {
                    if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE.getMetadata()) {
                        if (tileEntity instanceof IConductor) {
                            ((IConductor)tileEntity).refresh();
                        }
                    } else if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE_HEAVY.getMetadata() && tileEntity instanceof IConductor) {
                        ((IConductor)tileEntity).refresh();
                    }
                }
            }
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        block22: {
            super.func_71863_a(world, x, y, z, blockID);
            int metadata = world.func_72805_g(x, y, z);
            TileEntity tileEntity = world.func_72796_p(x, y, z);
            if (metadata != EnumEnclosedBlock.TE_CONDUIT.getMetadata() && (metadata <= 0 || metadata > EnumEnclosedBlock.OXYGEN_PIPE.getMetadata())) {
                if (metadata <= EnumEnclosedBlock.IC2_LV_CABLE.getMetadata()) {
                    if (GCCoreCompatibilityManager.isIc2Loaded()) {
                        try {
                            Class<?> clazz = Class.forName("ic2.core.block.wiring.TileEntityCable");
                            if (clazz == null || !clazz.isInstance(tileEntity)) break block22;
                            try {
                                Method method = clazz.getMethod("onNeighborBlockChange", new Class[0]);
                                method.invoke((Object)tileEntity, new Object[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (metadata <= EnumEnclosedBlock.BC_POWER_GOLDPIPE.getMetadata()) {
                    if (GCCoreCompatibilityManager.isBCraftLoaded()) {
                        try {
                            Class<?> clazzPipe = Class.forName("buildcraft.transport.Pipe");
                            Class<?> clazzPipeTile = Class.forName("buildcraft.transport.TileGenericPipe");
                            Class<?> clazzPipeBlock = Class.forName("buildcraft.transport.BlockGenericPipe");
                            Method getPipe = null;
                            for (Method m : clazzPipeBlock.getDeclaredMethods()) {
                                if (!m.getName().equals("getPipe")) continue;
                                getPipe = m;
                            }
                            Object pipe = getPipe.invoke(null, world, x, y, z);
                            Method isValid = clazzPipeBlock.getMethod("isValid", clazzPipe);
                            Boolean valid = (Boolean)isValid.invoke(null, pipe);
                            if (valid.booleanValue()) {
                                Method schedule = clazzPipeTile.getMethod("scheduleNeighborChange", new Class[0]);
                                Object container = clazzPipe.getField("container").get(pipe);
                                schedule.invoke(container, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (metadata <= EnumEnclosedBlock.ME_CABLE.getMetadata()) {
                    if (GCCoreCompatibilityManager.isAppEngLoaded()) {
                        world.func_72845_h(x, y, z);
                    }
                } else if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE.getMetadata()) {
                    if (tileEntity instanceof IConductor) {
                        ((IConductor)tileEntity).refresh();
                    }
                } else if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE_HEAVY.getMetadata() && tileEntity instanceof IConductor) {
                    ((IConductor)tileEntity).refresh();
                }
            }
        }
    }

    public TileEntity func_72274_a(World var1) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata != EnumEnclosedBlock.TE_CONDUIT.getMetadata()) {
            if (metadata > 0 && metadata <= EnumEnclosedBlock.OXYGEN_PIPE.getMetadata()) {
                return new GCCoreTileEntityOxygenPipe();
            }
            if (metadata <= EnumEnclosedBlock.IC2_LV_CABLE.getMetadata()) {
                if (GCCoreCompatibilityManager.isIc2Loaded()) {
                    try {
                        Constructor<?> constructor2;
                        Class<?> clazz = Class.forName("ic2.core.block.wiring.TileEntityCable");
                        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
                        Constructor<?> constructor = null;
                        Constructor<?>[] arr$ = constructors;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (constructor = (constructor2 = arr$[i$])).getGenericParameterTypes().length != 1; ++i$) {
                        }
                        constructor.setAccessible(true);
                        return (TileEntity)constructor.newInstance((short)GCCoreBlockEnclosed.getTypeFromMeta(metadata).getSubMetaValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (metadata <= EnumEnclosedBlock.BC_POWER_GOLDPIPE.getMetadata()) {
                if (GCCoreCompatibilityManager.isBCraftLoaded()) {
                    try {
                        Constructor<?> constructor2;
                        Class<?> clazz = Class.forName("buildcraft.transport.TileGenericPipe");
                        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
                        Constructor<?> constructor = null;
                        Constructor<?>[] arr$ = constructors;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (constructor = (constructor2 = arr$[i$])).getGenericParameterTypes().length != 0; ++i$) {
                        }
                        constructor.setAccessible(true);
                        return (TileEntity)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (metadata <= EnumEnclosedBlock.ME_CABLE.getMetadata()) {
                if (GCCoreCompatibilityManager.isAppEngLoaded()) {
                    try {
                        Class<?> clazz = Class.forName("appeng.me.tile.TileCable");
                        return (TileEntity)clazz.newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE.getMetadata()) {
                    return new GCCoreTileEntityAluminumWire();
                }
                if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE_HEAVY.getMetadata()) {
                    return new GCCoreTileEntityAluminumWire(0.025f, 400.0f);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isSealed(World world, int x, int y, int z, ForgeDirection direction) {
        return true;
    }

    public static enum EnumEnclosedBlock {
        TE_CONDUIT(0, 2, null, "enclosed_te_conduit"),
        OXYGEN_PIPE(1, -1, null, "enclosed_oxygen_pipe"),
        IC2_COPPER_CABLE(2, 0, null, "enclosed_copper_cable"),
        IC2_GOLD_CABLE(3, 3, null, "enclosed_gold_cable"),
        IC2_HV_CABLE(4, 6, null, "enclosed_hv_cable"),
        IC2_GLASS_FIBRE_CABLE(5, 9, null, "enclosed_glassfibre_cable"),
        IC2_LV_CABLE(6, 10, null, "enclosed_lv_cable"),
        BC_ITEM_STONEPIPE(7, -1, "PipeItemsStone", "enclosed_itempipe_stone"),
        BC_ITEM_COBBLESTONEPIPE(8, -1, "PipeItemsCobblestone", "enclosed_itempipe_cobblestone"),
        BC_FLUIDS_STONEPIPE(9, -1, "PipeFluidsStone", "enclosed_liquidpipe_stone"),
        BC_FLUIDS_COBBLESTONEPIPE(10, -1, "PipeFluidsCobblestone", "enclosed_liquidpipe_cobblestone"),
        BC_POWER_STONEPIPE(11, -1, "PipePowerStone", "enclosed_powerpipe_stone"),
        BC_POWER_GOLDPIPE(12, -1, "PipePowerGold", "enclosed_powerpipe_gold"),
        ME_CABLE(13, -1, null, "enclosed_me_cable"),
        ALUMINUM_WIRE(14, -1, null, "enclosed_aluminum_wire"),
        ALUMINUM_WIRE_HEAVY(15, -1, null, "enclosed_heavy_aluminum_wire");

        int metadata;
        int subMeta;
        String pipeClass;
        String texture;

        private EnumEnclosedBlock(int metadata, int subMeta, String pipeClass, String texture) {
            this.metadata = metadata;
            this.subMeta = subMeta;
            this.pipeClass = pipeClass;
            this.texture = texture;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public int getSubMetaValue() {
            return this.subMeta;
        }

        public String getPipeClass() {
            return this.pipeClass;
        }

        public String getTexture() {
            return this.texture;
        }
    }
}

