/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.oxygen.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreBlockOxygenSealer
extends GCCoreBlockAdvancedTile {
    private Icon iconMachineSide;
    private Icon iconSealer;
    private Icon iconInput;
    private Icon iconOutput;

    public GCCoreBlockOxygenSealer(int id, String assetName) {
        super(id, Material.field_76246_e);
        this.func_71848_c(1.0f);
        this.func_71884_a(Block.field_71976_h);
        this.func_111022_d(GalacticraftCore.ASSET_PREFIX + assetName);
        this.func_71864_b(assetName);
    }

    public CreativeTabs func_71882_w() {
        return GalacticraftCore.galacticraftTab;
    }

    public int func_71857_b() {
        return GalacticraftCore.proxy.getBlockRenderID(this.field_71990_ca);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_blank");
        this.iconSealer = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_sealer");
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_oxygen_input");
        this.iconOutput = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "machine_input");
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int original = metadata = par1World.func_72805_g(x, y, z);
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, x, y, z);
        return true;
    }

    public Icon func_71858_a(int side, int metadata) {
        if (side == 1) {
            return this.iconSealer;
        }
        if (side == metadata + 2) {
            return this.iconOutput;
        }
        if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
            return this.iconInput;
        }
        return this.iconMachineSide;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new GCCoreTileEntityOxygenSealer();
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof GCCoreTileEntityOxygenSealer) {
            GCCoreTileEntityOxygenSealer sealer = (GCCoreTileEntityOxygenSealer)tile;
            if (sealer.threadSeal != null && sealer.threadSeal.sealed) {
                for (OxygenPressureProtocol.VecDirPair checkedVec : sealer.threadSeal.checked) {
                    int blockID = checkedVec.getPosition().getBlockID((IBlockAccess)world);
                    if (blockID != GCCoreBlocks.breatheableAir.field_71990_ca) continue;
                    world.func_72832_d(checkedVec.getPosition().intX(), checkedVec.getPosition().intY(), checkedVec.getPosition().intZ(), 0, 0, 2);
                }
            }
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }
}

