/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreBlockUnlitTorch
extends Block
implements IOxygenReliantBlock {
    public boolean lit;
    public static Icon[] torchIcons = new Icon[2];

    protected GCCoreBlockUnlitTorch(int id, boolean lit, String assetName) {
        super(id, Material.field_76265_p);
        this.func_71907_b(true);
        this.lit = lit;
        this.func_71900_a(lit ? 0.9375f : 0.2f);
        this.func_71848_c(0.0f);
        this.func_71884_a(Block.field_71967_e);
        this.func_111022_d(GalacticraftCore.ASSET_PREFIX + assetName);
        this.func_71864_b(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (this.field_71990_ca == GCCoreBlocks.unlitTorch.field_71990_ca) {
            return torchIcons[1];
        }
        if (this.field_71990_ca == GCCoreBlocks.unlitTorchLit.field_71990_ca) {
            return torchIcons[0];
        }
        return torchIcons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        return torchIcons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        GCCoreBlockUnlitTorch.torchIcons[0] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "unlitTorchLit");
        GCCoreBlockUnlitTorch.torchIcons[1] = par1IconRegister.func_94245_a(GalacticraftCore.ASSET_PREFIX + "unlitTorch");
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return GalacticraftCore.proxy.getBlockRenderID(this.field_71990_ca);
    }

    private boolean canPlaceTorchOn(World par1World, int par2, int par3, int par4) {
        if (par1World.func_72797_t(par2, par3, par4)) {
            return true;
        }
        int var5 = par1World.func_72798_a(par2, par3, par4);
        return Block.field_71973_m[var5] != null && Block.field_71973_m[var5].canPlaceTorchOnTop(par1World, par2, par3, par4);
    }

    public boolean func_71930_b(World par1World, int par2, int par3, int par4) {
        return par1World.isBlockSolidOnSide(par2 - 1, par3, par4, ForgeDirection.EAST, true) || par1World.isBlockSolidOnSide(par2 + 1, par3, par4, ForgeDirection.WEST, true) || par1World.isBlockSolidOnSide(par2, par3, par4 - 1, ForgeDirection.SOUTH, true) || par1World.isBlockSolidOnSide(par2, par3, par4 + 1, ForgeDirection.NORTH, true) || this.canPlaceTorchOn(par1World, par2, par3 - 1, par4);
    }

    public int func_85104_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        int var10 = par9;
        if (par5 == 1 && this.canPlaceTorchOn(par1World, par2, par3 - 1, par4)) {
            var10 = 5;
        }
        if (par5 == 2 && par1World.isBlockSolidOnSide(par2, par3, par4 + 1, ForgeDirection.NORTH, true)) {
            var10 = 4;
        }
        if (par5 == 3 && par1World.isBlockSolidOnSide(par2, par3, par4 - 1, ForgeDirection.SOUTH, true)) {
            var10 = 3;
        }
        if (par5 == 4 && par1World.isBlockSolidOnSide(par2 + 1, par3, par4, ForgeDirection.WEST, true)) {
            var10 = 2;
        }
        if (par5 == 5 && par1World.isBlockSolidOnSide(par2 - 1, par3, par4, ForgeDirection.EAST, true)) {
            var10 = 1;
        }
        return var10;
    }

    public void func_71847_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        super.func_71847_b(par1World, par2, par3, par4, par5Random);
        if (par1World.func_72805_g(par2, par3, par4) == 0) {
            this.func_71861_g(par1World, par2, par3, par4);
        }
    }

    public void func_71861_g(World par1World, int par2, int par3, int par4) {
        if (par1World.func_72805_g(par2, par3, par4) == 0) {
            if (par1World.isBlockSolidOnSide(par2 - 1, par3, par4, ForgeDirection.EAST, true)) {
                par1World.func_72921_c(par2, par3, par4, 1, 2);
            } else if (par1World.isBlockSolidOnSide(par2 + 1, par3, par4, ForgeDirection.WEST, true)) {
                par1World.func_72921_c(par2, par3, par4, 2, 2);
            } else if (par1World.isBlockSolidOnSide(par2, par3, par4 - 1, ForgeDirection.SOUTH, true)) {
                par1World.func_72921_c(par2, par3, par4, 3, 2);
            } else if (par1World.isBlockSolidOnSide(par2, par3, par4 + 1, ForgeDirection.NORTH, true)) {
                par1World.func_72921_c(par2, par3, par4, 4, 2);
            } else if (this.canPlaceTorchOn(par1World, par2, par3 - 1, par4)) {
                par1World.func_72921_c(par2, par3, par4, 5, 2);
            }
        }
        this.dropTorchIfCantStay(par1World, par2, par3, par4);
    }

    public void func_71863_a(World par1World, int par2, int par3, int par4, int par5) {
        if (this.dropTorchIfCantStay(par1World, par2, par3, par4)) {
            int var6 = par1World.func_72805_g(par2, par3, par4);
            boolean var7 = false;
            if (!par1World.isBlockSolidOnSide(par2 - 1, par3, par4, ForgeDirection.EAST, true) && var6 == 1) {
                var7 = true;
            }
            if (!par1World.isBlockSolidOnSide(par2 + 1, par3, par4, ForgeDirection.WEST, true) && var6 == 2) {
                var7 = true;
            }
            if (!par1World.isBlockSolidOnSide(par2, par3, par4 - 1, ForgeDirection.SOUTH, true) && var6 == 3) {
                var7 = true;
            }
            if (!par1World.isBlockSolidOnSide(par2, par3, par4 + 1, ForgeDirection.NORTH, true) && var6 == 4) {
                var7 = true;
            }
            if (!this.canPlaceTorchOn(par1World, par2, par3 - 1, par4) && var6 == 5) {
                var7 = true;
            }
            if (var7) {
                this.func_71897_c(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
                par1World.func_94575_c(par2, par3, par4, 0);
            }
        }
    }

    private boolean dropTorchIfCantStay(World par1World, int par2, int par3, int par4) {
        if (!this.func_71930_b(par1World, par2, par3, par4)) {
            if (par1World.func_72798_a(par2, par3, par4) == this.field_71990_ca) {
                this.func_71897_c(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), 0);
                par1World.func_94575_c(par2, par3, par4, 0);
            }
            return false;
        }
        return true;
    }

    public MovingObjectPosition func_71878_a(World par1World, int par2, int par3, int par4, Vec3 par5Vec3, Vec3 par6Vec3) {
        int var7 = par1World.func_72805_g(par2, par3, par4) & 7;
        float var8 = 0.15f;
        if (var7 == 1) {
            this.func_71905_a(0.0f, 0.2f, 0.5f - var8, var8 * 2.0f, 0.8f, 0.5f + var8);
        } else if (var7 == 2) {
            this.func_71905_a(1.0f - var8 * 2.0f, 0.2f, 0.5f - var8, 1.0f, 0.8f, 0.5f + var8);
        } else if (var7 == 3) {
            this.func_71905_a(0.5f - var8, 0.2f, 0.0f, 0.5f + var8, 0.8f, var8 * 2.0f);
        } else if (var7 == 4) {
            this.func_71905_a(0.5f - var8, 0.2f, 1.0f - var8 * 2.0f, 0.5f + var8, 0.8f, 1.0f);
        } else {
            var8 = 0.1f;
            this.func_71905_a(0.5f - var8, 0.0f, 0.5f - var8, 0.5f + var8, 0.6f, 0.5f + var8);
        }
        return super.func_71878_a(par1World, par2, par3, par4, par5Vec3, par6Vec3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par5Random.nextInt(5) == 0) {
            int var6 = par1World.func_72805_g(par2, par3, par4);
            double var7 = (float)par2 + 0.5f;
            double var9 = (float)par3 + 0.7f;
            double var11 = (float)par4 + 0.5f;
            double var13 = 0.22f;
            double var15 = 0.27f;
            if (var6 == 1) {
                par1World.func_72869_a("smoke", var7 - (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0);
            } else if (var6 == 2) {
                par1World.func_72869_a("smoke", var7 + (double)0.27f, var9 + (double)0.22f, var11, 0.0, 0.0, 0.0);
            } else if (var6 == 3) {
                par1World.func_72869_a("smoke", var7, var9 + (double)0.22f, var11 - (double)0.27f, 0.0, 0.0, 0.0);
            } else if (var6 == 4) {
                par1World.func_72869_a("smoke", var7, var9 + (double)0.22f, var11 + (double)0.27f, 0.0, 0.0, 0.0);
            } else {
                par1World.func_72869_a("smoke", var7, var9, var11, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void onOxygenRemoved(World world, int x, int y, int z) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            world.func_72832_d(x, y, z, GCCoreBlocks.unlitTorch.field_71990_ca, world.func_72805_g(x, y, z), 2);
        } else {
            world.func_72832_d(x, y, z, Block.field_72069_aq.field_71990_ca, world.func_72805_g(x, y, z), 2);
        }
    }

    @Override
    public void onOxygenAdded(World world, int x, int y, int z) {
        if (world.field_73011_w instanceof IGalacticraftWorldProvider) {
            world.func_72832_d(x, y, z, GCCoreBlocks.unlitTorchLit.field_71990_ca, world.func_72805_g(x, y, z), 2);
        } else {
            world.func_72832_d(x, y, z, Block.field_72069_aq.field_71990_ca, world.func_72805_g(x, y, z), 2);
        }
    }
}

