/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ICelestialBody;
import micdoodle8.mods.galacticraft.api.world.ICelestialBodyRenderer;
import micdoodle8.mods.galacticraft.api.world.IMoon;
import micdoodle8.mods.galacticraft.api.world.IPlanet;
import micdoodle8.mods.galacticraft.core.CommonProxyCore;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.client.GCCoreManualUtil;
import micdoodle8.mods.galacticraft.core.client.fx.GCCoreEffectHandler;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreInventoryTabGalacticraft;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreBlankPage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreBlockCastPage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreContentsTablePage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreCraftingPage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreFurnacePage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCorePicturePage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreSectionPage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreSidebarPage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreTextPage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreTitlePage;
import micdoodle8.mods.galacticraft.core.client.gui.page.GCCoreToolPage;
import micdoodle8.mods.galacticraft.core.client.model.GCCoreModelSpaceship;
import micdoodle8.mods.galacticraft.core.client.render.block.GCCoreBlockRendererBreathableAir;
import micdoodle8.mods.galacticraft.core.client.render.block.GCCoreBlockRendererCraftingTable;
import micdoodle8.mods.galacticraft.core.client.render.block.GCCoreBlockRendererLandingPad;
import micdoodle8.mods.galacticraft.core.client.render.block.GCCoreBlockRendererMachine;
import micdoodle8.mods.galacticraft.core.client.render.block.GCCoreBlockRendererMeteor;
import micdoodle8.mods.galacticraft.core.client.render.block.GCCoreBlockRendererOxygenPipe;
import micdoodle8.mods.galacticraft.core.client.render.block.GCCoreBlockRendererTreasureChest;
import micdoodle8.mods.galacticraft.core.client.render.block.GCCoreBlockRendererUnlitTorch;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderAlienVillager;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderArrow;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderBuggy;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderCreeper;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderFlag;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderLander;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderMeteor;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderMeteorChunk;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderOxygenBubble;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderParaChest;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderPlayer;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderSkeleton;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderSkeletonBoss;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderSpaceship;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderSpider;
import micdoodle8.mods.galacticraft.core.client.render.entities.GCCoreRenderZombie;
import micdoodle8.mods.galacticraft.core.client.render.item.GCCoreItemRendererBuggy;
import micdoodle8.mods.galacticraft.core.client.render.item.GCCoreItemRendererFlag;
import micdoodle8.mods.galacticraft.core.client.render.item.GCCoreItemRendererKey;
import micdoodle8.mods.galacticraft.core.client.render.item.GCCoreItemRendererMeteorChunk;
import micdoodle8.mods.galacticraft.core.client.render.item.GCCoreItemRendererSpaceship;
import micdoodle8.mods.galacticraft.core.client.render.item.GCCoreItemRendererUnlitTorch;
import micdoodle8.mods.galacticraft.core.client.render.tile.GCCoreRenderAluminumWire;
import micdoodle8.mods.galacticraft.core.client.render.tile.GCCoreTileEntityAdvancedCraftingTableRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.GCCoreTileEntityParachestRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.GCCoreTileEntitySolarPanelRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.GCCoreTileEntityTreasureChestRenderer;
import micdoodle8.mods.galacticraft.core.client.sounds.GCCoreSounds;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityArrow;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityCreeper;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityFlag;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityLander;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityMeteorChunk;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityOxygenBubble;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityParaChest;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityRocketT1;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySkeleton;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySkeletonBoss;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySpider;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityZombie;
import micdoodle8.mods.galacticraft.core.inventory.GCCoreInventoryExtended;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerClient;
import micdoodle8.mods.galacticraft.core.tick.GCCoreKeyHandlerClient;
import micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAdvancedCraftingTable;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityParachest;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntitySolar;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.wrappers.BlockMetaList;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import micdoodle8.mods.galacticraft.moon.client.ClientProxyMoon;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.EnumHelperClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Document;
import tconstruct.client.tabs.InventoryTabVanilla;
import tconstruct.client.tabs.TabRegistry;

public class ClientProxyCore
extends CommonProxyCore {
    private static int renderIdTreasureChest;
    private static int renderIdTorchUnlit;
    private static int renderIdBreathableAir;
    private static int renderIdOxygenPipe;
    private static int renderIdMeteor;
    private static int renderIdCraftingTable;
    private static int renderIdLandingPad;
    private static int renderIdMachine;
    private static int renderIndexHeavyArmor;
    private static int renderIndexSensorGlasses;
    public static ClientProxyMoon moon;
    public static List<ICelestialBodyRenderer> slotRenderers;
    public static Set<Vector3> valueableBlocks;
    public static HashSet<BlockMetaList> detectableBlocks;
    public static Set<PlayerGearData> playerItemData;
    public static double playerPosX;
    public static double playerPosY;
    public static double playerPosZ;
    public static float playerRotationYaw;
    public static float playerRotationPitch;
    public static String MODEL_DIRECTORY;
    public static boolean lastSpacebarDown;
    public static int clientSpaceStationID;
    public static ArrayList<SoundPoolEntry> newMusic;
    public static EnumRarity galacticraftItem;
    public static Map<String, String> capeMap;
    public static GCCoreInventoryExtended dummyInventory;
    public static Document materialsTest;
    private static final ResourceLocation underOilTexture;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        moon.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new GCCoreSounds());
        renderIndexSensorGlasses = RenderingRegistry.addNewArmourRendererPrefix((String)"sensor");
        renderIndexHeavyArmor = RenderingRegistry.addNewArmourRendererPrefix((String)"titanium");
    }

    @Override
    public void init(FMLInitializationEvent event) {
        moon.init(event);
        ClientProxyCore.registerHandlers();
        ClientProxyCore.registerManuals();
        ClientProxyCore.registerTileEntityRenderers();
        ClientProxyCore.registerBlockHandlers();
        ClientProxyCore.setupCapes();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        moon.postInit(event);
        ClientProxyCore.registerInventoryTabs();
        ClientProxyCore.registerMapObjects();
        ClientProxyCore.registerEntityRenderers();
        ClientProxyCore.registerItemRenderers();
    }

    public static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityRocketT1.class, (Render)new GCCoreRenderSpaceship(new GCCoreModelSpaceship(), GalacticraftCore.ASSET_DOMAIN, "rocketT1"));
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntitySpider.class, (Render)new GCCoreRenderSpider());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityZombie.class, (Render)new GCCoreRenderZombie());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityCreeper.class, (Render)new GCCoreRenderCreeper());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntitySkeleton.class, (Render)new GCCoreRenderSkeleton());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntitySkeletonBoss.class, (Render)new GCCoreRenderSkeletonBoss());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityMeteor.class, (Render)new GCCoreRenderMeteor());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityBuggy.class, (Render)new GCCoreRenderBuggy());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityMeteorChunk.class, (Render)new GCCoreRenderMeteorChunk());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityFlag.class, (Render)new GCCoreRenderFlag());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityParaChest.class, (Render)new GCCoreRenderParaChest());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlayer.class, (Render)new GCCoreRenderPlayer());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityAlienVillager.class, (Render)new GCCoreRenderAlienVillager());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityOxygenBubble.class, (Render)new GCCoreRenderOxygenBubble(0.25f, 0.25f, 1.0f));
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityLander.class, (Render)new GCCoreRenderLander());
        RenderingRegistry.registerEntityRenderingHandler(GCCoreEntityArrow.class, (Render)new GCCoreRenderArrow());
    }

    public static void registerItemRenderers() {
        MinecraftForgeClient.registerItemRenderer((int)GCCoreBlocks.unlitTorch.field_71990_ca, (IItemRenderer)new GCCoreItemRendererUnlitTorch());
        MinecraftForgeClient.registerItemRenderer((int)GCCoreItems.rocketTier1.field_77779_bT, (IItemRenderer)new GCCoreItemRendererSpaceship(new GCCoreEntityRocketT1((World)FMLClientHandler.instance().getClient().field_71441_e), new GCCoreModelSpaceship(), new ResourceLocation(GalacticraftCore.ASSET_DOMAIN, "textures/model/rocketT1.png")));
        MinecraftForgeClient.registerItemRenderer((int)GCCoreItems.buggy.field_77779_bT, (IItemRenderer)new GCCoreItemRendererBuggy());
        MinecraftForgeClient.registerItemRenderer((int)GCCoreItems.flag.field_77779_bT, (IItemRenderer)new GCCoreItemRendererFlag());
        MinecraftForgeClient.registerItemRenderer((int)GCCoreItems.key.field_77779_bT, (IItemRenderer)new GCCoreItemRendererKey(new ResourceLocation(GalacticraftCore.ASSET_DOMAIN, "textures/model/treasure.png")));
        MinecraftForgeClient.registerItemRenderer((int)GCCoreItems.meteorChunk.field_77779_bT, (IItemRenderer)new GCCoreItemRendererMeteorChunk());
    }

    public static void registerHandlers() {
        TickRegistry.registerTickHandler((ITickHandler)new GCCoreTickHandlerClient(), (Side)Side.CLIENT);
        NetworkRegistry.instance().registerChannel((IPacketHandler)new GCCorePacketHandlerClient(), "GalacticraftCore", Side.CLIENT);
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new GCCoreKeyHandlerClient());
    }

    public static void registerManuals() {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        materialsTest = GCCoreManualUtil.readManual("/assets/galacticraftcore/manuals/gettingstarted.xml", docBuilderFactory);
        ClientProxyCore.registerManualPages();
        ClientProxyCore.registerManualIcons();
    }

    private static void registerManualPages() {
        GCCoreManualUtil.registerManualPage("crafting", GCCoreCraftingPage.class);
        GCCoreManualUtil.registerManualPage("picture", GCCorePicturePage.class);
        GCCoreManualUtil.registerManualPage("text", GCCoreTextPage.class);
        GCCoreManualUtil.registerManualPage("intro", GCCoreTextPage.class);
        GCCoreManualUtil.registerManualPage("sectionpage", GCCoreSectionPage.class);
        GCCoreManualUtil.registerManualPage("intro", GCCoreTitlePage.class);
        GCCoreManualUtil.registerManualPage("contents", GCCoreContentsTablePage.class);
        GCCoreManualUtil.registerManualPage("furnace", GCCoreFurnacePage.class);
        GCCoreManualUtil.registerManualPage("sidebar", GCCoreSidebarPage.class);
        GCCoreManualUtil.registerManualPage("toolpage", GCCoreToolPage.class);
        GCCoreManualUtil.registerManualPage("blockcast", GCCoreBlockCastPage.class);
        GCCoreManualUtil.registerManualPage("blank", GCCoreBlankPage.class);
    }

    private static void registerManualIcons() {
        GCCoreManualUtil.registerIcon("heavyplatingT1", new ItemStack(GCCoreItems.heavyPlatingTier1));
        GCCoreManualUtil.registerIcon("oxygenmask", new ItemStack(GCCoreItems.oxMask));
        GCCoreManualUtil.registerIcon("oxygenTankHeavy", new ItemStack(GCCoreItems.oxTankHeavy));
        GCCoreManualUtil.registerIcon("rocketT1", new ItemStack(GCCoreItems.rocketTier1));
    }

    public static void registerTileEntityRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(GCCoreTileEntityAluminumWire.class, (TileEntitySpecialRenderer)new GCCoreRenderAluminumWire());
        ClientRegistry.bindTileEntitySpecialRenderer(GCCoreTileEntityTreasureChest.class, (TileEntitySpecialRenderer)new GCCoreTileEntityTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(GCCoreTileEntityParachest.class, (TileEntitySpecialRenderer)new GCCoreTileEntityParachestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(GCCoreTileEntityAdvancedCraftingTable.class, (TileEntitySpecialRenderer)new GCCoreTileEntityAdvancedCraftingTableRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(GCCoreTileEntitySolar.class, (TileEntitySpecialRenderer)new GCCoreTileEntitySolarPanelRenderer());
    }

    public static void registerBlockHandlers() {
        renderIdTreasureChest = RenderingRegistry.getNextAvailableRenderId();
        renderIdTorchUnlit = RenderingRegistry.getNextAvailableRenderId();
        renderIdBreathableAir = RenderingRegistry.getNextAvailableRenderId();
        renderIdOxygenPipe = RenderingRegistry.getNextAvailableRenderId();
        renderIdMeteor = RenderingRegistry.getNextAvailableRenderId();
        renderIdCraftingTable = RenderingRegistry.getNextAvailableRenderId();
        renderIdLandingPad = RenderingRegistry.getNextAvailableRenderId();
        renderIdMachine = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCCoreBlockRendererTreasureChest(renderIdTreasureChest));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCCoreBlockRendererUnlitTorch(renderIdTorchUnlit));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCCoreBlockRendererBreathableAir(renderIdBreathableAir));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCCoreBlockRendererOxygenPipe(renderIdOxygenPipe));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCCoreBlockRendererMeteor(renderIdMeteor));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCCoreBlockRendererCraftingTable(renderIdCraftingTable));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCCoreBlockRendererLandingPad(renderIdLandingPad));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new GCCoreBlockRendererMachine(renderIdMachine));
    }

    public static void setupCapes() {
        try {
            ClientProxyCore.updateCapeList();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error while setting up Galacticraft donor capes", (Object[])new Object[0]);
            e.printStackTrace();
        }
        if (Loader.isModLoaded((String)"CoFHCore")) {
            for (Map.Entry<String, String> e : capeMap.entrySet()) {
                try {
                    Object capeRegistry = Class.forName("cofh.api.core.RegistryAccess").getField("capeRegistry").get(null);
                    Class.forName("cofh.api.core.ISimpleRegistry").getMethod("register", String.class, String.class).invoke(capeRegistry, e.getKey(), e.getValue());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    break;
                }
            }
        }
    }

    private static void updateCapeList() throws Exception {
        String line;
        int timeout = 10000;
        URL capeListUrl = new URL("https://raw.github.com/micdoodle8/Galacticraft/master/capes.txt");
        URLConnection connection = capeListUrl.openConnection();
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        InputStream stream = connection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            if (!line.contains(":")) continue;
            int splitLocation = line.indexOf(":");
            String username = line.substring(0, splitLocation);
            String capeUrl = "https://raw.github.com/micdoodle8/Galacticraft/master/capes/" + line.substring(splitLocation + 1) + ".png";
            capeMap.put(username, capeUrl);
        }
    }

    public static void registerInventoryTabs() {
        if (!Loader.isModLoaded((String)"TConstruct") || TabRegistry.getTabList().size() < 3) {
            TabRegistry.registerTab(new InventoryTabVanilla());
        }
        TabRegistry.registerTab(new GCCoreInventoryTabGalacticraft());
    }

    public static void registerMapObjects() {
        for (ICelestialBody celestialObject : GalacticraftRegistry.getCelestialBodies()) {
            if (celestialObject.getMapObject() == null || !(celestialObject instanceof IPlanet)) continue;
            GalacticraftCore.mapPlanets.add((IPlanet)celestialObject);
            GalacticraftCore.mapMoons.put((IPlanet)celestialObject, new ArrayList());
        }
        for (ICelestialBody celestialObject : GalacticraftRegistry.getCelestialBodies()) {
            if (celestialObject.getMapObject() == null || !(celestialObject instanceof IMoon)) continue;
            ArrayList<IMoon> list = GalacticraftCore.mapMoons.get(((IMoon)celestialObject).getParentPlanet());
            list.add((IMoon)celestialObject);
            GalacticraftCore.mapMoons.put(((IMoon)celestialObject).getParentPlanet(), list);
        }
    }

    @Override
    public void registerRenderInformation() {
        moon.registerRenderInformation();
    }

    public static void renderPlanets(float par3) {
    }

    @Override
    public void addSlotRenderer(ICelestialBodyRenderer slotRenderer) {
        slotRenderers.add(slotRenderer);
    }

    @Override
    public int getBlockRenderID(int blockID) {
        if (blockID == GCCoreBlocks.treasureChestTier1.field_71990_ca) {
            return renderIdTreasureChest;
        }
        if (blockID == GCCoreBlocks.breatheableAir.field_71990_ca) {
            return renderIdBreathableAir;
        }
        if (blockID == GCCoreBlocks.oxygenPipe.field_71990_ca) {
            return renderIdOxygenPipe;
        }
        if (blockID == GCCoreBlocks.fallenMeteor.field_71990_ca) {
            return renderIdMeteor;
        }
        if (blockID == GCCoreBlocks.nasaWorkbench.field_71990_ca) {
            return renderIdCraftingTable;
        }
        if (blockID == GCCoreBlocks.landingPadFull.field_71990_ca) {
            return renderIdLandingPad;
        }
        if (blockID == GCCoreBlocks.unlitTorch.field_71990_ca || blockID == GCCoreBlocks.unlitTorchLit.field_71990_ca || blockID == GCCoreBlocks.glowstoneTorch.field_71990_ca) {
            return renderIdTorchUnlit;
        }
        if (blockID == GCCoreBlocks.fuelLoader.field_71990_ca || blockID == GCCoreBlocks.cargoLoader.field_71990_ca || blockID == GCCoreBlocks.machineBase.field_71990_ca || blockID == GCCoreBlocks.machineBase2.field_71990_ca || blockID == GCCoreBlocks.oxygenCollector.field_71990_ca || blockID == GCCoreBlocks.oxygenCompressor.field_71990_ca || blockID == GCCoreBlocks.oxygenDetector.field_71990_ca || blockID == GCCoreBlocks.oxygenDistributor.field_71990_ca || blockID == GCCoreBlocks.oxygenSealer.field_71990_ca || blockID == GCCoreBlocks.refinery.field_71990_ca) {
            return renderIdMachine;
        }
        return -1;
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public int getTitaniumArmorRenderIndex() {
        return renderIndexHeavyArmor;
    }

    @Override
    public int getSensorArmorRenderIndex() {
        return renderIndexSensorGlasses;
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion) {
        this.spawnParticle(particleID, position, motion, new Vector3(0.0, 0.0, 0.0));
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Vector3 color) {
        GCCoreEffectHandler.spawnParticle(particleID, position, motion, color);
    }

    public static void renderLiquidOverlays(float partialTicks) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        if (!ClientProxyCore.isInsideOfFluid((Entity)minecraft.field_71439_g, GalacticraftCore.fluidOil)) {
            return;
        }
        minecraft.func_110434_K().func_110577_a(underOilTexture);
        Tessellator tessellator = Tessellator.field_78398_a;
        float f1 = minecraft.field_71439_g.func_70013_c(partialTicks) / 3.0f;
        GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        float f2 = 4.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -1.0f;
        float f6 = 1.0f;
        float f7 = -0.5f;
        float f8 = -minecraft.field_71439_g.field_70177_z / 64.0f;
        float f9 = minecraft.field_71439_g.field_70125_A / 64.0f;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)f3, (double)f5, (double)f7, (double)(f2 + f8), (double)(f2 + f9));
        tessellator.func_78374_a((double)f4, (double)f5, (double)f7, (double)(0.0f + f8), (double)(f2 + f9));
        tessellator.func_78374_a((double)f4, (double)f6, (double)f7, (double)(0.0f + f8), (double)(0.0f + f9));
        tessellator.func_78374_a((double)f3, (double)f6, (double)f7, (double)(f2 + f8), (double)(0.0f + f9));
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public static boolean isInsideOfFluid(Entity entity, Fluid fluid) {
        int k;
        int j;
        double d0 = entity.field_70163_u + (double)entity.func_70047_e();
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int l = entity.field_70170_p.func_72798_a(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d0)), k = MathHelper.func_76128_c((double)entity.field_70161_v));
        Block block = Block.field_71973_m[l];
        if (block != null && block instanceof IFluidBlock && ((IFluidBlock)block).getFluid() != null && ((IFluidBlock)block).getFluid().getName().equals(fluid.getName())) {
            double filled = ((IFluidBlock)block).getFilledPercentage(entity.field_70170_p, i, j, k);
            if (filled < 0.0) {
                return d0 > (double)j + (1.0 - (filled *= -1.0));
            }
            return d0 < (double)j + filled;
        }
        return false;
    }

    static {
        moon = new ClientProxyMoon();
        slotRenderers = Lists.newArrayList();
        valueableBlocks = Sets.newHashSet();
        detectableBlocks = Sets.newHashSet();
        playerItemData = Sets.newHashSet();
        MODEL_DIRECTORY = "/assets/galacticraftcore/models/";
        clientSpaceStationID = 0;
        newMusic = new ArrayList();
        galacticraftItem = EnumHelperClient.addRarity((String)"GCRarity", (int)9, (String)"Space");
        capeMap = new HashMap<String, String>();
        dummyInventory = new GCCoreInventoryExtended();
        underOilTexture = new ResourceLocation(GalacticraftCore.ASSET_DOMAIN, "textures/misc/underoil.png");
    }
}

