/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCLog;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.client.fx.GCCoreEntityWeldingSmoke;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiBuggy;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiChoosePlanet;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiGalaxyMap;
import micdoodle8.mods.galacticraft.core.client.gui.GCCoreGuiParachest;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreSpaceStationData;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerSP;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemParachute;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketLanderUpdate;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketParachestUpdate;
import micdoodle8.mods.galacticraft.core.tick.GCCoreKeyHandlerClient;
import micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityConductor;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.input.Keyboard;

public class GCCorePacketHandlerClient
implements IPacketHandler {
    Minecraft mc = FMLClientHandler.instance().getClient();

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player p) {
        if (packet == null) {
            FMLLog.severe((String)"Packet received as null!", (Object[])new Object[0]);
            return;
        }
        if (packet.field_73629_c == null) {
            FMLLog.severe((String)("Packet data received as null! ID " + packet.func_73281_k()), (Object[])new Object[0]);
            return;
        }
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        EntityPlayer player = (EntityPlayer)p;
        GCCorePlayerSP playerBaseClient = null;
        if (player != null) {
            playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer(player);
        }
        EnumPacketClient packetType = EnumPacketClient.values()[PacketUtil.readPacketID(data)];
        Class<?>[] decodeAs = packetType.getDecodeClasses();
        Object[] packetReadout = PacketUtil.readPacketData(data, decodeAs);
        switch (packetType) {
            case AIR_REMAINING: {
                if (!String.valueOf(packetReadout[2]).equals(String.valueOf(FMLClientHandler.instance().getClient().field_71439_g.field_71092_bJ))) break;
                GCCoreTickHandlerClient.airRemaining = (Integer)packetReadout[0];
                GCCoreTickHandlerClient.airRemaining2 = (Integer)packetReadout[1];
                break;
            }
            case INVALID: {
                GCLog.severe("Found incorrect packet! Please report this as a bug.");
                break;
            }
            case UPDATE_DIMENSION_LIST: {
                if (!String.valueOf(packetReadout[0]).equals(FMLClientHandler.instance().getClient().field_71439_g.field_71092_bJ)) break;
                String[] destinations = ((String)packetReadout[1]).split("\\.");
                if (FMLClientHandler.instance().getClient().field_71441_e != null && !(FMLClientHandler.instance().getClient().field_71462_r instanceof GCCoreGuiChoosePlanet) && !(FMLClientHandler.instance().getClient().field_71462_r instanceof GCCoreGuiGalaxyMap)) {
                    FMLClientHandler.instance().getClient().func_71373_a((GuiScreen)new GCCoreGuiChoosePlanet((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, destinations));
                    break;
                }
                if (!(FMLClientHandler.instance().getClient().field_71462_r instanceof GCCoreGuiChoosePlanet)) break;
                ((GCCoreGuiChoosePlanet)FMLClientHandler.instance().getClient().field_71462_r).updateDimensionList(destinations);
                break;
            }
            case UNUSED_0: {
                break;
            }
            case UNUSED_1: {
                break;
            }
            case UNUSED_2: {
                break;
            }
            case UNUSED_3: {
                break;
            }
            case UNUSED_4: {
                break;
            }
            case MOUNT_ROCKET: {
                if (playerBaseClient != null) {
                    playerBaseClient.setThirdPersonView(FMLClientHandler.instance().getClient().field_71474_y.field_74320_O);
                }
                FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = 1;
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)"SPACE - Launch"));
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)"A / D  - Turn left-right"));
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)"W / S  - Turn up-down"));
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)(Keyboard.getKeyName((int)GCCoreKeyHandlerClient.openSpaceshipInv.field_74512_d) + "       - Inventory / Fuel")));
                break;
            }
            case SPAWN_SPARK_PARTICLES: {
                int x = (Integer)packetReadout[0];
                int y = (Integer)packetReadout[1];
                int z = (Integer)packetReadout[2];
                for (int i = 0; i < 4; ++i) {
                    GCCoreEntityWeldingSmoke fx;
                    if (this.mc == null || this.mc.field_71451_h == null || this.mc.field_71452_i == null || this.mc.field_71441_e == null || (fx = new GCCoreEntityWeldingSmoke((World)this.mc.field_71441_e, (double)x - 0.15 + 0.5, (double)y + 1.2, (double)z + 0.15 + 0.5, this.mc.field_71441_e.field_73012_v.nextDouble() / 20.0 - this.mc.field_71441_e.field_73012_v.nextDouble() / 20.0, 0.06, this.mc.field_71441_e.field_73012_v.nextDouble() / 20.0 - this.mc.field_71441_e.field_73012_v.nextDouble() / 20.0, 1.0f)) == null) continue;
                    this.mc.field_71452_i.func_78873_a((EntityFX)fx);
                }
                break;
            }
            case UPDATE_GEAR_SLOT: {
                PlayerGearData gearData = null;
                int subtype = (Integer)packetReadout[2];
                for (PlayerGearData gearData2 : ClientProxyCore.playerItemData) {
                    if (!gearData2.getPlayer().field_71092_bJ.equals(packetReadout[0])) continue;
                    gearData = gearData2;
                    break;
                }
                if (gearData == null) {
                    gearData = new PlayerGearData(player);
                }
                switch (GCCorePlayerMP.EnumModelPacket.values()[(Integer)packetReadout[1]]) {
                    case ADDMASK: {
                        gearData.setMask(0);
                        break;
                    }
                    case REMOVEMASK: {
                        gearData.setMask(-1);
                        break;
                    }
                    case ADDGEAR: {
                        gearData.setGear(0);
                        break;
                    }
                    case REMOVEGEAR: {
                        gearData.setGear(-1);
                        break;
                    }
                    case ADDLEFTGREENTANK: {
                        gearData.setLeftTank(0);
                        break;
                    }
                    case ADDLEFTORANGETANK: {
                        gearData.setLeftTank(1);
                        break;
                    }
                    case ADDLEFTREDTANK: {
                        gearData.setLeftTank(2);
                        break;
                    }
                    case ADDRIGHTGREENTANK: {
                        gearData.setRightTank(0);
                        break;
                    }
                    case ADDRIGHTORANGETANK: {
                        gearData.setRightTank(1);
                        break;
                    }
                    case ADDRIGHTREDTANK: {
                        gearData.setRightTank(2);
                        break;
                    }
                    case REMOVE_LEFT_TANK: {
                        gearData.setLeftTank(-1);
                        break;
                    }
                    case REMOVE_RIGHT_TANK: {
                        gearData.setRightTank(-1);
                        break;
                    }
                    case ADD_PARACHUTE: {
                        String name = "";
                        if (subtype == -1) break;
                        name = GCCoreItemParachute.names[subtype];
                        gearData.setParachute(new ResourceLocation(GalacticraftCore.ASSET_DOMAIN, "textures/model/parachute/" + name + ".png"));
                        break;
                    }
                    case REMOVE_PARACHUTE: {
                        gearData.setParachute(null);
                        break;
                    }
                    case ADD_FREQUENCY_MODULE: {
                        gearData.setFrequencyModule(0);
                        break;
                    }
                    case REMOVE_FREQUENCY_MODULE: {
                        gearData.setFrequencyModule(-1);
                        break;
                    }
                }
                ClientProxyCore.playerItemData.add(gearData);
                break;
            }
            case UNUSED_5: {
                break;
            }
            case CLOSE_GUI: {
                FMLClientHandler.instance().getClient().func_71373_a(null);
                break;
            }
            case RESET_THIRD_PERSON: {
                if (playerBaseClient == null) break;
                FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = playerBaseClient.getThirdPersonView();
                break;
            }
            case UPDATE_CONTROLLABLE_ENTITY: {
                try {
                    new GCCorePacketEntityUpdate().handlePacket(data, new Object[]{player}, Side.SERVER);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case UNUSED_6: {
                break;
            }
            case UPDATE_SPACESTATION_LIST: {
                if (WorldUtil.registeredSpaceStations == null) {
                    WorldUtil.registeredSpaceStations = new ArrayList<Integer>();
                }
                try {
                    int var1 = data.readInt();
                    for (int var2 = 0; var2 < var1; ++var2) {
                        int var3 = data.readInt();
                        if (WorldUtil.registeredSpaceStations.contains(var3)) continue;
                        WorldUtil.registeredSpaceStations.add(var3);
                        DimensionManager.registerDimension((int)var3, (int)GCCoreConfigManager.idDimensionOverworldOrbit);
                    }
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case UPDATE_SPACESTATION_DATA: {
                try {
                    NBTTagCompound var3;
                    int var2 = data.readInt();
                    short var1 = data.readShort();
                    if (var1 < 0) {
                        var3 = null;
                    } else {
                        byte[] var21 = new byte[var1];
                        data.readFully(var21);
                        var3 = CompressedStreamTools.func_74792_a((byte[])var21);
                    }
                    GCCoreSpaceStationData var4 = GCCoreSpaceStationData.getMPSpaceStationData(player.field_70170_p, var2, player);
                    var4.func_76184_a(var3);
                }
                catch (IOException var5) {
                    var5.printStackTrace();
                }
                break;
            }
            case UPDATE_SPACESTATION_CLIENT_ID: {
                ClientProxyCore.clientSpaceStationID = (Integer)packetReadout[0];
                break;
            }
            case UPDATE_PLANETS_LIST: {
                if (WorldUtil.registeredPlanets == null) {
                    WorldUtil.registeredPlanets = new ArrayList<Integer>();
                }
                try {
                    int var1 = data.readInt();
                    for (int var2 = 0; var2 < var1; ++var2) {
                        int var3 = data.readInt();
                        if (WorldUtil.registeredPlanets.contains(var3)) continue;
                        WorldUtil.registeredPlanets.add(var3);
                        DimensionManager.registerDimension((int)var3, (int)var3);
                    }
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case ADD_NEW_SCHEMATIC: {
                ISchematicPage page;
                if (playerBaseClient == null || playerBaseClient.unlockedSchematics.contains(page = SchematicRegistry.getMatchingRecipeForID((Integer)packetReadout[0]))) break;
                playerBaseClient.unlockedSchematics.add(page);
                break;
            }
            case UPDATE_SCHEMATIC_LIST: {
                if (playerBaseClient == null) break;
                try {
                    int var1 = data.readInt();
                    for (int var2 = 0; var2 < var1; ++var2) {
                        int var3 = data.readInt();
                        if (var3 == -2) continue;
                        Collections.sort(playerBaseClient.unlockedSchematics);
                        if (playerBaseClient.unlockedSchematics.contains(SchematicRegistry.getMatchingRecipeForID(var3))) continue;
                        playerBaseClient.unlockedSchematics.add(SchematicRegistry.getMatchingRecipeForID(var3));
                    }
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case ZOOM_CAMERA: {
                GCCoreTickHandlerClient.zoom((Integer)packetReadout[0] == 0 ? 4.0f : 15.0f);
                break;
            }
            case PLAY_SOUND_BOSS_DEATH: {
                player.func_85030_a(GalacticraftCore.ASSET_PREFIX + "entity.bossdeath", 10.0f, 0.8f);
                break;
            }
            case PLAY_SOUND_EXPLODE: {
                player.func_85030_a("random.explode", 10.0f, 0.7f);
                break;
            }
            case PLAY_SOUND_BOSS_LAUGH: {
                player.func_85030_a(GalacticraftCore.ASSET_PREFIX + "entity.bosslaugh", 10.0f, 0.2f);
                break;
            }
            case PLAY_SOUND_BOW: {
                player.func_85030_a("random.bow", 10.0f, 0.2f);
                break;
            }
            case UPDATE_OXYGEN_VALIDITY: {
                if (playerBaseClient == null) break;
                playerBaseClient.oxygenSetupValid = (Boolean)packetReadout[0];
                break;
            }
            case OPEN_PARACHEST_GUI: {
                switch ((Integer)packetReadout[1]) {
                    case 0: {
                        if (!(player.field_70154_o instanceof GCCoreEntityBuggy)) break;
                        FMLClientHandler.instance().getClient().func_71373_a((GuiScreen)new GCCoreGuiBuggy((IInventory)player.field_71071_by, (GCCoreEntityBuggy)player.field_70154_o, ((GCCoreEntityBuggy)player.field_70154_o).getType()));
                        player.field_71070_bA.field_75152_c = (Integer)packetReadout[0];
                        break;
                    }
                    case 1: {
                        int entityID = (Integer)packetReadout[2];
                        Entity entity = player.field_70170_p.func_73045_a(entityID);
                        if (entity != null && entity instanceof IInventorySettable) {
                            FMLClientHandler.instance().getClient().func_71373_a((GuiScreen)new GCCoreGuiParachest((IInventory)player.field_71071_by, (IInventorySettable)entity));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)packetReadout[0];
                    }
                }
                break;
            }
            case UPDATE_LANDER: {
                try {
                    new GCCorePacketLanderUpdate().handlePacket(data, new Object[]{player}, Side.CLIENT);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                break;
            }
            case UPDATE_PARACHEST: {
                try {
                    new GCCorePacketParachestUpdate().handlePacket(data, new Object[]{player}, Side.CLIENT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case UPDATE_WIRE_BOUNDS: {
                TileEntity tile = player.field_70170_p.func_72796_p(((Integer)packetReadout[0]).intValue(), ((Integer)packetReadout[1]).intValue(), ((Integer)packetReadout[2]).intValue());
                if (!(tile instanceof GCCoreTileEntityConductor)) break;
                ((GCCoreTileEntityConductor)tile).adjacentConnections = null;
                Block.field_71973_m[player.field_70170_p.func_72798_a(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)].func_71902_a((IBlockAccess)player.field_70170_p, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
            }
        }
    }

    public static enum EnumPacketClient {
        AIR_REMAINING(0, Integer.class, Integer.class, String.class),
        INVALID(1, new Class[0]),
        UPDATE_DIMENSION_LIST(2, String.class, String.class),
        UNUSED_0(3, new Class[0]),
        UNUSED_1(4, new Class[0]),
        UNUSED_2(5, new Class[0]),
        UNUSED_3(6, new Class[0]),
        UNUSED_4(7, new Class[0]),
        MOUNT_ROCKET(8, String.class),
        SPAWN_SPARK_PARTICLES(9, Integer.class, Integer.class, Integer.class),
        UPDATE_GEAR_SLOT(10, String.class, Integer.class, Integer.class),
        UNUSED_5(11, new Class[0]),
        CLOSE_GUI(12, new Class[0]),
        RESET_THIRD_PERSON(13, String.class),
        UPDATE_CONTROLLABLE_ENTITY(14, new Class[0]),
        UNUSED_6(15, new Class[0]),
        UPDATE_SPACESTATION_LIST(16, new Class[0]),
        UPDATE_SPACESTATION_DATA(17, new Class[0]),
        UPDATE_SPACESTATION_CLIENT_ID(18, Integer.class),
        UPDATE_PLANETS_LIST(19, new Class[0]),
        ADD_NEW_SCHEMATIC(20, Integer.class),
        UPDATE_SCHEMATIC_LIST(21, new Class[0]),
        ZOOM_CAMERA(22, Integer.class),
        PLAY_SOUND_BOSS_DEATH(23, new Class[0]),
        PLAY_SOUND_EXPLODE(24, new Class[0]),
        PLAY_SOUND_BOSS_LAUGH(25, new Class[0]),
        PLAY_SOUND_BOW(26, new Class[0]),
        UPDATE_OXYGEN_VALIDITY(27, Boolean.class),
        OPEN_PARACHEST_GUI(28, Integer.class, Integer.class, Integer.class),
        UPDATE_LANDER(29, new Class[0]),
        UPDATE_PARACHEST(30, new Class[0]),
        UPDATE_WIRE_BOUNDS(31, Integer.class, Integer.class, Integer.class);

        private int index;
        private Class<?>[] decodeAs;

        private EnumPacketClient(int index, Class<?> ... decodeAs) {
            this.index = index;
            this.decodeAs = decodeAs;
        }

        public int getIndex() {
            return this.index;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

