/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import cpw.mods.fml.common.FMLLog;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.oxygen.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ThreadFindSeal
extends Thread {
    public World world;
    public Vector3 head;
    public boolean sealed;
    public List<GCCoreTileEntityOxygenSealer> sealers;
    public List<Vector3> oxygenReliantBlocks;
    public HashSet<OxygenPressureProtocol.VecDirPair> checked;
    public int checkCount;
    public boolean looping;

    public ThreadFindSeal() {
        super("GC Sealer Roomfinder Thread");
    }

    @Override
    public void run() {
        TileEntity headTile;
        int blockID;
        long time1 = System.nanoTime();
        this.sealed = true;
        this.looping = true;
        this.loopThrough(this.head.clone().translate(new Vector3(0.0, 1.0, 0.0)));
        if (this.sealers.size() > 1) {
            this.checkCount = 0;
            for (int i = 0; i < this.sealers.size(); ++i) {
                GCCoreTileEntityOxygenSealer sealer = this.sealers.get(i);
                this.checkCount += sealer.getFindSealChecks();
            }
            this.sealed = true;
            this.checked.clear();
            this.loopThrough(this.head.clone().translate(new Vector3(0.0, 1.0, 0.0)));
        }
        long time2 = System.nanoTime();
        if (this.sealed) {
            for (OxygenPressureProtocol.VecDirPair checkedVec : this.checked) {
                blockID = checkedVec.getPosition().getBlockID((IBlockAccess)this.world);
                if (!this.sealed || blockID != 0) continue;
                GCCoreTickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, new ScheduledBlockChange(checkedVec.getPosition(), GCCoreBlocks.breatheableAir.field_71990_ca, 0, 3));
            }
        } else {
            this.checked.clear();
            this.loopThroughD(this.head.clone().translate(new Vector3(0.0, 1.0, 0.0)));
            for (OxygenPressureProtocol.VecDirPair checkedVec : this.checked) {
                blockID = checkedVec.getPosition().getBlockID((IBlockAccess)this.world);
                if (blockID != GCCoreBlocks.breatheableAir.field_71990_ca) continue;
                GCCoreTickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, new ScheduledBlockChange(checkedVec.getPosition(), 0, 0, 3));
            }
        }
        if ((headTile = this.head.getTileEntity((IBlockAccess)this.world)) instanceof GCCoreTileEntityOxygenSealer) {
            GCCoreTileEntityOxygenSealer headSealer = (GCCoreTileEntityOxygenSealer)headTile;
            for (GCCoreTileEntityOxygenSealer sealer : this.sealers) {
                if (sealer == null || headSealer == sealer || headSealer.stopSealThreadCooldown > sealer.stopSealThreadCooldown) continue;
                sealer.threadSeal = this;
                sealer.stopSealThreadCooldown = 100;
            }
        }
        long time3 = System.nanoTime();
        this.looping = false;
        if (GCCoreConfigManager.enableDebug) {
            FMLLog.info((String)("Oxygen Sealer Check Completed at x" + this.head.intX() + " y" + this.head.intY() + " z" + this.head.intZ()), (Object[])new Object[0]);
            FMLLog.info((String)("   Sealed: " + this.sealed), (Object[])new Object[0]);
            FMLLog.info((String)("   Loop Time taken: " + (double)(time2 - time1) / 1000000.0 + "ms"), (Object[])new Object[0]);
            FMLLog.info((String)("   Place Time taken: " + (double)(time3 - time2) / 1000000.0 + "ms"), (Object[])new Object[0]);
            FMLLog.info((String)("   Total Time taken: " + (double)(time3 - time1) / 1000000.0 + "ms"), (Object[])new Object[0]);
            FMLLog.info((String)("   Found: " + this.sealers.size() + " sealers"), (Object[])new Object[0]);
            FMLLog.info((String)("   Looped through: " + this.checked.size() + " blocks"), (Object[])new Object[0]);
        }
    }

    private void loopThroughD(Vector3 vec) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Vector3 sideVec = vec.clone().modifyPositionFromSide(dir);
            OxygenPressureProtocol.VecDirPair pair = new OxygenPressureProtocol.VecDirPair(sideVec, dir);
            if (this.checked(pair)) continue;
            this.check(pair);
            if (!this.breathableAirAdjacent(pair)) continue;
            this.loopThroughD(sideVec);
        }
    }

    private void loopThrough(Vector3 vec) {
        block5: {
            if (!this.sealed) break block5;
            if (this.checkCount > 0) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tileAtVec;
                    Vector3 sideVec = vec.clone().modifyPositionFromSide(dir);
                    OxygenPressureProtocol.VecDirPair pair = new OxygenPressureProtocol.VecDirPair(sideVec, dir);
                    if (this.checked(pair)) continue;
                    --this.checkCount;
                    this.check(pair);
                    if (WorldUtil.canBlockPass(this.world, pair)) {
                        this.loopThrough(sideVec);
                    }
                    if ((tileAtVec = sideVec.getTileEntity((IBlockAccess)this.world)) == null || !(tileAtVec instanceof GCCoreTileEntityOxygenSealer) || this.sealers.contains(tileAtVec)) continue;
                    GCCoreTileEntityOxygenSealer sealer = (GCCoreTileEntityOxygenSealer)tileAtVec;
                    if (!sealer.active) continue;
                    this.sealers.add(sealer);
                }
            } else {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    Vector3 sideVec = vec.clone().modifyPositionFromSide(dir);
                    if (sideVec.getBlockID((IBlockAccess)this.world) != 0 && sideVec.getBlockID((IBlockAccess)this.world) != GCCoreBlocks.breatheableAir.field_71990_ca || this.checked(sideVec, dir)) continue;
                    this.sealed = false;
                }
            }
        }
    }

    private boolean checked(Vector3 vec, ForgeDirection dir) {
        return this.checked(new OxygenPressureProtocol.VecDirPair(vec, dir));
    }

    private boolean checked(OxygenPressureProtocol.VecDirPair pair) {
        return this.checked.contains(pair);
    }

    private void check(OxygenPressureProtocol.VecDirPair pair) {
        this.checked.add(pair);
    }

    private boolean breathableAirAdjacent(OxygenPressureProtocol.VecDirPair pair) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Vector3 vec = pair.getPosition().clone().modifyPositionFromSide(dir);
            if (!this.isBreathableAir(new OxygenPressureProtocol.VecDirPair(vec, dir))) continue;
            return true;
        }
        return false;
    }

    private boolean isBreathableAir(OxygenPressureProtocol.VecDirPair pair) {
        return pair.getPosition().getBlockID((IBlockAccess)this.world) == GCCoreBlocks.breatheableAir.field_71990_ca;
    }
}

