/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.tile.AirLockProtocol;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAirLock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class GCCoreTileEntityAirLockController
extends GCCoreTileEntityAirLock {
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean redstoneActivation;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean playerDistanceActivation;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public int playerDistanceSelection;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean playerNameMatches;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public String playerToOpenFor = "";
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean invertSelection;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean horizontalModeEnabled;
    public boolean lastHorizontalModeEnabled;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    protected String ownerName = "";
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean active;
    public boolean lastActive;
    public ArrayList<GCCoreTileEntityAirLock> otherAirLocks;
    public ArrayList<GCCoreTileEntityAirLock> lastOtherAirLocks;
    private AirLockProtocol protocol;
    private AirLockProtocol lastProtocol = this.protocol;

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            boolean optionHandled = false;
            if (this.redstoneActivation) {
                optionHandled = true;
                this.active = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            if (this.playerDistanceActivation) {
                optionHandled = true;
                double distance = 0.0;
                switch (this.playerDistanceSelection) {
                    case 0: {
                        distance = 1.0;
                        break;
                    }
                    case 1: {
                        distance = 2.0;
                        break;
                    }
                    case 2: {
                        distance = 5.0;
                        break;
                    }
                    case 3: {
                        distance = 10.0;
                    }
                }
                Vector3 thisPos = new Vector3(this).translate(0.5);
                Vector3 minPos = new Vector3(thisPos).translate(-distance);
                Vector3 maxPos = new Vector3(thisPos).translate(distance);
                AxisAlignedBB matchingRegion = AxisAlignedBB.func_72330_a((double)minPos.x, (double)minPos.y, (double)minPos.z, (double)maxPos.x, (double)maxPos.y, (double)maxPos.z);
                List playersWithin = this.field_70331_k.func_72872_a(EntityPlayer.class, matchingRegion);
                boolean foundPlayer = false;
                for (int i = 0; i < playersWithin.size(); ++i) {
                    Object o = playersWithin.get(i);
                    if (!(o instanceof EntityPlayer)) continue;
                    if (this.playerNameMatches) {
                        if (!((EntityPlayer)o).field_71092_bJ.equalsIgnoreCase(this.playerToOpenFor)) continue;
                        foundPlayer = true;
                        break;
                    }
                    foundPlayer = true;
                    break;
                }
                boolean bl = this.active = !foundPlayer;
            }
            if (!optionHandled) {
                this.active = false;
            }
            if (this.invertSelection) {
                boolean bl = this.active = !this.active;
            }
            if (this.protocol == null) {
                this.protocol = this.lastProtocol = new AirLockProtocol(this, 40);
            }
            if (this.ticks % 10L == 0L) {
                if (this.horizontalModeEnabled != this.lastHorizontalModeEnabled) {
                    this.unsealAirLock();
                } else {
                    this.otherAirLocks = this.protocol.calculate(this.horizontalModeEnabled);
                    if (this.active && (this.otherAirLocks != null || this.otherAirLocks != null && this.lastOtherAirLocks != null && this.otherAirLocks != this.lastOtherAirLocks || this.otherAirLocks != null && this.lastOtherAirLocks != null && this.otherAirLocks.size() != this.lastOtherAirLocks.size())) {
                        this.sealAirLock();
                    } else if (!this.active && this.lastActive || this.otherAirLocks == null && this.lastOtherAirLocks != null) {
                        this.unsealAirLock();
                    }
                }
                if (this.active != this.lastActive) {
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
                this.lastActive = this.active;
                this.lastOtherAirLocks = this.otherAirLocks;
                this.lastProtocol = this.protocol;
                this.lastHorizontalModeEnabled = this.horizontalModeEnabled;
            }
        }
    }

    public void sealAirLock() {
        block11: {
            int z;
            int y;
            int x;
            block10: {
                x = this.lastProtocol.minX + (this.lastProtocol.maxX - this.lastProtocol.minX) / 2;
                y = this.lastProtocol.minY + (this.lastProtocol.maxY - this.lastProtocol.minY) / 2;
                z = this.lastProtocol.minZ + (this.lastProtocol.maxZ - this.lastProtocol.minZ) / 2;
                if (this.field_70331_k.func_72798_a(x, y, z) != GCCoreBlocks.airLockSeal.field_71990_ca) {
                    this.field_70331_k.func_72908_a((double)x, (double)y, (double)z, GalacticraftCore.ASSET_PREFIX + "player.openairlock", 1.0f, 1.0f);
                }
                if (!this.horizontalModeEnabled) break block10;
                if (this.protocol.minY != this.protocol.maxY || this.protocol.minX == this.protocol.maxX || this.protocol.minZ == this.protocol.maxZ) break block11;
                for (x = this.protocol.minX + 1; x <= this.protocol.maxX - 1; ++x) {
                    for (z = this.protocol.minZ + 1; z <= this.protocol.maxZ - 1; ++z) {
                        int id = this.field_70331_k.func_72798_a(x, y, z);
                        if (id != 0 && !Block.field_71973_m[id].isAirBlock(this.field_70331_k, x, y, z)) continue;
                        this.field_70331_k.func_72832_d(x, this.protocol.minY, z, GCCoreBlocks.airLockSeal.field_71990_ca, 0, 3);
                    }
                }
                break block11;
            }
            if (this.protocol.minX != this.protocol.maxX) {
                for (x = this.protocol.minX + 1; x <= this.protocol.maxX - 1; ++x) {
                    for (y = this.protocol.minY + 1; y <= this.protocol.maxY - 1; ++y) {
                        int id = this.field_70331_k.func_72798_a(x, y, z);
                        if (id != 0 && !Block.field_71973_m[id].isAirBlock(this.field_70331_k, x, y, z)) continue;
                        this.field_70331_k.func_72832_d(x, y, this.protocol.minZ, GCCoreBlocks.airLockSeal.field_71990_ca, 0, 3);
                    }
                }
            } else if (this.protocol.minZ != this.protocol.maxZ) {
                for (z = this.protocol.minZ + 1; z <= this.protocol.maxZ - 1; ++z) {
                    for (y = this.protocol.minY + 1; y <= this.protocol.maxY - 1; ++y) {
                        int id = this.field_70331_k.func_72798_a(x, y, z);
                        if (id != 0 && !Block.field_71973_m[id].isAirBlock(this.field_70331_k, x, y, z)) continue;
                        this.field_70331_k.func_72832_d(this.protocol.minX, y, z, GCCoreBlocks.airLockSeal.field_71990_ca, 0, 3);
                    }
                }
            }
        }
    }

    public void unsealAirLock() {
        block12: {
            int z;
            int y;
            int x;
            block11: {
                if (this.lastProtocol == null) {
                    return;
                }
                x = this.lastProtocol.minX + (this.lastProtocol.maxX - this.lastProtocol.minX) / 2;
                y = this.lastProtocol.minY + (this.lastProtocol.maxY - this.lastProtocol.minY) / 2;
                z = this.lastProtocol.minZ + (this.lastProtocol.maxZ - this.lastProtocol.minZ) / 2;
                if (this.field_70331_k.func_72798_a(x, y, z) != 0) {
                    this.field_70331_k.func_72908_a((double)x, (double)y, (double)z, GalacticraftCore.ASSET_PREFIX + "player.closeairlock", 1.0f, 1.0f);
                }
                if (!this.lastHorizontalModeEnabled) break block11;
                if (this.protocol.minY != this.protocol.maxY || this.protocol.minX == this.protocol.maxX || this.protocol.minZ == this.protocol.maxZ) break block12;
                for (x = this.protocol.minX + 1; x <= this.protocol.maxX - 1; ++x) {
                    for (z = this.protocol.minZ + 1; z <= this.protocol.maxZ - 1; ++z) {
                        int id = this.field_70331_k.func_72798_a(x, y, z);
                        if (id != GCCoreBlocks.airLockSeal.field_71990_ca) continue;
                        this.field_70331_k.func_94571_i(x, this.protocol.minY, z);
                    }
                }
                break block12;
            }
            if (this.lastProtocol.minX != this.lastProtocol.maxX) {
                for (x = this.lastProtocol.minX + 1; x <= this.lastProtocol.maxX - 1; ++x) {
                    for (y = this.lastProtocol.minY + 1; y <= this.lastProtocol.maxY - 1; ++y) {
                        int id = this.field_70331_k.func_72798_a(x, y, z);
                        if (id != GCCoreBlocks.airLockSeal.field_71990_ca) continue;
                        this.field_70331_k.func_94571_i(x, y, this.lastProtocol.minZ);
                    }
                }
            } else if (this.lastProtocol.minZ != this.lastProtocol.maxZ) {
                for (z = this.lastProtocol.minZ + 1; z <= this.lastProtocol.maxZ - 1; ++z) {
                    for (y = this.lastProtocol.minY + 1; y <= this.lastProtocol.maxY - 1; ++y) {
                        int id = this.field_70331_k.func_72798_a(x, y, z);
                        if (id != GCCoreBlocks.airLockSeal.field_71990_ca) continue;
                        this.field_70331_k.func_94571_i(this.lastProtocol.minX, y, z);
                    }
                }
            }
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.ownerName = nbt.func_74779_i("OwnerName");
        this.redstoneActivation = nbt.func_74767_n("RedstoneActivation");
        this.playerDistanceActivation = nbt.func_74767_n("PlayerDistanceActivation");
        this.playerDistanceSelection = nbt.func_74762_e("PlayerDistanceSelection");
        this.playerNameMatches = nbt.func_74767_n("PlayerNameMatches");
        this.playerToOpenFor = nbt.func_74779_i("PlayerToOpenFor");
        this.invertSelection = nbt.func_74767_n("InvertSelection");
        this.active = nbt.func_74767_n("active");
        this.lastActive = nbt.func_74767_n("lastActive");
        this.horizontalModeEnabled = nbt.func_74767_n("HorizontalModeEnabled");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74778_a("OwnerName", this.ownerName);
        nbt.func_74757_a("RedstoneActivation", this.redstoneActivation);
        nbt.func_74757_a("PlayerDistanceActivation", this.playerDistanceActivation);
        nbt.func_74768_a("PlayerDistanceSelection", this.playerDistanceSelection);
        nbt.func_74757_a("PlayerNameMatches", this.playerNameMatches);
        nbt.func_74778_a("PlayerToOpenFor", this.playerToOpenFor);
        nbt.func_74757_a("InvertSelection", this.invertSelection);
        nbt.func_74757_a("active", this.active);
        nbt.func_74757_a("lastActive", this.lastActive);
        nbt.func_74757_a("HorizontalModeEnabled", this.horizontalModeEnabled);
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public double getPacketRange() {
        return 20.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }
}

