/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.api.transmission.core.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemOilCanister;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityElectricBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class GCCoreTileEntityRefinery
extends GCCoreTileEntityElectricBlock
implements IInventory,
ISidedInventory,
IFluidHandler {
    private final int tankCapacity = 24000;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank oilTank = new FluidTank(this.tankCapacity);
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public static final float WATTS_PER_TICK = 0.4f;
    public static final int PROCESS_TIME_REQUIRED = 2;
    public static final int OUTPUT_PER_SECOND = 1;
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack[] containingItems = new ItemStack[3];

    public GCCoreTileEntityRefinery() {
        super(0.4f, 50.0f);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            FluidStack liquid;
            if (this.containingItems[1] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1])) != null && FluidRegistry.getFluidName((FluidStack)liquid).equalsIgnoreCase("Oil") && (this.oilTank.getFluid() == null || this.oilTank.getFluid().amount + liquid.amount <= this.oilTank.getCapacity())) {
                this.oilTank.fill(liquid, true);
                if (this.containingItems[1].func_77973_b() instanceof GCCoreItemOilCanister) {
                    this.containingItems[1] = new ItemStack(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.func_77612_l());
                } else if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[1]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[1])) {
                    int amount = this.containingItems[1].field_77994_a;
                    this.containingItems[1] = new ItemStack(Item.field_77788_aw, amount);
                } else {
                    --this.containingItems[1].field_77994_a;
                    if (this.containingItems[1].field_77994_a == 0) {
                        this.containingItems[1] = null;
                    }
                }
            }
            if (this.containingItems[2] != null && FluidContainerRegistry.isContainer((ItemStack)this.containingItems[2]) && (liquid = this.fuelTank.getFluid()) != null && this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid().getName().equalsIgnoreCase("Fuel") && FluidContainerRegistry.isEmptyContainer((ItemStack)this.containingItems[2])) {
                boolean isCanister = this.containingItems[2].func_77969_a(new ItemStack(GCCoreItems.oilCanister, 1, GCCoreItems.oilCanister.func_77612_l()));
                int amountToFill = Math.min(liquid.amount, isCanister ? GCCoreItems.fuelCanister.func_77612_l() - 1 : 1000);
                this.containingItems[2] = isCanister ? new ItemStack(GCCoreItems.fuelCanister, 1, GCCoreItems.fuelCanister.func_77612_l() - amountToFill) : FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)this.containingItems[2]);
                this.fuelTank.drain(amountToFill, true);
            }
            if (this.canProcess()) {
                if (this.processTicks == 0) {
                    this.processTicks = 2;
                } else if (this.processTicks > 0) {
                    --this.processTicks;
                    if (this.processTicks < 1) {
                        this.smeltItem();
                        this.processTicks = 0;
                    }
                } else {
                    this.processTicks = 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public int getScaledOilLevel(int i) {
        return this.oilTank.getFluid() != null ? this.oilTank.getFluid().amount * i / this.oilTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getFluid() != null ? this.fuelTank.getFluid().amount * i / this.fuelTank.getCapacity() : 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean canProcess() {
        if (this.oilTank.getFluid() == null || this.oilTank.getFluid().amount <= 0) {
            return false;
        }
        if (this.getDisabled(0)) {
            return false;
        }
        return this.getEnergyStored() != 0.0f;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int oilAmount = this.oilTank.getFluid().amount;
            int fuelSpace = this.fuelTank.getCapacity() - (this.fuelTank.getFluid() == null ? 0 : this.fuelTank.getFluid().amount);
            int amountToDrain = Math.min(Math.min(oilAmount, fuelSpace), 1);
            this.oilTank.drain(amountToDrain, true);
            this.fuelTank.fill(FluidRegistry.getFluidStack((String)"fuel", (int)amountToDrain), true);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        NBTTagList var2 = nbt.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        if (nbt.func_74764_b("oilTank")) {
            this.oilTank.readFromNBT(nbt.func_74775_l("oilTank"));
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
        if (this.oilTank.getFluid() != null) {
            nbt.func_74782_a("oilTank", (NBTBase)this.oilTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return StatCollector.func_74838_a((String)"container.refinery.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public boolean func_94042_c() {
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ((IItemElectric)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
                }
                case 1: {
                    FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                    return stack != null && stack.getFluid() != null && stack.getFluid().getName().equalsIgnoreCase("oil");
                }
                case 2: {
                    return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ((IItemElectric)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f || !this.shouldPullEnergy();
                }
                case 1: {
                    return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
                }
                case 2: {
                    FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                    return stack != null && stack.getFluid() != null && stack.getFluid().getName().equalsIgnoreCase("fuel");
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() instanceof IItemElectric;
            }
            case 1: {
                FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                return stack != null && stack.getFluid() != null && stack.getFluid().getName().equalsIgnoreCase("oil") || FluidContainerRegistry.isContainer((ItemStack)itemstack);
            }
            case 2: {
                FluidStack stack2 = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                return stack2 != null && stack2.getFluid() != null && stack2.getFluid().getName().equalsIgnoreCase("fuel") || FluidContainerRegistry.isContainer((ItemStack)itemstack);
            }
        }
        return false;
    }

    @Override
    public boolean shouldPullEnergy() {
        return this.getEnergyStored() <= this.getMaxEnergyStored() - this.ueWattsPerTick;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_70322_n() + 2)))) {
            return this.fuelTank.getFluid() != null && this.fuelTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_70322_n() + 2)))) {
            return this.fuelTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_70322_n() + 2)))) {
            return this.drain(from, new FluidStack(GalacticraftCore.fluidFuel, maxDrain), doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_70322_n() + 2)).getOpposite())) {
            return this.oilTank.getFluid() == null || this.oilTank.getFluidAmount() < this.oilTank.getCapacity();
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_70322_n() + 2)).getOpposite()) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.equalsIgnoreCase("Oil")) {
            used = this.oilTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == ForgeDirection.getOrientation((int)(this.func_70322_n() + 2)).getOpposite()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.oilTank)};
        } else if (from == ForgeDirection.getOrientation((int)(this.func_70322_n() + 2))) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
        }
        return tankInfo;
    }
}

