/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import java.lang.reflect.Constructor;
import micdoodle8.mods.galacticraft.api.transmission.ElectricityPack;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityConductor;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class GCCoreTileEntityUniversalConductor
extends GCCoreTileEntityConductor {
    protected boolean isAddedToEnergyNet;
    public Object powerHandler;
    public float buildcraftBuffer = NetworkConfigHandler.BC3_RATIO * 50.0f;

    public GCCoreTileEntityUniversalConductor() {
        this.initBC();
    }

    @Override
    public void onNetworkChanged() {
        if (NetworkConfigHandler.isBuildcraftLoaded() && this instanceof IPowerReceptor) {
            this.reconfigureBC();
        }
    }

    private void initBC() {
        if (NetworkConfigHandler.isBuildcraftLoaded() && this instanceof IPowerReceptor) {
            this.powerHandler = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.PIPE);
            this.reconfigureBC();
            ((PowerHandler)this.powerHandler).configurePowerPerdition(0, 0);
        }
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = WorldUtil.getAdjacentPowerConnections(this);
        }
        return this.adjacentConnections;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        if (!this.isAddedToEnergyNet) {
            if (!this.field_70331_k.field_72995_K && NetworkConfigHandler.isIndustrialCraft2Loaded()) {
                this.initIC();
            }
            this.isAddedToEnergyNet = true;
        }
    }

    @Override
    public void func_70313_j() {
        this.unloadTileIC2();
        super.func_70313_j();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        if (NetworkConfigHandler.isIndustrialCraft2Loaded() && !this.field_70331_k.field_72995_K) {
            try {
                Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent");
                Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                Object o = constr.newInstance(this);
                if (o != null && o instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_70331_k != null) {
            if (!this.field_70331_k.field_72995_K && NetworkConfigHandler.isIndustrialCraft2Loaded()) {
                try {
                    Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent");
                    Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                    Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                    Object o = constr.newInstance(this);
                    if (o != null && o instanceof Event) {
                        MinecraftForge.EVENT_BUS.post((Event)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double demandedEnergyUnits() {
        if (this.getNetwork() == null) {
            return 0.0;
        }
        return ((IElectricityNetwork)this.getNetwork()).getRequest(this).getWatts() * NetworkConfigHandler.TO_IC2_RATIO;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        TileEntity tile = new Vector3(this).modifyPositionFromSide(directionFrom).getTileEntity((IBlockAccess)this.field_70331_k);
        ElectricityPack pack = ElectricityPack.getFromWatts((float)(amount * (double)NetworkConfigHandler.IC2_RATIO), 120.0f);
        return ((IElectricityNetwork)this.getNetwork()).produce(pack, true, this, tile) * NetworkConfigHandler.TO_IC2_RATIO;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        block3: {
            block2: {
                if (this.getNetwork() == null) break block2;
                TileEntity[] tileEntityArray = new TileEntity[]{this};
                if (!(((IElectricityNetwork)this.getNetwork()).getRequest(tileEntityArray).getWatts() <= 0.0f)) break block3;
            }
            return null;
        }
        return ((PowerHandler)this.powerHandler).getPowerReceiver();
    }

    private void reconfigureBC() {
        float requiredEnergy = ((IElectricityNetwork)this.getNetwork()).getRequest(this).getWatts() * NetworkConfigHandler.TO_BC_RATIO;
        ((PowerHandler)this.powerHandler).configure(1.0f, requiredEnergy, 0.0f, requiredEnergy);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public void doWork(PowerHandler workProvider) {
        if (((PowerHandler)this.powerHandler).getEnergyStored() > 0.0f && this.getNetwork() != null) {
            ElectricityPack pack = ElectricityPack.getFromWatts(((PowerHandler)this.powerHandler).getEnergyStored() * NetworkConfigHandler.BC3_RATIO, 120.0f);
            ((IElectricityNetwork)this.getNetwork()).produce(pack, true, this);
        }
        ((PowerHandler)this.powerHandler).setEnergy(0.0f);
        this.reconfigureBC();
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public World getWorld() {
        return this.func_70314_l();
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return maxReceive - (int)Math.floor(((IElectricityNetwork)this.getNetwork()).produce(ElectricityPack.getFromWatts((float)maxReceive * NetworkConfigHandler.TE_RATIO, 120.0f), !simulate, this) * NetworkConfigHandler.TO_TE_RATIO);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public boolean canInterface(ForgeDirection from) {
        return this.canConnect(from, NetworkType.POWER);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="ThermalExpansion")
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.getNetwork() == null) {
            return 0;
        }
        return (int)Math.floor(((IElectricityNetwork)this.getNetwork()).getRequest(this).getWatts() * NetworkConfigHandler.TO_TE_RATIO);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        if (!this.canReceiveEnergy(side)) {
            return 0.0;
        }
        return amount - (double)(((IElectricityNetwork)this.getNetwork()).produce(ElectricityPack.getFromWatts((float)(amount * (double)NetworkConfigHandler.MEKANISM_RATIO), 120.0f), true, this) * NetworkConfigHandler.TO_MEKANISM_RATIO);
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public boolean canReceiveEnergy(ForgeDirection side) {
        if (this.getNetwork() == null) {
            return false;
        }
        return ((IElectricityNetwork)this.getNetwork()).getRequest(this).getWatts() > 0.0f;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public double getEnergy() {
        return 0.0;
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public void setEnergy(double energy) {
    }

    @GCCoreAnnotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public double getMaxEnergy() {
        return 1.0;
    }
}

