/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen.dungeon;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreDungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreDungeonRoom;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreMapGenDungeon {
    public ArrayList<GCCoreDungeonRoom> bossRooms = new ArrayList();
    public ArrayList<GCCoreDungeonRoom> treasureRooms = new ArrayList();
    public ArrayList<GCCoreDungeonRoom> otherRooms = new ArrayList();
    public final int DUNGEON_WALL_ID;
    public final int DUNGEON_WALL_META;
    public final int RANGE;
    public final int HALLWAY_LENGTH;
    public final int HALLWAY_HEIGHT;
    public static boolean useArrays = false;
    public World worldObj;
    private final ArrayList<GCCoreDungeonRoom> rooms = new ArrayList();

    public GCCoreMapGenDungeon(int wallID, int wallMeta, int range, int hallwayLength, int hallwayHeight) {
        this.DUNGEON_WALL_ID = wallID;
        this.DUNGEON_WALL_META = wallMeta;
        this.RANGE = range;
        this.HALLWAY_LENGTH = hallwayLength;
        this.HALLWAY_HEIGHT = hallwayHeight;
    }

    public void generateUsingArrays(World world, long seed, int x, int y, int z, int chunkX, int chunkZ, short[] blocks, byte[] metas) {
        ChunkCoordinates dungeonCoords = this.getDungeonNear(seed, chunkX, chunkZ);
        if (dungeonCoords != null) {
            this.generate(world, new Random(seed * (long)dungeonCoords.field_71574_a * (long)dungeonCoords.field_71573_c * 24789L), dungeonCoords.field_71574_a, y, dungeonCoords.field_71573_c, chunkX, chunkZ, blocks, metas, true);
        }
    }

    public void generateUsingSetBlock(World world, int x, int y, int z) {
        this.generate(world, new Random(new Random().nextLong() * (long)x * (long)z * 24789L), x, y, z, x, z, null, null, false);
    }

    public void generate(World world, Random rand, int x, int y, int z, int chunkX, int chunkZ, short[] blocks, byte[] metas, boolean useArrays) {
        GCCoreMapGenDungeon.useArrays = useArrays;
        this.worldObj = world;
        ArrayList<GCCoreDungeonBoundingBox> boundingBoxes = new ArrayList<GCCoreDungeonBoundingBox>();
        int length = rand.nextInt(4) + 5;
        GCCoreDungeonRoom currentRoom = GCCoreDungeonRoom.makeRoom(this, rand, x, y, z, ForgeDirection.DOWN);
        currentRoom.generate(blocks, metas, chunkX, chunkZ);
        this.rooms.add(currentRoom);
        GCCoreDungeonBoundingBox cbb = currentRoom.getBoundingBox();
        boundingBoxes.add(cbb);
        this.generateEntranceCrater(blocks, metas, x + (cbb.maxX - cbb.minX) / 2, y, z + (cbb.maxZ - cbb.minZ) / 2, chunkX, chunkZ);
        block18: for (int i = 0; i <= length; ++i) {
            for (int j = 0; j < 8; ++j) {
                GCCoreDungeonBoundingBox corridor1;
                ForgeDirection dir;
                int offsetX = 0;
                int offsetZ = 0;
                ForgeDirection entranceDir = dir = this.randDir(rand);
                switch (dir) {
                    case EAST: {
                        offsetZ = this.HALLWAY_LENGTH + rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = ForgeDirection.NORTH;
                            offsetX = this.HALLWAY_LENGTH + rand.nextInt(15);
                            break;
                        }
                        entranceDir = ForgeDirection.SOUTH;
                        offsetX = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        break;
                    }
                    case NORTH: {
                        offsetX = this.HALLWAY_LENGTH + rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = ForgeDirection.EAST;
                            offsetZ = this.HALLWAY_LENGTH + rand.nextInt(15);
                            break;
                        }
                        entranceDir = ForgeDirection.WEST;
                        offsetZ = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        break;
                    }
                    case SOUTH: {
                        offsetX = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = ForgeDirection.EAST;
                            offsetZ = this.HALLWAY_LENGTH + rand.nextInt(15);
                            break;
                        }
                        entranceDir = ForgeDirection.WEST;
                        offsetZ = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        break;
                    }
                    case WEST: {
                        offsetZ = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        if (!rand.nextBoolean()) break;
                        if (rand.nextBoolean()) {
                            entranceDir = ForgeDirection.NORTH;
                            offsetX = this.HALLWAY_LENGTH + rand.nextInt(15);
                            break;
                        }
                        entranceDir = ForgeDirection.SOUTH;
                        offsetX = -this.HALLWAY_LENGTH - rand.nextInt(15);
                        break;
                    }
                }
                GCCoreDungeonRoom possibleRoom = GCCoreDungeonRoom.makeRoom(this, rand, currentRoom.posX + offsetX, y, currentRoom.posZ + offsetZ, entranceDir.getOpposite());
                if (i == length - 1) {
                    possibleRoom = GCCoreDungeonRoom.makeBossRoom(this, rand, currentRoom.posX + offsetX, y, currentRoom.posZ + offsetZ, entranceDir.getOpposite());
                }
                if (i == length) {
                    possibleRoom = GCCoreDungeonRoom.makeTreasureRoom(this, rand, currentRoom.posX + offsetX, y, currentRoom.posZ + offsetZ, entranceDir.getOpposite());
                }
                GCCoreDungeonBoundingBox possibleRoomBb = possibleRoom.getBoundingBox();
                GCCoreDungeonBoundingBox currentRoomBb = currentRoom.getBoundingBox();
                if (this.isIntersecting(possibleRoomBb, boundingBoxes)) continue;
                int curCenterX = (currentRoomBb.minX + currentRoomBb.maxX) / 2;
                int curCenterZ = (currentRoomBb.minZ + currentRoomBb.maxZ) / 2;
                int possibleCenterX = (possibleRoomBb.minX + possibleRoomBb.maxX) / 2;
                int possibleCenterZ = (possibleRoomBb.minZ + possibleRoomBb.maxZ) / 2;
                int corridorX = this.clamp((curCenterX + possibleCenterX) / 2, Math.max(currentRoomBb.minX + 1, possibleRoomBb.minX + 1), Math.min(currentRoomBb.maxX - 1, possibleRoomBb.maxX - 1));
                int corridorZ = this.clamp((curCenterZ + possibleCenterZ) / 2, Math.max(currentRoomBb.minZ + 1, possibleRoomBb.minZ + 1), Math.min(currentRoomBb.maxZ - 1, possibleRoomBb.maxZ - 1));
                if (offsetX == 0 || offsetZ == 0) {
                    corridor1 = null;
                    switch (dir) {
                        case EAST: {
                            corridor1 = new GCCoreDungeonBoundingBox(corridorX - 1, currentRoomBb.maxZ, corridorX, possibleRoomBb.minZ - 1);
                            break;
                        }
                        case NORTH: {
                            corridor1 = new GCCoreDungeonBoundingBox(currentRoomBb.maxX, corridorZ - 1, possibleRoomBb.minX - 1, corridorZ);
                            break;
                        }
                        case SOUTH: {
                            corridor1 = new GCCoreDungeonBoundingBox(possibleRoomBb.maxX, corridorZ - 1, currentRoomBb.minX - 1, corridorZ);
                            break;
                        }
                        case WEST: {
                            corridor1 = new GCCoreDungeonBoundingBox(corridorX - 1, possibleRoomBb.maxZ, corridorX, currentRoomBb.minZ - 1);
                            break;
                        }
                    }
                    if (this.isIntersecting(corridor1, boundingBoxes) || corridor1.isOverlapping(possibleRoomBb)) continue;
                    boundingBoxes.add(possibleRoomBb);
                    boundingBoxes.add(corridor1);
                    currentRoom = possibleRoom;
                    currentRoom.generate(blocks, metas, chunkX, chunkZ);
                    this.rooms.add(currentRoom);
                    if (corridor1 == null) continue block18;
                    this.genCorridor(corridor1, rand, possibleRoom.posY, chunkX, chunkZ, dir, blocks, metas, false);
                    continue block18;
                }
                corridor1 = null;
                GCCoreDungeonBoundingBox corridor2 = null;
                ForgeDirection dir2 = ForgeDirection.EAST;
                int extraLength = 0;
                if (rand.nextInt(6) == 0) {
                    extraLength = rand.nextInt(7);
                }
                switch (dir) {
                    case EAST: {
                        corridor1 = new GCCoreDungeonBoundingBox(curCenterX - 1, currentRoomBb.maxZ, curCenterX + 1, possibleCenterZ - 1);
                        if (offsetX > 0) {
                            corridor2 = new GCCoreDungeonBoundingBox(corridor1.minX - extraLength, corridor1.maxZ + 1, possibleRoomBb.minX, corridor1.maxZ + 3);
                            dir2 = ForgeDirection.NORTH;
                            break;
                        }
                        corridor2 = new GCCoreDungeonBoundingBox(possibleRoomBb.maxX, corridor1.maxZ + 1, corridor1.maxX + extraLength, corridor1.maxZ + 3);
                        dir2 = ForgeDirection.SOUTH;
                        break;
                    }
                    case NORTH: {
                        corridor1 = new GCCoreDungeonBoundingBox(currentRoomBb.maxX, curCenterZ - 1, possibleCenterX - 1, curCenterZ + 1);
                        if (offsetZ > 0) {
                            corridor2 = new GCCoreDungeonBoundingBox(corridor1.maxX + 1, corridor1.minZ - extraLength, corridor1.maxX + 4, possibleRoomBb.minZ);
                            dir2 = ForgeDirection.EAST;
                            break;
                        }
                        corridor2 = new GCCoreDungeonBoundingBox(corridor1.maxX + 1, possibleRoomBb.maxZ, corridor1.maxX + 4, corridor1.maxZ + extraLength);
                        dir2 = ForgeDirection.WEST;
                        break;
                    }
                    case SOUTH: {
                        corridor1 = new GCCoreDungeonBoundingBox(possibleCenterX + 1, curCenterZ - 1, currentRoomBb.minX - 1, curCenterZ + 1);
                        if (offsetZ > 0) {
                            corridor2 = new GCCoreDungeonBoundingBox(corridor1.minX - 3, corridor1.minZ - extraLength, corridor1.minX - 1, possibleRoomBb.minZ);
                            dir2 = ForgeDirection.EAST;
                            break;
                        }
                        corridor2 = new GCCoreDungeonBoundingBox(corridor1.minX - 3, possibleRoomBb.maxZ, corridor1.minX - 1, corridor1.maxZ + extraLength);
                        dir2 = ForgeDirection.WEST;
                        break;
                    }
                    case WEST: {
                        corridor1 = new GCCoreDungeonBoundingBox(curCenterX - 1, possibleCenterZ + 1, curCenterX + 1, currentRoomBb.minZ - 1);
                        if (offsetX > 0) {
                            corridor2 = new GCCoreDungeonBoundingBox(corridor1.minX - extraLength, corridor1.minZ - 3, possibleRoomBb.minX, corridor1.minZ - 1);
                            dir2 = ForgeDirection.NORTH;
                            break;
                        }
                        corridor2 = new GCCoreDungeonBoundingBox(possibleRoomBb.maxX, corridor1.minZ - 3, corridor1.maxX + extraLength, corridor1.minZ - 1);
                        dir2 = ForgeDirection.SOUTH;
                        break;
                    }
                }
                if (this.isIntersecting(corridor1, boundingBoxes) || this.isIntersecting(corridor2, boundingBoxes) || corridor1.isOverlapping(possibleRoomBb) || corridor2.isOverlapping(possibleRoomBb)) continue;
                boundingBoxes.add(possibleRoomBb);
                boundingBoxes.add(corridor1);
                boundingBoxes.add(corridor2);
                currentRoom = possibleRoom;
                currentRoom.generate(blocks, metas, chunkX, chunkZ);
                this.rooms.add(currentRoom);
                if (corridor1 == null || corridor2 == null) continue block18;
                this.genCorridor(corridor2, rand, possibleRoom.posY, chunkX, chunkZ, dir2, blocks, metas, true);
                this.genCorridor(corridor1, rand, possibleRoom.posY, chunkX, chunkZ, dir, blocks, metas, false);
                continue block18;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void genCorridor(GCCoreDungeonBoundingBox corridor, Random rand, int y, int cx, int cz, ForgeDirection dir, short[] blocks, byte[] metas, boolean doubleCorridor) {
        int i = corridor.minX - 1;
        block6: while (i <= corridor.maxX + 1) {
            int k = corridor.minZ - 1;
            while (true) {
                if (k <= corridor.maxZ + 1) {
                } else {
                    ++i;
                    continue block6;
                }
                block8: for (int j = y - 1; j <= y + this.HALLWAY_HEIGHT; ++j) {
                    boolean flag = false;
                    int flag2 = -1;
                    switch (dir) {
                        case EAST: {
                            if (k == corridor.minZ - 1 && !doubleCorridor || k == corridor.maxZ + 1) break block8;
                            if (doubleCorridor && k == corridor.minZ - 1) {
                                flag = true;
                            }
                            if (i == corridor.minX - 1 || i == corridor.maxX + 1 || j == y - 1 || j == y + this.HALLWAY_HEIGHT) {
                                flag = true;
                            }
                            if (i != corridor.minX && i != corridor.maxX || k % 4 != 0 || j != y + 2) break;
                            flag2 = i == corridor.minX ? 2 : 1;
                            break;
                        }
                        case WEST: {
                            if (k == corridor.minZ - 1 || k == corridor.maxZ + 1 && !doubleCorridor) break block8;
                            if (doubleCorridor && k == corridor.maxX + 1) {
                                flag = true;
                            }
                            if (i == corridor.minX - 1 || i == corridor.maxX + 1 || j == y - 1 || j == y + this.HALLWAY_HEIGHT) {
                                flag = true;
                            }
                            if (i != corridor.minX && i != corridor.maxX || k % 4 != 0 || j != y + 2) break;
                            flag2 = i == corridor.minX ? 2 : 1;
                            break;
                        }
                        case NORTH: {
                            if (i == corridor.minX - 1 && !doubleCorridor || i == corridor.maxX + 1) break block8;
                            if (i == corridor.minX - 1) {
                                flag = true;
                            }
                            if (k == corridor.minZ - 1 || k == corridor.maxZ + 1 || j == y - 1 || j == y + this.HALLWAY_HEIGHT) {
                                flag = true;
                            }
                            if (k != corridor.minZ && k != corridor.maxZ || i % 4 != 0 || j != y + 2) break;
                            flag2 = k == corridor.minZ ? 4 : 3;
                            break;
                        }
                        case SOUTH: {
                            if (i == corridor.minX - 1 || i == corridor.maxX + 1 && !doubleCorridor) break block8;
                            if (i == corridor.maxX + 1) {
                                flag = true;
                            }
                            if (k == corridor.minZ - 1 || k == corridor.maxZ + 1 || j == y - 1 || j == y + this.HALLWAY_HEIGHT) {
                                flag = true;
                            }
                            if (k != corridor.minZ && k != corridor.maxZ || i % 4 != 0 || j != y + 2) break;
                            flag2 = k == corridor.minZ ? 4 : 3;
                        }
                    }
                    if (!flag) {
                        if (flag2 != -1) {
                            this.placeBlock(blocks, metas, i, j, k, cx, cz, GCCoreBlocks.unlitTorch.field_71990_ca, 0);
                            this.worldObj.func_72892_b(i, j, k, GCCoreBlocks.unlitTorch.field_71990_ca, 40, 0);
                            continue;
                        }
                        this.placeBlock(blocks, metas, i, j, k, cx, cz, 0, 0);
                        continue;
                    }
                    this.placeBlock(blocks, metas, i, j, k, cx, cz, this.DUNGEON_WALL_ID, this.DUNGEON_WALL_META);
                }
                ++k;
            }
            break;
        }
        return;
    }

    public void handleTileEntities(Random rand) {
        ArrayList<GCCoreDungeonRoom> rooms = new ArrayList<GCCoreDungeonRoom>();
        rooms.addAll(this.rooms);
        for (GCCoreDungeonRoom room : rooms) {
            room.handleTileEntities(rand);
        }
    }

    protected boolean canGenDungeonAtCoords(long worldSeed, int i, int j) {
        int numChunks = 44;
        boolean offsetChunks = false;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= 43;
        }
        if (j < 0) {
            j -= 43;
        }
        int randX = i / 44;
        int randZ = j / 44;
        long dungeonSeed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldSeed + 4291726L;
        Random rand = new Random(dungeonSeed);
        randX *= 44;
        randZ *= 44;
        return oldi == (randX += rand.nextInt(44)) && oldj == (randZ += rand.nextInt(44));
    }

    public void generateEntranceCrater(short[] blocks, byte[] meta, int x, int y, int z, int cx, int cz) {
        int range = 18;
        for (int i = x - 18; i < x + 18; ++i) {
            block1: for (int k = z - 18; k < z + 18; ++k) {
                double xDev = (double)(i - x) / 10.0;
                double zDev = (double)(k - z) / 10.0;
                double distance = xDev * xDev + zDev * zDev;
                int depth = (int)Math.abs(2.0 / (distance + 1.0E-5));
                int helper = 0;
                for (int j = 127; j > 0; --j) {
                    if ((this.getBlockID(blocks, i, j - 1, k, cx, cz) != 0 || this.getBlockID(blocks, i, j, k, cx, cz) == this.DUNGEON_WALL_ID) && helper <= depth) {
                        this.placeBlock(blocks, meta, i, j, k, cx, cz, 0, 0);
                        ++helper;
                    }
                    if (helper > depth || j <= y + 1) continue block1;
                }
            }
        }
    }

    public ChunkCoordinates getDungeonNear(long worldSeed, int i, int j) {
        int range = 16;
        for (int x = i - 16; x <= i + 16; ++x) {
            for (int z = j - 16; z <= j + 16; ++z) {
                if (!this.canGenDungeonAtCoords(worldSeed, x, z)) continue;
                return new ChunkCoordinates(x * 16 + 8, 0, z * 16 + 8);
            }
        }
        return null;
    }

    private void placeBlock(short[] blocks, byte[] metas, int x, int y, int z, int cx, int cz, int id, int meta) {
        if (useArrays) {
            if ((x -= (cx *= 16)) < 0 || x >= 16 || (z -= (cz *= 16)) < 0 || z >= 16) {
                return;
            }
            int index = this.getIndex(x, y, z);
            blocks[index] = (short)id;
            metas[index] = (byte)meta;
        } else {
            this.worldObj.func_72832_d(x, y, z, id, meta, 3);
        }
    }

    private int getBlockID(short[] blocks, int x, int y, int z, int cx, int cz) {
        if (useArrays) {
            if ((x -= (cx *= 16)) < 0 || x >= 16 || (z -= (cz *= 16)) < 0 || z >= 16) {
                return 1;
            }
            return blocks[this.getIndex(x, y, z)];
        }
        return this.worldObj.func_72798_a(x, y, z);
    }

    private int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    private ForgeDirection randDir(Random rand) {
        return ForgeDirection.values()[rand.nextInt(ForgeDirection.VALID_DIRECTIONS.length)];
    }

    private boolean isIntersecting(GCCoreDungeonBoundingBox bb, List<GCCoreDungeonBoundingBox> dungeonBbs) {
        for (GCCoreDungeonBoundingBox bb2 : dungeonBbs) {
            if (!bb.isOverlapping(bb2)) continue;
            return true;
        }
        return false;
    }

    private int clamp(int x, int min, int max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }
}

