/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.moon.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityCreeper;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySkeleton;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntitySpider;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityZombie;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.GCCoreCraterSize;
import micdoodle8.mods.galacticraft.core.world.gen.GCCoreMapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreMapGenDungeon;
import micdoodle8.mods.galacticraft.moon.GCMoonConfigManager;
import micdoodle8.mods.galacticraft.moon.world.gen.GCMoonBiomeDecorator;
import micdoodle8.mods.galacticraft.moon.world.gen.GCMoonBiomeGenBase;
import micdoodle8.mods.galacticraft.moon.world.gen.GCMoonGenCaves;
import micdoodle8.mods.galacticraft.moon.world.gen.GCMoonMapGenVillage;
import micdoodle8.mods.galacticraft.moon.world.gen.dungeon.GCMoonRoomBoss;
import micdoodle8.mods.galacticraft.moon.world.gen.dungeon.GCMoonRoomChests;
import micdoodle8.mods.galacticraft.moon.world.gen.dungeon.GCMoonRoomEmpty;
import micdoodle8.mods.galacticraft.moon.world.gen.dungeon.GCMoonRoomSpawner;
import micdoodle8.mods.galacticraft.moon.world.gen.dungeon.GCMoonRoomTreasure;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.SpawnListEntry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraftforge.common.ForgeDirection;

public class GCMoonChunkProvider
extends ChunkProviderGenerate {
    final short topBlockID;
    final byte topBlockMeta = 5;
    final short fillBlockID;
    final byte fillBlockMeta = 3;
    final short lowerBlockID;
    final byte lowerBlockMeta = 4;
    private final Random field_73220_k;
    private final NoiseModule field_73217_l;
    private final NoiseModule field_73218_m;
    private final NoiseModule field_73215_n;
    private final NoiseModule field_73216_o;
    public GCMoonBiomeDecorator biomedecoratorplanet;
    private final World field_73230_p;
    private final GCMoonMapGenVillage field_73224_v;
    private final GCCoreMapGenDungeon dungeonGenerator;
    private BiomeGenBase[] field_73231_z;
    private final GCCoreMapGenBaseMeta field_73226_t;
    private static final int CRATER_PROB = 300;
    private static final int MID_HEIGHT = 63;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 128;
    private static final int CHUNK_SIZE_Z = 16;

    public GCMoonChunkProvider(World par1World, long par2, boolean par4) {
        super(par1World, par2, par4);
        this.topBlockID = (short)GCCoreBlocks.blockMoon.field_71990_ca;
        this.topBlockMeta = (byte)5;
        this.fillBlockID = (short)GCCoreBlocks.blockMoon.field_71990_ca;
        this.fillBlockMeta = (byte)3;
        this.lowerBlockID = (short)GCCoreBlocks.blockMoon.field_71990_ca;
        this.lowerBlockMeta = (byte)4;
        this.biomedecoratorplanet = new GCMoonBiomeDecorator(GCMoonBiomeGenBase.moonFlat);
        this.field_73224_v = new GCMoonMapGenVillage();
        this.dungeonGenerator = new GCCoreMapGenDungeon(GCCoreBlocks.blockMoon.field_71990_ca, 14, 8, 16, 3);
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomEmpty(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomSpawner(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomSpawner(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomSpawner(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomSpawner(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomSpawner(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomSpawner(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomSpawner(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomSpawner(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomChests(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new GCMoonRoomChests(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.bossRooms.add(new GCMoonRoomBoss(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.treasureRooms.add(new GCMoonRoomTreasure(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.field_73231_z = new BiomeGenBase[]{GCMoonBiomeGenBase.moonFlat};
        this.field_73226_t = new GCMoonGenCaves();
        this.field_73230_p = par1World;
        this.field_73220_k = new Random(par2);
        this.field_73217_l = new Gradient(this.field_73220_k.nextLong(), 4, 0.25);
        this.field_73218_m = new Gradient(this.field_73220_k.nextLong(), 4, 0.25);
        this.field_73215_n = new Gradient(this.field_73220_k.nextLong(), 1, 0.25);
        this.field_73216_o = new Gradient(this.field_73220_k.nextLong(), 1, 0.25);
    }

    public void generateTerrain(int chunkX, int chunkZ, short[] idArray, byte[] metaArray) {
        this.field_73217_l.frequency = 0.0125;
        this.field_73218_m.frequency = 0.015;
        this.field_73215_n.frequency = 0.01;
        this.field_73216_o.frequency = 0.02;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double d = this.field_73217_l.getNoise(x + chunkX * 16, z + chunkZ * 16) * 8.0;
                double d2 = this.field_73218_m.getNoise(x + chunkX * 16, z + chunkZ * 16) * 24.0;
                double d3 = this.field_73215_n.getNoise(x + chunkX * 16, z + chunkZ * 16) - 0.1;
                double yDev = 0.0;
                yDev = d3 < 0.0 ? d : (d3 > 1.0 ? d2 : d + (d2 - d) * (d3 *= 4.0));
                for (int y = 0; y < 128; ++y) {
                    if (!((double)y < 63.0 + yDev)) continue;
                    idArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockID;
                    metaArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockMeta;
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, short[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int var5 = 20;
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)(this.field_73216_o.getNoise(var8 + par1 * 16, var9 * par2 * 16) / 3.0 + 3.0 + this.field_73220_k.nextDouble() * 0.25);
                int var13 = -1;
                short var14 = this.topBlockID;
                int var14m = this.topBlockMeta;
                short var15 = this.fillBlockID;
                int var15m = this.fillBlockMeta;
                for (int var16 = 127; var16 >= 0; --var16) {
                    int index = this.getIndex(var8, var16, var9);
                    arrayOfMeta[index] = 0;
                    if (var16 <= 0 + this.field_73220_k.nextInt(5)) {
                        arrayOfIDs[index] = (short)Block.field_71986_z.field_71990_ca;
                        continue;
                    }
                    short var18 = arrayOfIDs[index];
                    if (var18 == 0) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != this.lowerBlockID) continue;
                    arrayOfMeta[index] = this.lowerBlockMeta;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = 0;
                            var14m = 0;
                            var15 = this.lowerBlockID;
                            var15m = this.lowerBlockMeta;
                        } else if (var16 >= 36 && var16 <= 21) {
                            var14 = this.topBlockID;
                            var14m = this.topBlockMeta;
                            var14 = this.fillBlockID;
                            var14m = this.fillBlockMeta;
                        }
                        var13 = var12;
                        if (var16 >= 19) {
                            arrayOfIDs[index] = var14;
                            arrayOfMeta[index] = var14m;
                            continue;
                        }
                        if (var16 >= 19 || var16 < 18) continue;
                        arrayOfIDs[index] = var15;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    arrayOfIDs[index] = var15;
                    arrayOfMeta[index] = var15m;
                }
            }
        }
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.field_73220_k.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        short[] ids = new short[65536];
        byte[] meta = new byte[65536];
        this.generateTerrain(par1, par2, ids, meta);
        this.field_73231_z = this.field_73230_p.func_72959_q().func_76933_b(this.field_73231_z, par1 * 16, par2 * 16, 16, 16);
        this.createCraters(par1, par2, ids, meta);
        this.replaceBlocksForBiome(par1, par2, ids, meta, this.field_73231_z);
        this.field_73226_t.generate((IChunkProvider)this, this.field_73230_p, par1, par2, ids, meta);
        this.dungeonGenerator.generateUsingArrays(this.field_73230_p, this.field_73230_p.func_72905_C(), par1 * 16, 25, par2 * 16, par1, par2, ids, meta);
        Chunk var4 = new Chunk(this.field_73230_p, ids, meta, par1, par2);
        var4.func_76603_b();
        return var4;
    }

    public void createCraters(int chunkX, int chunkZ, short[] chunkArray, byte[] metaArray) {
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < this.field_73216_o.getNoise(x * 16 + x, cz * 16 + z) / 300.0)) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        GCCoreCraterSize cSize = GCCoreCraterSize.sizeArray[random.nextInt(GCCoreCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, chunkArray, metaArray);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, short[] chunkArray, byte[] metaArray) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (chunkArray[this.getIndex(x, y, z)] != 0 && (double)helper <= yDev) {
                        chunkArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                        metaArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public int func_73152_e() {
        return 0;
    }

    private int getIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public void decoratePlanet(World par1World, Random par2Random, int par3, int par4) {
        this.biomedecoratorplanet.decorate(par1World, par2Random, par3, par4);
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        BlockSand.field_72192_a = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        this.field_73230_p.func_72807_a(var4 + 16, var5 + 16);
        this.field_73220_k.setSeed(this.field_73230_p.func_72905_C());
        long var7 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        long var9 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        this.field_73220_k.setSeed((long)par2 * var7 + (long)par3 * var9 ^ this.field_73230_p.func_72905_C());
        this.dungeonGenerator.handleTileEntities(this.field_73220_k);
        if (!GCMoonConfigManager.disableMoonVillageGen) {
            this.field_73224_v.func_75051_a(this.field_73230_p, this.field_73220_k, par2, par3);
        }
        this.decoratePlanet(this.field_73230_p, this.field_73220_k, var4, var5);
        BlockSand.field_72192_a = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return GCMoonConfigManager.generateOtherMods ? "RandomLevelSource" : "MoonLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<SpawnListEntry> monsters = new ArrayList<SpawnListEntry>();
            monsters.add(new SpawnListEntry(GCCoreEntityZombie.class, 8, 2, 3));
            monsters.add(new SpawnListEntry(GCCoreEntitySpider.class, 8, 2, 3));
            monsters.add(new SpawnListEntry(GCCoreEntitySkeleton.class, 8, 2, 3));
            monsters.add(new SpawnListEntry(GCCoreEntityCreeper.class, 8, 2, 3));
            return monsters;
        }
        return null;
    }

    public void func_82695_e(int par1, int par2) {
        if (!GCMoonConfigManager.disableMoonVillageGen) {
            this.field_73224_v.func_75036_a((IChunkProvider)this, this.field_73230_p, par1, par2, null);
        }
    }
}

