/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.mod;

import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import powercrystals.core.updater.IUpdateableMod;

public abstract class BaseMod
implements IUpdateableMod {
    protected File _configFolder;

    protected void setConfigFolderBase(File file) {
        this._configFolder = new File(file.getAbsolutePath() + "/" + this.getConfigBaseFolder() + "/" + this.getModId().toLowerCase() + "/");
    }

    protected File getClientConfig() {
        return new File(this._configFolder.getAbsolutePath() + "/client.cfg");
    }

    protected File getCommonConfig() {
        return new File(this._configFolder.getAbsolutePath() + "/common.cfg");
    }

    protected String getConfigBaseFolder() {
        return "powercrystals";
    }

    protected void extractLang(String[] stringArray) {
        String string = "/" + this.getConfigBaseFolder() + "/" + this.getModId().toLowerCase() + "/lang/";
        for (String string2 : stringArray) {
            InputStream inputStream = this.getClass().getResourceAsStream(string + string2 + ".lang");
            if (inputStream == null) continue;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this._configFolder.getAbsolutePath() + "/" + string2 + ".lang");
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                inputStream.close();
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void loadLang() {
        for (File file : this._configFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".lang");
            }
        })) {
            try {
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String string = file.getName().replace(".lang", "");
                LanguageRegistry.instance().addStringLocalization(properties, string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

