/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.position;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.AxisAlignedBB;
import powercrystals.core.position.BlockPosition;

public class Area {
    public int xMin;
    public int xMax;
    public int yMin;
    public int yMax;
    public int zMin;
    public int zMax;
    private BlockPosition _origin;

    public Area(int n, int n2, int n3, int n4, int n5, int n6) {
        this.xMin = n;
        this.xMax = n2;
        this.yMin = n3;
        this.yMax = n4;
        this.zMin = n5;
        this.zMax = n6;
    }

    public Area(BlockPosition blockPosition, int n, int n2, int n3) {
        this.xMin = blockPosition.x - n;
        this.xMax = blockPosition.x + n;
        this.yMin = blockPosition.y - n2;
        this.yMax = blockPosition.y + n3;
        this.zMin = blockPosition.z - n;
        this.zMax = blockPosition.z + n;
        this._origin = blockPosition;
    }

    public BlockPosition getMin() {
        return new BlockPosition(this.xMin, this.yMin, this.zMin);
    }

    public BlockPosition getMax() {
        return new BlockPosition(this.xMax, this.yMax, this.zMax);
    }

    public List<BlockPosition> getPositionsTopFirst() {
        ArrayList<BlockPosition> arrayList = new ArrayList<BlockPosition>();
        for (int i = this.yMax; i >= this.yMin; --i) {
            for (int j = this.xMin; j <= this.xMax; ++j) {
                for (int k = this.zMin; k <= this.zMax; ++k) {
                    arrayList.add(new BlockPosition(j, i, k));
                }
            }
        }
        return arrayList;
    }

    public List<BlockPosition> getPositionsBottomFirst() {
        ArrayList<BlockPosition> arrayList = new ArrayList<BlockPosition>();
        for (int i = this.yMin; i <= this.yMax; ++i) {
            for (int j = this.xMin; j <= this.xMax; ++j) {
                for (int k = this.zMin; k <= this.zMax; ++k) {
                    arrayList.add(new BlockPosition(j, i, k));
                }
            }
        }
        return arrayList;
    }

    public BlockPosition getOrigin() {
        return this._origin.copy();
    }

    public AxisAlignedBB toAxisAlignedBB() {
        return AxisAlignedBB.func_72330_a((double)this.xMin, (double)this.yMin, (double)this.zMin, (double)(this.xMax + 1), (double)(this.yMax + 1), (double)(this.zMax + 1));
    }
}

