/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.position;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.IRotateableTile;

public class BlockPosition {
    public int x;
    public int y;
    public int z;
    public ForgeDirection orientation;

    public BlockPosition(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPosition(int n, int n2, int n3, ForgeDirection forgeDirection) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.orientation = forgeDirection;
    }

    public BlockPosition(BlockPosition blockPosition) {
        this.x = blockPosition.x;
        this.y = blockPosition.y;
        this.z = blockPosition.z;
        this.orientation = blockPosition.orientation;
    }

    public BlockPosition(NBTTagCompound nBTTagCompound) {
        this.x = nBTTagCompound.func_74762_e("i");
        this.y = nBTTagCompound.func_74762_e("j");
        this.z = nBTTagCompound.func_74762_e("k");
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPosition(TileEntity tileEntity) {
        this.x = tileEntity.field_70329_l;
        this.y = tileEntity.field_70330_m;
        this.z = tileEntity.field_70327_n;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public static BlockPosition fromFactoryTile(IRotateableTile iRotateableTile) {
        BlockPosition blockPosition = new BlockPosition((TileEntity)iRotateableTile);
        blockPosition.orientation = iRotateableTile.getDirectionFacing();
        return blockPosition;
    }

    public BlockPosition copy() {
        return new BlockPosition(this.x, this.y, this.z, this.orientation);
    }

    public void moveRight(int n) {
        switch (this.orientation) {
            case SOUTH: {
                this.x -= n;
                break;
            }
            case NORTH: {
                this.x += n;
                break;
            }
            case EAST: {
                this.z += n;
                break;
            }
            case WEST: {
                this.z -= n;
                break;
            }
        }
    }

    public void moveLeft(int n) {
        this.moveRight(-n);
    }

    public void moveForwards(int n) {
        switch (this.orientation) {
            case UP: {
                this.y += n;
                break;
            }
            case DOWN: {
                this.y -= n;
                break;
            }
            case SOUTH: {
                this.z += n;
                break;
            }
            case NORTH: {
                this.z -= n;
                break;
            }
            case EAST: {
                this.x += n;
                break;
            }
            case WEST: {
                this.x -= n;
                break;
            }
        }
    }

    public void moveBackwards(int n) {
        this.moveForwards(-n);
    }

    public void moveUp(int n) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += n;
                break;
            }
        }
    }

    public void moveDown(int n) {
        this.moveUp(-n);
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74780_a("i", (double)this.x);
        nBTTagCompound.func_74780_a("j", (double)this.y);
        nBTTagCompound.func_74780_a("k", (double)this.z);
    }

    public String toString() {
        if (this.orientation == null) {
            return "{" + this.x + ", " + this.y + ", " + this.z + "}";
        }
        return "{" + this.x + ", " + this.y + ", " + this.z + ";" + this.orientation.toString() + "}";
    }

    public boolean equals(Object object) {
        if (!(object instanceof BlockPosition)) {
            return false;
        }
        BlockPosition blockPosition = (BlockPosition)object;
        return blockPosition.x == this.x && blockPosition.y == this.y && blockPosition.z == this.z && blockPosition.orientation == this.orientation;
    }

    public int hashCode() {
        return this.x & 0xFFF | this.y & 0xFF00 | this.z & 0xFFF000;
    }

    public BlockPosition min(BlockPosition blockPosition) {
        return new BlockPosition(blockPosition.x > this.x ? this.x : blockPosition.x, blockPosition.y > this.y ? this.y : blockPosition.y, blockPosition.z > this.z ? this.z : blockPosition.z);
    }

    public BlockPosition max(BlockPosition blockPosition) {
        return new BlockPosition(blockPosition.x < this.x ? this.x : blockPosition.x, blockPosition.y < this.y ? this.y : blockPosition.y, blockPosition.z < this.z ? this.z : blockPosition.z);
    }

    public List<BlockPosition> getAdjacent(boolean bl) {
        ArrayList<BlockPosition> arrayList = new ArrayList<BlockPosition>();
        arrayList.add(new BlockPosition(this.x + 1, this.y, this.z, ForgeDirection.EAST));
        arrayList.add(new BlockPosition(this.x - 1, this.y, this.z, ForgeDirection.WEST));
        arrayList.add(new BlockPosition(this.x, this.y, this.z + 1, ForgeDirection.SOUTH));
        arrayList.add(new BlockPosition(this.x, this.y, this.z - 1, ForgeDirection.NORTH));
        if (bl) {
            arrayList.add(new BlockPosition(this.x, this.y + 1, this.z, ForgeDirection.UP));
            arrayList.add(new BlockPosition(this.x, this.y - 1, this.z, ForgeDirection.DOWN));
        }
        return arrayList;
    }

    public TileEntity getTileEntity(World world) {
        return world.func_72796_p(this.x, this.y, this.z);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tileEntity, ForgeDirection forgeDirection) {
        BlockPosition blockPosition = new BlockPosition(tileEntity);
        blockPosition.orientation = forgeDirection;
        blockPosition.moveForwards(1);
        return tileEntity.field_70331_k.func_72796_p(blockPosition.x, blockPosition.y, blockPosition.z);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity tileEntity, ForgeDirection forgeDirection, Class<? extends TileEntity> clazz) {
        TileEntity tileEntity2 = BlockPosition.getAdjacentTileEntity(tileEntity, forgeDirection);
        if (clazz.isAssignableFrom(tileEntity2.getClass())) {
            return tileEntity2;
        }
        return null;
    }
}

