/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.updater;

import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.ModVersion;

public class UpdateCheckThread
extends Thread {
    private String _releaseUrl;
    private IUpdateableMod _mod;
    private boolean _checkComplete;
    private boolean _newVerAvailable;
    private ModVersion _newVer;

    public UpdateCheckThread(IUpdateableMod iUpdateableMod) {
        this(iUpdateableMod, null);
    }

    public UpdateCheckThread(IUpdateableMod iUpdateableMod, String string) {
        this._mod = iUpdateableMod;
        if (string == null) {
            string = "https://raw.github.com/skyboy/" + iUpdateableMod.getModId() + "/master/VERSION";
        }
        this._releaseUrl = string;
    }

    @Override
    public void run() {
        try {
            URL uRL = new URL(this._releaseUrl);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            ModVersion modVersion = ModVersion.parse(bufferedReader.readLine());
            ModVersion modVersion2 = ModVersion.parse(this._mod.getModVersion());
            bufferedReader.close();
            if (modVersion2.compareTo(modVersion) < 0) {
                FMLLog.log((Level)Level.INFO, (String)("An updated version of " + this._mod.getModName() + " is available: " + modVersion.modVersion().toString() + "."), (Object[])new Object[0]);
                if (modVersion2.minecraftVersion().compareTo(modVersion.minecraftVersion()) < 0) {
                    FMLLog.log((Level)Level.INFO, (String)("This update is for Minecraft " + modVersion.minecraftVersion().toString() + "."), (Object[])new Object[0]);
                }
            }
            this._newVer = modVersion;
            this._newVerAvailable = modVersion2.compareTo(modVersion) < 0;
            this._checkComplete = true;
        }
        catch (Exception exception) {
            FMLLog.log((Level)Level.WARNING, (String)("Update check for " + this._mod.getModName() + " failed: " + exception.getMessage()), (Object[])new Object[0]);
            exception.printStackTrace();
        }
    }

    public boolean checkComplete() {
        return this._checkComplete;
    }

    public boolean newVersionAvailable() {
        return this._newVerAvailable;
    }

    public ModVersion newVersion() {
        return this._newVer;
    }
}

