/*
 * Decompiled with CFR 0.152.
 */
package com.advGenetics.GUI.Client;

import com.advGenetics.AdvGenetics;
import com.advGenetics.DNA.AbilityRegistry;
import com.advGenetics.DNA.DNA;
import com.advGenetics.GUI.Container.ContainerMicroscope;
import com.advGenetics.GUI.Container.Objects.BloodParticle;
import com.advGenetics.Lib.GeneHelper;
import com.advGenetics.TileEntity.TileEntityMicroscope;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiMicroscope
extends GuiContainer {
    private static final ResourceLocation normalBloodTexture = new ResourceLocation("advancedgenetics", "textures/gui/container/microscope.png");
    private static final ResourceLocation mobBloodTexture = new ResourceLocation("advancedgenetics", "textures/gui/container/microscope2.png");
    private static final ResourceLocation bloodParts = new ResourceLocation("advancedgenetics", "textures/gui/bloodParts.png");
    private TileEntityMicroscope tile;
    private boolean isMobDNA = false;
    private BloodParticle[] particles = new BloodParticle[AbilityRegistry.abilities.size() * 2];
    private float timeBuffer = 0.0f;
    private float maxTime = 0.0f;
    private BloodParticle currentParticle = null;
    private int currentPartID = 0;
    private BloodParticle selectedParticle = null;

    public GuiMicroscope(InventoryPlayer par1InventoryPlayer, World world, int x, int y, int z) {
        super((Container)new ContainerMicroscope(par1InventoryPlayer, world, x, y, z));
        this.tile = (TileEntityMicroscope)world.func_72796_p(x, y, z);
        this.isMobDNA = par1InventoryPlayer.func_70448_g().field_77993_c == AdvGenetics.syringeBloodyMob.field_77779_bT;
        DNA dna = new DNA(par1InventoryPlayer.func_70448_g().func_77978_p());
        String[] abilities = dna.getTransmutators().split(",");
        if (dna.getTransmutators().trim().length() > 2) {
            for (int i = 0; i < abilities.length; ++i) {
                if (abilities[i].trim().length() <= 2) continue;
                this.particles[i] = new BloodParticle(0, 0, this.field_74194_b - 6, this.field_74195_c - 4, GeneHelper.getAbility(abilities[i]));
                this.maxTime += 100.0f;
            }
        }
        if (this.particles.length > 0) {
            this.currentParticle = this.particles[0];
        }
    }

    protected void func_74189_g(int par1, int par2) {
        GL11.glPushMatrix();
        this.field_73882_e.func_110434_K().func_110577_a(bloodParts);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        for (BloodParticle p : this.particles) {
            if (p == null) continue;
            p.render();
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        if (this.currentParticle != null && this.timeBuffer <= this.maxTime + 1.0f && this.particles.length > 0) {
            int pro = (int)(this.timeBuffer / this.maxTime * 100.0f);
            String string = "Analysing... (" + pro + "%)";
            this.field_73886_k.func_78276_b(string, this.field_74194_b / 2 - this.field_73886_k.func_78256_a(string) / 2, 24, 0xFFFFFF);
            this.timeBuffer += 0.1f;
            this.currentParticle.analysingState = 1;
            if (this.currentParticle.progress >= 100.0f) {
                this.currentParticle.analysingState = 2;
                if (this.particles[this.currentPartID + 1] != null) {
                    ++this.currentPartID;
                    this.currentParticle = this.particles[this.currentPartID];
                }
            }
            if (this.currentParticle.progress <= 100.0f) {
                this.currentParticle.progress += 0.1f;
            }
        }
        if (this.selectedParticle != null) {
            ArrayList<String> list = new ArrayList<String>();
            switch (this.selectedParticle.analysingState) {
                case 0: {
                    list.add("Unknown");
                    break;
                }
                case 1: {
                    int pro = (int)this.selectedParticle.progress;
                    list.add("Analysing... (" + pro + "%)");
                    break;
                }
                case 2: {
                    list.add(this.selectedParticle.ability.getName());
                }
            }
            this.drawHoveringText(list, 0, 0, this.field_73886_k);
        }
    }

    protected void func_74185_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(this.isMobDNA ? mobBloodTexture : normalBloodTexture);
        int k = (this.field_73880_f - this.field_74194_b) / 2;
        int l = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_74194_b, this.field_74195_c);
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        int x = par1 - this.field_74198_m;
        int y = par2 - this.field_74197_n;
        for (BloodParticle particle : this.particles) {
            if (particle == null || !((double)x >= particle.x) || !((double)y >= particle.y) || !((double)x <= particle.x + (double)(particle.size * 50.0f)) || !((double)y <= particle.y + (double)(particle.size * 50.0f))) continue;
            if (this.selectedParticle != null) {
                this.selectedParticle.isSelected = false;
            }
            this.selectedParticle = particle;
            this.selectedParticle.isSelected = true;
        }
    }
}

