/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.inventory;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.blocks.logic.ToolStationLogic;
import tconstruct.inventory.ActiveContainer;
import tconstruct.inventory.SlotTool;
import tconstruct.library.tools.ToolCore;

public class ToolStationContainer
extends ActiveContainer {
    public InventoryPlayer invPlayer;
    public ToolStationLogic logic;
    public Slot[] slots;
    public SlotTool toolSlot;
    public Random random = new Random();

    public ToolStationContainer(InventoryPlayer inventoryplayer, ToolStationLogic builderlogic) {
        this.initializeContainer(inventoryplayer, builderlogic);
    }

    public void initializeContainer(InventoryPlayer inventoryplayer, ToolStationLogic builderlogic) {
        int column;
        this.invPlayer = inventoryplayer;
        this.logic = builderlogic;
        this.toolSlot = new SlotTool(inventoryplayer.field_70458_d, builderlogic, 0, 115, 38);
        this.func_75146_a(this.toolSlot);
        this.slots = new Slot[]{new Slot((IInventory)builderlogic, 1, 57, 29), new Slot((IInventory)builderlogic, 2, 39, 38), new Slot((IInventory)builderlogic, 3, 57, 47)};
        for (int iter = 0; iter < 3; ++iter) {
            this.func_75146_a(this.slots[iter]);
        }
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, row + column * 9 + 9, 8 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, column, 8 + column * 18, 142));
        }
    }

    public void resetSlots(int[] posX, int[] posY) {
        int column;
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.func_75146_a(this.toolSlot);
        for (int iter = 0; iter < 3; ++iter) {
            this.slots[iter].field_75223_e = posX[iter] + 1;
            this.slots[iter].field_75221_f = posY[iter] + 1;
            this.func_75146_a(this.slots[iter]);
        }
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.func_75146_a(new Slot((IInventory)this.invPlayer, row + column * 9 + 9, 8 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)this.invPlayer, column, 8 + column * 18, 142));
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotID);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (slotID < this.logic.func_70302_i_() ? (slotID == 0 ? !this.mergeCraftedStack(slotStack, this.logic.func_70302_i_(), this.field_75151_b.size(), true, player) : !this.func_75135_a(slotStack, this.logic.func_70302_i_(), this.field_75151_b.size(), true)) : !this.func_75135_a(slotStack, 1, this.logic.func_70302_i_(), false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    protected void craftTool(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (!tags.func_74775_l("InfiTool").func_74764_b("Built")) {
            tags.func_74775_l("InfiTool").func_74757_a("Built", true);
            for (int i = 2; i <= 3; ++i) {
                this.logic.func_70298_a(i, 1);
            }
            int amount = this.logic.func_70301_a(1).func_77973_b() instanceof ToolCore ? stack.field_77994_a : 1;
            this.logic.func_70298_a(1, amount);
            this.logic.field_70331_k.func_72908_a((double)this.logic.field_70329_l, (double)this.logic.field_70330_m, (double)this.logic.field_70327_n, "tinker:little_saw", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected boolean mergeCraftedStack(ItemStack stack, int slotsStart, int slotsTotal, boolean playerInventory, EntityPlayer player) {
        boolean failedToMerge = false;
        int slotIndex = slotsStart;
        if (playerInventory) {
            slotIndex = slotsTotal - 1;
        }
        ItemStack copyStack = null;
        if (stack.field_77994_a > 0) {
            slotIndex = playerInventory ? slotsTotal - 1 : slotsStart;
            while (!playerInventory && slotIndex < slotsTotal || playerInventory && slotIndex >= slotsStart) {
                Slot otherInventorySlot = (Slot)this.field_75151_b.get(slotIndex);
                copyStack = otherInventorySlot.func_75211_c();
                if (copyStack == null) {
                    this.craftTool(stack);
                    otherInventorySlot.func_75215_d(stack.func_77946_l());
                    otherInventorySlot.func_75218_e();
                    stack.field_77994_a = 0;
                    failedToMerge = true;
                    break;
                }
                if (playerInventory) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return failedToMerge;
    }
}

