/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.armor;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.armor.ArmorCore;
import tconstruct.library.armor.EnumArmorPart;

public class ExoArmor
extends ArmorCore {
    String textureName;
    protected static final UUID speed = UUID.fromString("CB3F55A9-629C-4F38-A497-9C13A33DB5CF");
    protected static final UUID attack = UUID.fromString("CB3F55A9-629C-4F38-A497-9C13A33DB5CE");
    protected static final UUID health = UUID.fromString("CB3F55A9-629C-4F38-A497-9C13A33DB5CD");
    protected static final UUID knockback = UUID.fromString("CB3F55A9-629C-4F38-A497-9C13A33DB5CC");

    public ExoArmor(int id, EnumArmorPart part, String texture) {
        super(id, 0, part);
        this.textureName = texture;
        this.func_77637_a(TConstructRegistry.materialTab);
    }

    public void func_94581_a(IconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("tinker:armor/" + this.textureName + "_" + (this.field_77881_a == 0 ? "helmet" : (this.field_77881_a == 1 ? "chestplate" : (this.field_77881_a == 2 ? "leggings" : (this.field_77881_a == 3 ? "boots" : "helmet")))));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, int layer) {
        return "tinker:textures/armor/" + this.textureName + "_" + layer + ".png";
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack armor = new ItemStack(par1, 1, 0);
        NBTTagCompound baseTag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)this.getAttributeTag("generic.attackDamage", "ExoAttack", 10.0, true, knockback));
        list.func_74742_a((NBTBase)this.getAttributeTag("generic.movementSpeed", "ExoSpeed", 1.5, false, speed));
        list.func_74742_a((NBTBase)this.getAttributeTag("generic.maxHealth", "ExoHealth", 10.0, true, health));
        list.func_74742_a((NBTBase)this.getAttributeTag("generic.knockbackResistance", "ExoKnockback", 0.5, false, knockback));
        baseTag.func_74782_a("AttributeModifiers", (NBTBase)list);
        armor.func_77982_d(baseTag);
        par3List.add(armor);
    }

    private NBTTagCompound getAttributeTag(String attributeType, String modifierName, double amount, boolean flat, UUID uuid) {
        NBTTagCompound knockbackTag = new NBTTagCompound();
        knockbackTag.func_74778_a("AttributeName", attributeType);
        knockbackTag.func_74778_a("Name", modifierName);
        knockbackTag.func_74780_a("Amount", amount);
        knockbackTag.func_74768_a("Operation", flat ? 0 : 1);
        knockbackTag.func_74772_a("UUIDMost", uuid.getMostSignificantBits());
        knockbackTag.func_74772_a("UUIDLeast", uuid.getLeastSignificantBits());
        return knockbackTag;
    }
}

