/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import tconstruct.TConstruct;
import tconstruct.plugins.ICompatPlugin;
import tconstruct.plugins.fmp.ForgeMultiPart;
import tconstruct.plugins.minefactoryreloaded.MineFactoryReloaded;
import tconstruct.plugins.nei.NotEnoughItems;
import tconstruct.plugins.waila.Waila;

public class PluginController {
    private static PluginController instance;
    private List<ICompatPlugin> plugins = new ArrayList<ICompatPlugin>();
    private Phase currPhase = Phase.PRELAUNCH;

    private PluginController() {
    }

    public static PluginController getController() {
        if (instance == null) {
            instance = new PluginController();
        }
        return instance;
    }

    public void registerPlugin(ICompatPlugin plugin) {
        if (Loader.isModLoaded((String)plugin.getModId())) {
            TConstruct.logger.info("Registering compat plugin for " + plugin.getModId());
            this.plugins.add(plugin);
            switch (this.currPhase) {
                case DONE: 
                case POSTINIT: {
                    plugin.preInit();
                    plugin.init();
                    plugin.postInit();
                    break;
                }
                case INIT: {
                    plugin.preInit();
                    plugin.init();
                    break;
                }
                case PREINIT: {
                    plugin.preInit();
                    break;
                }
            }
        }
    }

    public void preInit() {
        this.currPhase = Phase.PREINIT;
        for (ICompatPlugin plugin : this.plugins) {
            plugin.preInit();
        }
    }

    public void init() {
        this.currPhase = Phase.INIT;
        for (ICompatPlugin plugin : this.plugins) {
            plugin.init();
        }
    }

    public void postInit() {
        this.currPhase = Phase.POSTINIT;
        for (ICompatPlugin plugin : this.plugins) {
            plugin.postInit();
        }
        this.currPhase = Phase.DONE;
    }

    public void registerBuiltins() {
        this.registerPlugin(new ForgeMultiPart());
        this.registerPlugin(new MineFactoryReloaded());
        this.registerPlugin(new NotEnoughItems());
        this.registerPlugin(new Waila());
    }

    private static enum Phase {
        PRELAUNCH,
        PREINIT,
        INIT,
        POSTINIT,
        DONE;

    }
}

