/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import tconstruct.TConstruct;
import tconstruct.util.CallableSuppConfig;
import tconstruct.util.CallableUnsuppConfig;

public class EnvironmentChecks {
    private EnvironmentChecks() {
    }

    public static void verifyEnvironmentSanity() {
        Object callable;
        ArrayList<String> modIds = new ArrayList<String>();
        if (Loader.isModLoaded((String)"gregtech_addon")) {
            TConstruct.logger.severe("[Environment Checks] Gelatinous iceberg dead ahead! Entering Greggy waters! Abandon hope all ye who enter here! (No, seriously, we don't support GT. Don't report any issues. Thanks.)");
            TConstruct.logger.severe("[Environment Checks] A NOTE TO THE USER: Gregtech has been known to crash the game with Metallurgy and for certain specific 'banished' players.");
            TConstruct.logger.severe("[Environment Checks]                     For this reason, the TCon dev team urge you to seek your tedium fix from someone else, as Greg disobeys");
            TConstruct.logger.severe("[Environment Checks]                     the basic tenets of good modders conduct. We log this message rather than sabotage. We'd hope he'd do the same.");
            TConstruct.logger.severe("[Environment Checks]                     In the meantime, we recommend not playing anything but IC2 alongside Gregtech. ~ Sunstrike");
            TConstruct.logger.severe("[Environment Checks] GT Appendum I: And now he's going after Forge Mod Loader too...");
            TConstruct.logger.severe("[Environment Checks]                http://forum.industrial-craft.net/index.php?page=Thread&postID=138551#post138551 ~ SlimeKnights");
            modIds.add("gregtech_addon");
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && FMLClientHandler.instance().hasOptifine() || Loader.isModLoaded((String)"optifine")) {
            TConstruct.logger.severe("[Environment Checks] Optifine detected. This is a Bad Thing(tm) and can crash Minecraft due to an Optifine bug during TCon armor renders!");
            modIds.add("optifine");
        }
        try {
            Class<?> cl = Class.forName("org.bukkit.Bukkit");
            if (cl != null) {
                TConstruct.logger.severe("[Environment Checks] Bukkit implementation detected. This may be crashy. Bukkit implementations include Craftbukkit and MCPC+.");
                modIds.add("bukkit");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (modIds.size() == 0) {
            callable = new CallableSuppConfig();
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)callable);
        } else {
            callable = new CallableUnsuppConfig(modIds);
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)callable);
        }
    }
}

