/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import enhancedcore.packet.PacketHelper;
import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldHelper;
import enhancedportals.lib.BlockIds;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.portal.network.DialDeviceNetworkObject;
import enhancedportals.tileentity.TileEntityDialDevice;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;

public class PacketDialEntry
extends PacketEnhancedPortals {
    int dimension;
    BlockPosition position;
    String Name;
    String Texture;
    String Identifier;
    byte Type;
    byte Thickness;

    public PacketDialEntry() {
    }

    public PacketDialEntry(TileEntityDialDevice device, byte type, DialDeviceNetworkObject obj) {
        this.position = device.getBlockPosition();
        this.dimension = device.field_70331_k.field_73011_w.field_76574_g;
        this.Name = obj.displayName;
        this.Texture = obj.texture;
        this.Identifier = obj.network;
        this.Thickness = obj.thickness;
        this.Type = type;
    }

    public PacketDialEntry(TileEntityDialDevice device, byte type, String name, String texture, String identifier, byte thickness) {
        this.position = device.getBlockPosition();
        this.dimension = device.field_70331_k.field_73011_w.field_76574_g;
        this.Name = name;
        this.Texture = texture;
        this.Identifier = identifier;
        this.Thickness = thickness;
        this.Type = type;
    }

    @Override
    public PacketEnhancedPortals consumePacket(DataInputStream stream) throws IOException {
        this.position = BlockPosition.getBlockPosition((DataInputStream)stream);
        this.dimension = stream.readInt();
        this.Name = stream.readUTF();
        this.Texture = stream.readUTF();
        this.Identifier = stream.readUTF();
        this.Thickness = stream.readByte();
        this.Type = stream.readByte();
        return this;
    }

    @Override
    public void execute(INetworkManager network, EntityPlayer player) {
        if (WorldHelper.getBlockId((int)this.dimension, (BlockPosition)this.position) == BlockIds.DialDevice && WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position) instanceof TileEntityDialDevice) {
            if (this.Type == 0) {
                TileEntityDialDevice dial = (TileEntityDialDevice)WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position);
                if (!dial.hasDestination(new DialDeviceNetworkObject(this.Name, this.Identifier, this.Texture, this.Thickness))) {
                    dial.destinationList.add(new DialDeviceNetworkObject(this.Name, this.Identifier, this.Texture, this.Thickness));
                }
            } else if (this.Type == 1) {
                TileEntityDialDevice dial = (TileEntityDialDevice)WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position);
                dial.removeDestination(new DialDeviceNetworkObject(this.Name, this.Identifier, this.Texture, this.Thickness));
            }
        }
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        return PacketHelper.getByteArray((Object[])new Object[]{this.position, this.dimension, this.Name, this.Texture, this.Identifier, this.Thickness, this.Type});
    }
}

