/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import enhancedcore.packet.PacketHelper;
import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldHelper;
import enhancedportals.lib.BlockIds;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.portal.Portal;
import enhancedportals.tileentity.TileEntityNetherPortal;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;

public class PacketNetherPortalUpdate
extends PacketEnhancedPortals {
    int dimension;
    BlockPosition position;
    String texture;
    byte thickness;
    boolean particles;
    boolean sound;
    boolean hasParent;

    public PacketNetherPortalUpdate() {
    }

    public PacketNetherPortalUpdate(TileEntityNetherPortal portal) {
        this.position = portal.getBlockPosition();
        this.dimension = portal.field_70331_k.field_73011_w.field_76574_g;
        this.particles = portal.producesParticles;
        this.sound = portal.producesSound;
        this.texture = portal.texture;
        this.thickness = portal.thickness;
        this.hasParent = portal.hasParent;
    }

    @Override
    public PacketEnhancedPortals consumePacket(DataInputStream stream) throws IOException {
        this.position = BlockPosition.getBlockPosition((DataInputStream)stream);
        this.dimension = stream.readInt();
        this.thickness = stream.readByte();
        this.particles = stream.readBoolean();
        this.sound = stream.readBoolean();
        this.texture = stream.readUTF();
        this.hasParent = stream.readBoolean();
        return this;
    }

    @Override
    public void execute(INetworkManager network, EntityPlayer player) {
        if (WorldHelper.getBlockId((int)this.dimension, (BlockPosition)this.position) == BlockIds.NetherPortal && WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position) instanceof TileEntityNetherPortal) {
            Portal portal = new Portal(this.position.getX(), this.position.getY(), this.position.getZ(), WorldHelper.getWorld((int)this.dimension));
            portal.updateData(this.sound, this.particles, this.thickness);
            portal.updateTexture(this.texture);
            ((TileEntityNetherPortal)WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position)).hasParent = this.hasParent;
        }
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        return PacketHelper.getByteArray((Object[])new Object[]{this.position, this.dimension, this.thickness, this.particles, this.sound, this.texture, this.hasParent});
    }
}

