/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.network.packet;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import enhancedcore.packet.PacketHelper;
import enhancedcore.world.BlockPosition;
import enhancedcore.world.WorldHelper;
import enhancedcore.world.WorldPosition;
import enhancedportals.EnhancedPortals;
import enhancedportals.lib.BlockIds;
import enhancedportals.network.packet.PacketEnhancedPortals;
import enhancedportals.network.packet.PacketMisc;
import enhancedportals.tileentity.TileEntityPortalModifier;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;

public class PacketPortalModifierUpdate
extends PacketEnhancedPortals {
    int dimension;
    BlockPosition position;
    byte thickness;
    byte redstoneSetting;
    String texture;
    String modifierNetwork;
    String dialDeviceNetwork;

    public PacketPortalModifierUpdate() {
    }

    public PacketPortalModifierUpdate(TileEntityPortalModifier modifier) {
        this.position = modifier.getBlockPosition();
        this.thickness = modifier.thickness;
        this.redstoneSetting = modifier.redstoneSetting;
        this.dimension = modifier.field_70331_k.field_73011_w.field_76574_g;
        this.texture = modifier.texture;
        this.modifierNetwork = modifier.modifierNetwork;
        this.dialDeviceNetwork = modifier.dialDeviceNetwork;
    }

    @Override
    public PacketEnhancedPortals consumePacket(DataInputStream stream) throws IOException {
        this.position = BlockPosition.getBlockPosition((DataInputStream)stream);
        this.dimension = stream.readInt();
        this.thickness = stream.readByte();
        this.redstoneSetting = stream.readByte();
        this.texture = stream.readUTF();
        this.modifierNetwork = stream.readUTF();
        this.dialDeviceNetwork = stream.readUTF();
        return this;
    }

    @Override
    public void execute(INetworkManager network, EntityPlayer player) {
        WorldPosition loc = new WorldPosition(this.position.getX(), this.position.getY(), this.position.getZ(), this.dimension);
        if (WorldHelper.getBlockId((int)this.dimension, (BlockPosition)this.position) == BlockIds.PortalModifier && WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position) instanceof TileEntityPortalModifier) {
            TileEntityPortalModifier modifier = (TileEntityPortalModifier)WorldHelper.getTileEntity((int)this.dimension, (BlockPosition)this.position);
            modifier.texture = this.texture;
            modifier.redstoneSetting = this.redstoneSetting;
            modifier.thickness = this.thickness;
            if (!WorldHelper.getWorld((int)this.dimension).field_72995_K) {
                if (modifier.isRemotelyControlled()) {
                    EnhancedPortals.proxy.DialDeviceNetwork.removeFromAllNetworks(loc);
                    EnhancedPortals.proxy.DialDeviceNetwork.addToNetwork(this.dialDeviceNetwork, loc);
                    if (EnhancedPortals.proxy.DialDeviceNetwork.isInNetwork(this.dialDeviceNetwork, loc)) {
                        modifier.dialDeviceNetwork = this.dialDeviceNetwork;
                    } else {
                        modifier.dialDeviceNetwork = "";
                        PacketDispatcher.sendPacketToPlayer((Packet)PacketEnhancedPortals.makePacket(new PacketMisc(1, 0)), (Player)((Player)player));
                    }
                } else {
                    EnhancedPortals.proxy.ModifierNetwork.removeFromAllNetworks(loc);
                    EnhancedPortals.proxy.ModifierNetwork.addToNetwork(this.modifierNetwork, loc);
                    modifier.modifierNetwork = this.modifierNetwork;
                }
            } else {
                modifier.modifierNetwork = this.modifierNetwork;
                modifier.dialDeviceNetwork = this.dialDeviceNetwork;
            }
            WorldHelper.markBlockForUpdate((int)this.dimension, (BlockPosition)this.position);
        }
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        return PacketHelper.getByteArray((Object[])new Object[]{this.position, this.dimension, this.thickness, this.redstoneSetting, this.texture, this.modifierNetwork, this.dialDeviceNetwork});
    }
}

