/*
 * Decompiled with CFR 0.152.
 */
package enhancedportals.portal.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import enhancedcore.world.WorldPosition;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class NetworkManager {
    public Map<String, List<WorldPosition>> networkData;
    private String saveFile;
    private MinecraftServer serverInstance;

    public NetworkManager(MinecraftServer server) {
        this.serverInstance = server;
        this.networkData = new HashMap<String, List<WorldPosition>>();
        WorldServer world = this.serverInstance.func_71218_a(0);
        this.saveFile = FMLCommonHandler.instance().getSide() == Side.SERVER ? this.serverInstance.func_71209_f(world.func_72860_G().func_75760_g() + File.separator + this.getSaveFileName()).getAbsolutePath() : this.serverInstance.func_71209_f("saves" + File.separator + world.func_72860_G().func_75760_g() + File.separator + this.getSaveFileName()).getAbsolutePath();
        if (!new File(this.saveFile).exists()) {
            try {
                new File(this.saveFile).createNewFile();
            }
            catch (IOException e) {
                return;
            }
        }
        this.loadData();
    }

    public void addNetwork(String key) {
        if (key == null) {
            return;
        }
        if (this.hasNetwork(key)) {
            return;
        }
        this.networkData.put(key, new ArrayList());
    }

    public void addToNetwork(String key, WorldPosition data) {
        if (key == null) {
            return;
        }
        if (!this.hasNetwork(key)) {
            this.addNetwork(key);
        }
        if (this.networkContains(key, data)) {
            return;
        }
        this.networkData.get(key).add(data);
    }

    public List<WorldPosition> getNetwork(String key) {
        if (key == null) {
            return new ArrayList<WorldPosition>();
        }
        if (!this.hasNetwork(key)) {
            return new ArrayList<WorldPosition>();
        }
        List<WorldPosition> list = this.networkData.get(key);
        ArrayList<WorldPosition> newList = new ArrayList<WorldPosition>();
        if (list == null) {
            return new ArrayList<WorldPosition>();
        }
        for (int i = 0; i < list.size(); ++i) {
            newList.add(list.get(i));
        }
        return newList;
    }

    public String getNetwork(WorldPosition data) {
        for (String key : this.networkData.keySet()) {
            if (!this.isInNetwork(key, data)) continue;
            return key;
        }
        return "";
    }

    public List<WorldPosition> getNetworkExcluding(String network, WorldPosition worldLocation) {
        if (network == null) {
            return new ArrayList<WorldPosition>();
        }
        List<WorldPosition> list = this.networkData.get(network);
        ArrayList<WorldPosition> newList = new ArrayList<WorldPosition>();
        if (list == null) {
            return new ArrayList<WorldPosition>();
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).equals((Object)worldLocation)) continue;
            newList.add(list.get(i));
        }
        return newList;
    }

    public String getSaveFileName() {
        return "EP2.dat";
    }

    public boolean hasNetwork(String key) {
        if (key == null) {
            return false;
        }
        for (String key2 : this.networkData.keySet()) {
            if (!key.equals(key2)) continue;
            return true;
        }
        return false;
    }

    public boolean isInNetwork(String key, WorldPosition data) {
        if (!this.hasNetwork(key)) {
            return false;
        }
        return this.networkContains(key, data);
    }

    public void loadData() {
        try {
            NBTTagCompound tagCompound = (NBTTagCompound)NBTBase.func_74739_b((DataInput)new DataInputStream(new FileInputStream(this.saveFile)));
            for (Object obj : tagCompound.func_74758_c()) {
                if (!(obj instanceof NBTTagList)) continue;
                NBTTagList tag = (NBTTagList)obj;
                for (int i = 0; i < tag.field_74747_a.size(); ++i) {
                    NBTTagCompound comp = (NBTTagCompound)tag.func_74743_b(i);
                    this.addToNetwork(tag.func_74740_e(), new WorldPosition(comp.func_74762_e("xCoord"), comp.func_74762_e("yCoord"), comp.func_74762_e("zCoord"), comp.func_74762_e("dimension")));
                }
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public boolean networkContains(String key, WorldPosition data) {
        if (!this.hasNetwork(key)) {
            return false;
        }
        for (WorldPosition keyData : this.getNetwork(key)) {
            if (!keyData.equals((Object)data)) continue;
            return true;
        }
        return false;
    }

    public void removeFromAllNetworks(WorldPosition worldLocation) {
        for (String str : this.networkData.keySet()) {
            if (!this.isInNetwork(str, worldLocation)) continue;
            this.removeFromNetwork(str, worldLocation);
        }
    }

    public void removeFromNetwork(String key, WorldPosition data) {
        if (!this.hasNetwork(key)) {
            return;
        }
        if (!this.isInNetwork(key, data)) {
            return;
        }
        for (int i = 0; i < this.networkData.get(key).size(); ++i) {
            if (!this.networkData.get(key).get(i).equals((Object)data)) continue;
            this.networkData.get(key).remove(i);
        }
    }

    public void removeNetwork(String key) {
        if (!this.hasNetwork(key)) {
            return;
        }
        this.networkData.remove(key);
    }

    public void saveData() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        for (Map.Entry<String, List<WorldPosition>> set : this.networkData.entrySet()) {
            if (set.getValue().isEmpty()) continue;
            NBTTagList list2 = new NBTTagList();
            for (WorldPosition loc : set.getValue()) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("xCoord", loc.getX());
                compound.func_74768_a("yCoord", loc.getY());
                compound.func_74768_a("zCoord", loc.getZ());
                compound.func_74768_a("dimension", loc.getDimension());
                list2.func_74742_a((NBTBase)compound);
            }
            tagCompound.func_74782_a(set.getKey(), (NBTBase)list2);
        }
        try {
            NBTBase.func_74731_a((NBTBase)tagCompound, (DataOutput)new DataOutputStream(new FileOutputStream(this.saveFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

