/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.buildcraft;

import buildcraft.api.fuels.IronEngineFuel;
import java.util.HashMap;
import java.util.List;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.SimpleFuelContextHelper;
import mods.neiplugins.common.SimpleFuelHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BuildcraftFuelHelper {
    public static Class guiCombustionEngine = null;
    public static Class guiSteamEngine = null;

    public static void registerFuelHelpers() {
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("buildcraft.ironengine", "Combustion Engine", null){

            @Override
            public List<String> getFluidStackFuelTooltip(FluidStack liquid, List<String> currenttip) {
                IronEngineFuel.Fuel fuel = IronEngineFuel.getFuelForFluid((Fluid)liquid.getFluid());
                if (fuel != null) {
                    currenttip.add("\u00a77" + FuelTooltip.convertMJtF(fuel.powerPerCycle) + " MJ/t for " + fuel.totalBurningTime * liquid.amount / 1000 + " ticks (" + "Combustion Engine" + ")");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("buildcraft.stoneengine", "Stirling Engine", null){

            @Override
            public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
                int fuelValue = TileEntityFurnace.func_70398_a((ItemStack)stack);
                if (fuelValue > 0) {
                    currenttip.add("\u00a771 MJ/t for " + fuelValue + " ticks (" + "Stirling Engine" + ")");
                }
                return currenttip;
            }
        });
        HashMap<Class, String> map = new HashMap<Class, String>();
        if (guiCombustionEngine != null) {
            map.put(guiCombustionEngine, "buildcraft.ironengine");
        }
        if (guiSteamEngine != null) {
            map.put(guiSteamEngine, "buildcraft.stoneengine");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("bc.engines", "Buildcraft Engines", null, map));
        }
    }
}

