/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.ic2_exp;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.recipe.ICannerBottleRecipeManager;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class CannerBottleRecipeHandler
extends LiquidTemplateRecipeHandler {
    @Override
    public String getRecipeId() {
        return "ic2.canner";
    }

    public String getRecipeName() {
        return "Canning Machine";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(69, 11, 22, 15), this.getRecipeId(), new Object[0]));
    }

    public Set<Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput>> getRecipes() {
        return Recipes.cannerBottle.getRecipes().entrySet();
    }

    @Override
    public void loadSameRecipeId() {
        for (Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput> irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedCannerBottleRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput> irecipe : this.getRecipes()) {
            if (irecipe.getValue() == null) continue;
            for (ItemStack stack : irecipe.getValue().items) {
                if (!NEIClientUtils.areStacksSameType((ItemStack)stack, (ItemStack)result)) continue;
                this.arecipes.add(new CachedCannerBottleRecipe(irecipe));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput> irecipe : this.getRecipes()) {
            if ((irecipe.getKey().container == null || !irecipe.getKey().container.matches(ingredient)) && (irecipe.getKey().fill == null || !irecipe.getKey().fill.matches(ingredient))) continue;
            CachedCannerBottleRecipe recipe = new CachedCannerBottleRecipe(irecipe);
            this.setIngredientPermutationNBT(recipe.slot_input, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)34, (int)4, (int)39, (int)15, (int)98, (int)82);
        GuiDraw.drawTexturedModalRect((int)58, (int)70, (int)196, (int)20, (int)50, (int)14);
        GuiDraw.drawTexturedModalRect((int)54, (int)42, (int)3, (int)4, (int)9, (int)18);
        GuiDraw.drawTexturedModalRect((int)94, (int)42, (int)3, (int)4, (int)18, (int)23);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getGuiTexture() {
        return "ic2:textures/gui/GUICanner.png";
    }

    public class CachedCannerBottleRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList<PositionedStack> slot_input;
        PositionedStack slot_output;

        public CachedCannerBottleRecipe(Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput> recipe) {
            this(recipe.getKey(), recipe.getValue());
        }

        public CachedCannerBottleRecipe(ICannerBottleRecipeManager.Input input, RecipeOutput output) {
            super((TemplateRecipeHandler)CannerBottleRecipeHandler.this);
            this.slot_input = new ArrayList();
            if (input.container != null) {
                this.slot_input.add(new PositionedStack((Object)input.container.getInputs(), 36, 6));
            }
            if (input.fill != null) {
                this.slot_input.add(new PositionedStack((Object)input.fill.getInputs(), 75, 33));
            }
            this.slot_output = new PositionedStack(output.items.get(0), 114, 6);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CannerBottleRecipeHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return this.slot_output;
        }
    }
}

