/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.impl;

import codechicken.nei.ItemList;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import java.lang.reflect.Field;
import java.util.Collection;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.interfaces.IItemListLoaded;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class FurnaceRHFuelFix
implements IItemListLoaded {
    private Field target;
    private Collection defaultValue;
    private boolean fuelLoaded;
    private String name;
    private FurnaceRecipeHandler.FuelPair pair;

    public FurnaceRHFuelFix(String name, Field target, Collection defaultValue, int x, int y) {
        this.target = target;
        this.defaultValue = defaultValue;
        this.fuelLoaded = true;
        this.name = name;
        ItemStack coal = new ItemStack(Item.field_77705_m, 1);
        int burnTime = TileEntityFurnace.func_70398_a((ItemStack)coal);
        if (burnTime == 0) {
            burnTime = 1600;
        }
        this.pair = new FurnaceRecipeHandler.FuelPair(coal, burnTime);
        this.pair.stack.relx = x;
        this.pair.stack.rely = y;
    }

    public FurnaceRHFuelFix(String name, Field target, Collection defaultValue) {
        this(name, target, defaultValue, 51, 42);
    }

    @Override
    public String getName() {
        return "Furnace Fuel fix (" + this.name + ")";
    }

    @Override
    public void onLoadConfig() {
        this.fuelLoaded = true;
        try {
            Collection o2;
            Object o = this.target.get(null);
            if (o == null) {
                this.target.set(null, this.defaultValue);
                o = this.defaultValue;
            }
            if (!(o instanceof Collection)) {
                NEIPlugins.logWarning("Field {0} of class {1} not instance of Collection", this.target.getName(), this.target.getDeclaringClass().getName());
                return;
            }
            this.defaultValue = o2 = (Collection)o;
            if (this.defaultValue.isEmpty()) {
                this.defaultValue.add(this.pair);
                this.fuelLoaded = false;
            }
        }
        catch (Throwable ex) {
            NEIPlugins.logWarningEx("Error in FurnaceRHFuelFix.onLoadConfig({0})", ex, this.getName());
            this.fuelLoaded = true;
        }
    }

    @Override
    public void onItemListLoaded() {
        if (this.fuelLoaded) {
            return;
        }
        if (this.defaultValue.size() != 1) {
            NEIPlugins.logWarning("FurnaceRHFuelFix.onItemListLoaded({0}): size of target field != 1 ({1})", this.getName(), this.defaultValue.size());
            return;
        }
        this.defaultValue.clear();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (FurnaceRecipeHandler.efuels.contains(item.field_77993_c) || (burnTime = TileEntityFurnace.func_70398_a((ItemStack)item)) <= 0) continue;
            FurnaceRecipeHandler.FuelPair pair = new FurnaceRecipeHandler.FuelPair(item.func_77946_l(), burnTime);
            pair.stack.relx = this.pair.stack.relx;
            pair.stack.rely = this.pair.stack.rely;
            this.defaultValue.add(pair);
        }
        if (this.defaultValue.isEmpty()) {
            this.defaultValue.add(this.pair);
        }
        this.fuelLoaded = true;
    }
}

