/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.railcraft;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import mods.railcraft.api.crafting.ICokeOvenRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CokeOvenRecipeHandler
extends LiquidTemplateRecipeHandler {
    static Rectangle outputTank = new Rectangle(85, 13, 48, 47);
    static Point overlayTank = new Point(176, 0);
    public static Class<? extends GuiContainer> guiclass;

    public String getRecipeName() {
        return "Coke Oven";
    }

    @Override
    public String getRecipeId() {
        return "railcraft.cokeoven";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(29, 32, 22, 16), this.getRecipeId(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiclass;
    }

    @Override
    public void loadSameRecipeId() {
        for (ICokeOvenRecipe recipe : RailcraftCraftingManager.cokeOven.getRecipes()) {
            this.arecipes.add(new CachedOvenRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (ICokeOvenRecipe recipe : RailcraftCraftingManager.cokeOven.getRecipes()) {
            if (!recipe.getFluidOutput().isFluidEqual(result)) continue;
            this.arecipes.add(new CachedOvenRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingred) {
        for (ICokeOvenRecipe recipe : RailcraftCraftingManager.cokeOven.getRecipes()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)recipe.getInput(), (ItemStack)ingred)) continue;
            this.arecipes.add(new CachedOvenRecipe(recipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack t = LiquidHelper.getFluidStack(result);
        for (ICokeOvenRecipe recipe : RailcraftCraftingManager.cokeOven.getRecipes()) {
            if ((t == null || !recipe.getFluidOutput().isFluidEqual(t)) && !NEIClientUtils.areStacksSameType((ItemStack)result, (ItemStack)recipe.getOutput())) continue;
            this.arecipes.add(new CachedOvenRecipe(recipe));
        }
    }

    public String getGuiTexture() {
        return "railcraft:textures/gui/gui_coke_oven.png";
    }

    public void drawExtras(int recipe) {
    }

    public class CachedOvenRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ICokeOvenRecipe oven;
        ArrayList<PositionedStack> inputs;
        PositionedStack output;
        PositionedStack liquidInput;
        PositionedStack liquidOutput;
        LiquidTank tank;

        public CachedOvenRecipe(ICokeOvenRecipe base) {
            super((TemplateRecipeHandler)CokeOvenRecipeHandler.this);
            this.oven = base;
            this.tank = new LiquidTank(base.getFluidOutput(), 64000, outputTank, overlayTank);
            PositionedStack input = new PositionedStack((Object)this.oven.getInput(), 11, 32);
            this.output = new PositionedStack((Object)this.oven.getOutput(), 57, 32);
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.tank.liquid, 144, 11, 144, 46);
            this.liquidInput = output_cont[0];
            this.liquidOutput = output_cont[1];
            this.inputs = new ArrayList();
            this.inputs.add(input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CokeOvenRecipeHandler.this.cycleticks / 20, this.inputs);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(LiquidHelper.getSeqCycledStack(CokeOvenRecipeHandler.this.cycleticks / 20, this.liquidInput));
            stacks.add(LiquidHelper.getSeqCycledStack(CokeOvenRecipeHandler.this.cycleticks / 20, this.liquidOutput));
            return stacks;
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.tank);
            return res;
        }
    }
}

