/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.TileEntities;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.ArrayList;
import lumien.randomthings.Items.ItemFilter;
import lumien.randomthings.Items.ModItems;
import lumien.randomthings.Library.Interfaces.IRedstoneControlled;
import lumien.randomthings.Utility.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockFluid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityBlockBreaker
extends TileEntity
implements IPipeConnection,
IInventory,
IRedstoneControlled {
    int destroyCounter = 0;
    int redstoneMode = 0;
    int tickRate = 10;
    int tickCounter = 0;
    public boolean upgraded = false;
    public int id = WorldUtils.getBreakerID();
    ItemStack[] inv = new ItemStack[1];

    private boolean isHarvestable(int blockID, int metadata) {
        return ((!this.upgraded ? Item.field_77696_g.func_77641_a(Block.field_71973_m[blockID]) : Item.field_77674_B.func_77641_a(Block.field_71973_m[blockID])) || Block.field_71973_m[blockID].field_72018_cp.func_76229_l()) && Block.field_71973_m[blockID].field_71989_cb != -1.0f && !(Block.field_71973_m[blockID] instanceof BlockFluid);
    }

    private boolean isFiltered(int targetX, int targetY, int targetZ) {
        if (this.inv[0] != null) {
            int blockID = ModItems.filter.getBlockID(this.inv[0]);
            int metadata = ModItems.filter.getBlockMetadata(this.inv[0]);
            if (blockID != -1) {
                return this.field_70331_k.func_72798_a(targetX, targetY, targetZ) == blockID && this.field_70331_k.func_72805_g(targetX, targetY, targetZ) == metadata;
            }
            return true;
        }
        return true;
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K && (this.redstoneMode == 0 || this.redstoneMode == 1 && !this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) || this.redstoneMode == 2 && this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n))) {
            ++this.tickCounter;
            if (this.tickCounter >= this.tickRate) {
                this.tickCounter = 0;
                EnumFacing facing = BlockDispenser.func_100009_j_((int)(this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n) - 1));
                int targetX = this.field_70329_l + facing.func_82601_c();
                int targetY = this.field_70330_m + facing.func_96559_d();
                int targetZ = this.field_70327_n + facing.func_82599_e();
                int blockID = this.field_70331_k.func_72798_a(targetX, targetY, targetZ);
                if (this.isFiltered(targetX, targetY, targetZ) && !this.field_70331_k.func_72799_c(targetX, targetY, targetZ) && this.isHarvestable(blockID, this.field_70331_k.func_72805_g(targetX, targetY, targetZ))) {
                    this.tickRate = 3;
                    this.field_70331_k.func_72888_f(this.id, targetX, targetY, targetZ, this.destroyCounter);
                    ++this.destroyCounter;
                    if (this.destroyCounter >= 10 || this.upgraded) {
                        this.field_70331_k.func_72888_f(this.id, targetX, targetY, targetZ, -1);
                        int inventoryX = this.field_70329_l - facing.func_82601_c();
                        int inventoryY = this.field_70330_m - facing.func_96559_d();
                        int inventoryZ = this.field_70327_n - facing.func_82599_e();
                        TileEntity te = this.field_70331_k.func_72796_p(inventoryX, inventoryY, inventoryZ);
                        Block.field_71973_m[this.field_70331_k.func_72798_a(targetX, targetY, targetZ)].func_71898_d(this.field_70331_k, targetX, targetY, targetZ, this.field_70331_k.func_72805_g(targetX, targetY, targetZ));
                        if (te != null && te instanceof IInventory) {
                            IInventory inventory = (IInventory)te;
                            ArrayList drops = Block.field_71973_m[blockID].getBlockDropped(this.field_70331_k, targetX, targetY, targetZ, this.field_70331_k.func_72805_g(targetX, targetY, targetZ), 0);
                            for (ItemStack is : drops) {
                                if (this.putInInventory(this.field_70331_k, is, inventoryX, inventoryY, inventoryZ)) continue;
                                WorldUtils.dropItemStack(this.field_70331_k, targetX, targetY, targetZ, is);
                            }
                            this.field_70331_k.func_94578_a(targetX, targetY, targetZ, false);
                        } else if (te != null && te instanceof IPipeTile) {
                            ArrayList drops = Block.field_71973_m[blockID].getBlockDropped(this.field_70331_k, targetX, targetY, targetZ, this.field_70331_k.func_72805_g(targetX, targetY, targetZ), 0);
                            for (ItemStack is : drops) {
                                int number = ((IPipeTile)te).injectItem(is, true, ForgeDirection.getOrientation((int)facing.ordinal()));
                                if (number >= is.field_77994_a) continue;
                                is.field_77994_a -= number;
                                WorldUtils.dropItemStack(this.field_70331_k, targetX, targetY, targetZ, is);
                            }
                            this.field_70331_k.func_94578_a(targetX, targetY, targetZ, false);
                        } else {
                            this.field_70331_k.func_94578_a(targetX, targetY, targetZ, true);
                        }
                        this.destroyCounter = 0;
                    }
                } else {
                    this.field_70331_k.func_72888_f(this.id, targetX, targetY, targetZ, -1);
                    this.destroyCounter = 0;
                    this.tickRate = 10;
                }
            }
        }
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.upgraded = par1NBTTagCompound.func_74767_n("upgraded");
        NBTTagList tagList = par1NBTTagCompound.func_74761_m("Inventory");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.redstoneMode = par1NBTTagCompound.func_74762_e("redstoneMode");
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("upgraded", this.upgraded);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        par1NBTTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
    }

    private boolean putInInventory(World worldObj, ItemStack stack, int x, int y, int z) {
        TileEntity te = worldObj.func_72796_p(x, y, z);
        if (te == null) {
            return false;
        }
        IInventory inventory = (IInventory)te;
        int invSize = inventory.func_70302_i_();
        int maxStackSize = inventory.func_70297_j_();
        for (int slot = 0; slot < invSize; ++slot) {
            int difference;
            if (stack.field_77994_a == 0) {
                return true;
            }
            if (!inventory.func_94041_b(slot, stack)) continue;
            ItemStack stackInSlot = inventory.func_70301_a(slot);
            if (stackInSlot == null) {
                inventory.func_70299_a(slot, stack.func_77946_l());
                stack.field_77994_a = 0;
                return true;
            }
            if (!stackInSlot.func_77969_a(stack) || stackInSlot.field_77994_a >= maxStackSize || stackInSlot.func_77973_b().func_77639_j() <= stackInSlot.field_77994_a) continue;
            int space = Math.abs(stackInSlot.func_77973_b().func_77639_j() - stackInSlot.field_77994_a);
            if (space < (difference = Math.abs(maxStackSize - stackInSlot.field_77994_a))) {
                difference = space;
            }
            if (stack.field_77994_a <= difference) {
                stackInSlot.field_77994_a += stack.field_77994_a;
                stack.field_77994_a = 0;
                continue;
            }
            if (stack.field_77994_a <= difference) continue;
            stackInSlot.field_77994_a += difference;
            stack.field_77994_a -= difference;
        }
        return false;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type.equals((Object)IPipeTile.PipeType.ITEM)) {
            EnumFacing facing = BlockDispenser.func_100009_j_((int)(this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n) - 1));
            return ForgeDirection.getOrientation((int)facing.ordinal()).getOpposite() == with ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this && player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) < 64.0;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public String func_70303_b() {
        return "Block Detector";
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof ItemFilter && itemstack.func_77960_j() == 0;
    }

    @Override
    public void setRedstoneMode(int newMode) {
        this.redstoneMode = newMode;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public int[] getValidModes() {
        return new int[]{0, 1, 2};
    }
}

