/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.world.gen.dungeon;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreDungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreDungeonRoom;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreMapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ForgeDirection;

public class GCMarsRoomChests
extends GCCoreDungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    private final ArrayList<ChunkCoordinates> chests = new ArrayList();

    public GCMarsRoomChests(GCCoreMapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(5) + 6;
            this.sizeY = rand.nextInt(2) + 7;
            this.sizeZ = rand.nextInt(5) + 6;
        }
    }

    public void generate(short[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, 0, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, Block.field_72077_au.field_71990_ca, 0)) {
            this.chests.add(new ChunkCoordinates(hx, this.posY, hz));
        }
    }

    public GCCoreDungeonBoundingBox getBoundingBox() {
        return new GCCoreDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    protected GCCoreDungeonRoom makeRoom(GCCoreMapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new GCMarsRoomChests(dungeon, x, y, z, dir);
    }

    protected void handleTileEntities(Random rand) {
        if (!this.chests.isEmpty()) {
            this.worldObj.func_72832_d(this.chests.get((int)0).field_71574_a, this.chests.get((int)0).field_71572_b, this.chests.get((int)0).field_71573_c, Block.field_72077_au.field_71990_ca, 0, 2);
            TileEntityChest chest = (TileEntityChest)this.worldObj.func_72796_p(this.chests.get((int)0).field_71574_a, this.chests.get((int)0).field_71572_b, this.chests.get((int)0).field_71573_c);
            if (chest != null) {
                for (int i = 0; i < chest.func_70302_i_(); ++i) {
                    chest.func_70299_a(i, null);
                }
                ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)chest, (int)info.getCount(rand));
            }
            this.chests.clear();
        }
    }
}

