/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.mars.world.gen.dungeon;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreDungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreDungeonRoom;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.GCCoreMapGenDungeon;
import micdoodle8.mods.galacticraft.mars.blocks.GCMarsBlocks;
import micdoodle8.mods.galacticraft.mars.tile.GCMarsTileEntityTreasureChest;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.ForgeDirection;

public class GCMarsRoomTreasure
extends GCCoreDungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    private final ArrayList<ChunkCoordinates> chests = new ArrayList();

    public GCMarsRoomTreasure(GCCoreMapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(6) + 7;
            this.sizeY = rand.nextInt(2) + 8;
            this.sizeZ = rand.nextInt(6) + 7;
        }
    }

    public void generate(short[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    if (!(i != this.posX && i != this.posX + this.sizeX - 1 || k != this.posZ && k != this.posZ + this.sizeZ - 1)) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, Block.field_72014_bd.field_71990_ca, 0);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, 0, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, GCMarsBlocks.tier2TreasureChest.field_71990_ca, 0)) {
            this.chests.add(new ChunkCoordinates(hx, this.posY, hz));
        }
    }

    public GCCoreDungeonBoundingBox getBoundingBox() {
        return new GCCoreDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    protected GCCoreDungeonRoom makeRoom(GCCoreMapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new GCMarsRoomTreasure(dungeon, x, y, z, dir);
    }

    protected void handleTileEntities(Random rand) {
        if (!this.chests.isEmpty()) {
            for (int i = 0; i < this.chests.size(); ++i) {
                ChunkCoordinates coords = this.chests.get(i);
                this.worldObj.func_72832_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, GCMarsBlocks.tier2TreasureChest.field_71990_ca, 0, 3);
                this.worldObj.func_72837_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, (TileEntity)new GCMarsTileEntityTreasureChest());
                this.chests.remove(i);
            }
        }
    }
}

