/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tropicraft.blocks.BlockTropicraft;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.creative.TropiCreativeTabs;
import tropicraft.entities.passive.water.EntityTropicalFish;

public class BlockTropicsCoral
extends BlockTropicraft {
    public String[] imageNames;
    private Icon[] images;
    private static final float dayBrightness = 0.3f;
    private static final float nightBrightness = 0.6f;

    public BlockTropicsCoral(int id, String[] imageNamesNew, Material material) {
        super(id, material);
        this.images = new Icon[imageNamesNew.length];
        this.imageNames = new String[imageNamesNew.length];
        System.arraycopy(imageNamesNew, 0, this.imageNames, 0, imageNamesNew.length);
        this.func_71907_b(true);
        this.func_71849_a(TropiCreativeTabs.tabDecorations);
    }

    public Icon func_71858_a(int i, int j) {
        return this.images[j & 7];
    }

    public int func_71899_b(int i) {
        return i & 7;
    }

    public boolean func_71930_b(World world, int i, int j, int k) {
        return super.func_71930_b(world, i, j, k) && this.canThisPlantGrowOnThisBlockID(world.func_72798_a(i, j - 1, k)) && world.func_72803_f(i, j, k) == Material.field_76244_g && world.func_72803_f(i, j + 1, k) == Material.field_76244_g;
    }

    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Block.field_71980_u.field_71990_ca || i == Block.field_71979_v.field_71990_ca || i == Block.field_71939_E.field_71990_ca || i == TropicraftBlocks.purifiedSand.field_71990_ca;
    }

    public void func_71863_a(World world, int i, int j, int k, int l) {
        super.func_71863_a(world, i, j, k, l);
        this.checkFlowerChange(world, i, j, k);
    }

    public void func_71847_b(World world, int i, int j, int k, Random random) {
        this.checkFlowerChange(world, i, j, k);
        if (!world.field_72995_K) {
            this.generateTropicalFish(world, i, j, k, random);
        }
    }

    public void generateTropicalFish(World w, int i, int j, int k, Random r) {
        EntityPlayer p;
        int rate = 12;
        double maxDist = 16.0;
        if (r.nextInt(rate) == 0 && (p = w.func_72977_a((double)i, (double)j, (double)k, maxDist)) != null && !p.field_70128_L) {
            EntityTropicalFish fish = new EntityTropicalFish(w);
            fish.func_70107_b(i, j + 1, k);
            w.func_72838_d((Entity)fish);
        }
    }

    protected final void checkFlowerChange(World world, int i, int j, int k) {
        if (!this.func_71854_d(world, i, j, k)) {
            this.func_71897_c(world, i, j, k, world.func_72805_g(i, j, k) & 7, 0);
            world.func_94571_i(i, j, k);
        } else {
            int meta = world.func_72805_g(i, j, k);
            if (world.func_72935_r() != this.isDayCoral(meta)) {
                int newMetadata = meta & 7 | (this.isDayCoral(meta) ? 8 : 0);
                world.func_72832_d(i, j, k, this.field_71990_ca, newMetadata, 3);
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (this.isDayCoral(world.func_72805_g(x, y, z))) {
            return 4;
        }
        return 9;
    }

    private boolean isDayCoral(int metadata) {
        return (metadata & 8) == 0;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return 1;
    }

    public boolean func_71854_d(World world, int i, int j, int k) {
        return world.func_72803_f(i, j, k) == Material.field_76244_g && world.func_72803_f(i, j + 1, k) == Material.field_76244_g && this.canThisPlantGrowOnThisBlockID(world.func_72798_a(i, j - 1, k));
    }

    public AxisAlignedBB func_71872_e(World world, int i, int j, int k) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < this.imageNames.length; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }

    @Override
    public void func_94332_a(IconRegister iconRegistry) {
        for (int meta = 0; meta < this.imageNames.length; ++meta) {
            this.images[meta] = iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + meta);
        }
    }

    @Override
    public String getImageName() {
        return "coral_";
    }
}

