/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.blocks.tileentities;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import tropicraft.darts.Curare;
import tropicraft.darts.CurareMixRegistry;
import tropicraft.items.TropicraftItems;

public class TileEntityCurareBowl
extends TileEntity {
    public List<ItemStack> ingredients;
    private static final int REQUIRED_NUM_CLICKS = 30;
    public static final int TICKS_PER_PESTLE_CLICK = 5;
    public int pestleTicks;
    public int numClicks;

    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.ingredients = new ArrayList<ItemStack>();
        int length = par1nbtTagCompound.func_74762_e("ContentLength");
        for (int i = 0; i < length; ++i) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)par1nbtTagCompound.func_74775_l("Contents" + i));
            if (stack == null) continue;
            this.ingredients.add(stack);
        }
        this.numClicks = par1nbtTagCompound.func_74762_e("Clicks");
        this.pestleTicks = par1nbtTagCompound.func_74765_d("PestleTicks");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.ingredients != null) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (this.ingredients.get(i) == null) continue;
                NBTTagCompound var4 = new NBTTagCompound();
                this.ingredients.get(i).func_77955_b(var4);
                nbt.func_74766_a("Contents" + i, var4);
            }
            nbt.func_74768_a("ContentLength", this.ingredients.size());
        } else {
            this.ingredients = new ArrayList<ItemStack>();
        }
        nbt.func_74768_a("Clicks", this.numClicks);
        nbt.func_74777_a("PestleTicks", (short)this.pestleTicks);
    }

    public void sync() {
        PacketDispatcher.sendPacketToAllInDimension((Packet)this.func_70319_e(), (int)this.field_70331_k.field_73011_w.field_76574_g);
    }

    public void incrementNumClicks() {
        ++this.numClicks;
        this.sync();
    }

    public void func_70316_g() {
        if (this.pestleTicks < this.numClicks * 5) {
            ++this.pestleTicks;
        }
    }

    public void resetClicks() {
        this.numClicks = 0;
        this.pestleTicks = 0;
        this.sync();
    }

    public void addIngredient(ItemStack stack) {
        if (this.ingredients == null) {
            this.ingredients = new ArrayList<ItemStack>();
        }
        this.ingredients.add(new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j()));
        this.sync();
    }

    public void dropResult() {
        ItemStack[] stacks = new ItemStack[this.ingredients.size()];
        int c = 0;
        Iterator<ItemStack> i$ = this.ingredients.iterator();
        while (i$.hasNext()) {
            ItemStack i;
            stacks[c] = i = i$.next();
            ++c;
        }
        ItemStack stack = this.getCurareResult(this.getResult(stacks));
        EntityItem result = new EntityItem(this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m + ((double)new Random().nextInt(1) + 0.3), (double)this.field_70327_n, stack);
        if (!this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72838_d((Entity)result);
        }
        this.ingredients.clear();
        this.sync();
    }

    public Packet func_70319_e() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_70310_b(var1);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, var1);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.func_70307_a(pkt.field_73331_e);
    }

    public boolean isBowlFull() {
        if (this.ingredients == null) {
            return false;
        }
        for (ItemStack i : this.ingredients) {
            if (i.func_77973_b() != null) continue;
            return false;
        }
        return this.ingredients.size() >= 1;
    }

    public ItemStack[] getIngredients() {
        if (this.ingredients == null) {
            return new ItemStack[0];
        }
        ItemStack[] temp = new ItemStack[this.ingredients.size()];
        for (int i = 0; i < this.ingredients.size(); ++i) {
            temp[i] = this.ingredients.get(i);
        }
        return temp;
    }

    public List<ItemStack> getIngredientList() {
        return this.ingredients;
    }

    public boolean hasMetMaxNumClicks() {
        return this.numClicks >= 30;
    }

    private ItemStack getCurareResult(Curare curare) {
        return new ItemStack(TropicraftItems.curare, 1, curare.curareId);
    }

    private Curare getResult(ItemStack[] ingredients1) {
        return CurareMixRegistry.getInstance().getCurareFromIngredients(ingredients1);
    }
}

