/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.client.items;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import tropicraft.entities.passive.water.StarfishType;

@SideOnly(value=Side.CLIENT)
public class StarfishItemRenderer
implements IItemRenderer {
    private Minecraft minecraft = FMLClientHandler.instance().getClient();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_ROTATION: {
                return false;
            }
            case ENTITY_BOBBING: {
                return true;
            }
            case EQUIPPED_BLOCK: {
                return false;
            }
            case BLOCK_3D: {
                return false;
            }
            case INVENTORY_BLOCK: {
                return false;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int dmg = item.func_77960_j();
        if (dmg > StarfishType.values().length) {
            dmg = 0;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        StarfishType starfishType = StarfishType.values()[dmg];
        switch (type) {
            case INVENTORY: {
                this.renderStarfishInInventory(starfishType);
                break;
            }
            case EQUIPPED: {
                this.renderEquippedStarfish(starfishType);
                break;
            }
            case ENTITY: {
                this.renderStarfishEntity(starfishType);
                break;
            }
        }
    }

    private void renderStarfishEntity(StarfishType starfishType) {
        float f = 0.0f;
        float f1 = 1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f1shifted = 1.0f;
        float f3shifted = 1.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        if (RenderItem.field_82407_g) {
            GL11.glTranslatef((float)0.5f, (float)-0.25f, (float)0.0f);
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        for (int i = 0; i < starfishType.getLayerCount(); ++i) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(starfishType.getTexturePaths().get(i)));
            this.popper(tessellator, f1, f2, f, f3, f1shifted, f3shifted, starfishType.getLayerHeights()[i]);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-starfishType.getLayerHeights()[i]));
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
    }

    private void renderEquippedStarfish(StarfishType starfishType) {
        float f = 0.0f;
        float f1 = 1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f1shifted = 1.0f;
        float f3shifted = 1.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)32826);
        for (int i = 0; i < starfishType.getLayerCount(); ++i) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(starfishType.getTexturePaths().get(i)));
            this.popper(tessellator, f1, f2, f, f3, f1shifted, f3shifted, starfishType.getLayerHeights()[i]);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-starfishType.getLayerHeights()[i]));
        }
        GL11.glDisable((int)32826);
    }

    private void renderStarfishInInventory(StarfishType starfishType) {
        GL11.glDisable((int)2896);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < starfishType.getLayerCount(); ++i) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(starfishType.getTexturePaths().get(i)));
            tessellator.func_78382_b();
            tessellator.func_78374_a(0.0, 16.0, 0.0, 0.0, 1.0);
            tessellator.func_78374_a(16.0, 16.0, 0.0, 1.0, 1.0);
            tessellator.func_78374_a(16.0, 0.0, 0.0, 1.0, 0.0);
            tessellator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
        }
        GL11.glEnable((int)2896);
    }

    private void popper(Tessellator tessellator, float f, float f1, float f2, float f3, float f1shifted, float f3shifted, float layerHeight) {
        float f4 = 1.0f;
        float f5 = layerHeight;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        tessellator.func_78374_a(0.0, 0.0, 0.0, (double)f, (double)f3shifted);
        tessellator.func_78374_a((double)f4, 0.0, 0.0, (double)f2, (double)f3shifted);
        tessellator.func_78374_a((double)f4, 1.0, 0.0, (double)f2, (double)f1shifted);
        tessellator.func_78374_a(0.0, 1.0, 0.0, (double)f, (double)f1shifted);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78374_a(0.0, 1.0, (double)(0.0f - f5), (double)f, (double)f1);
        tessellator.func_78374_a((double)f4, 1.0, (double)(0.0f - f5), (double)f2, (double)f1);
        tessellator.func_78374_a((double)f4, 0.0, (double)(0.0f - f5), (double)f2, (double)f3);
        tessellator.func_78374_a(0.0, 0.0, (double)(0.0f - f5), (double)f, (double)f3);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        for (int i = 0; i < 32; ++i) {
            float f6 = (float)i / 32.0f;
            float f10 = f + (f2 - f) * f6 - 0.001953125f;
            float f14 = f4 * f6;
            tessellator.func_78374_a((double)f14, 0.0, (double)(0.0f - f5), (double)f10, (double)f3);
            tessellator.func_78374_a((double)f14, 0.0, 0.0, (double)f10, (double)f3);
            tessellator.func_78374_a((double)f14, 1.0, 0.0, (double)f10, (double)f1);
            tessellator.func_78374_a((double)f14, 1.0, (double)(0.0f - f5), (double)f10, (double)f1);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        for (int j = 0; j < 32; ++j) {
            float f7 = (float)j / 32.0f;
            float f11 = f + (f2 - f) * f7 - 0.001953125f;
            float f15 = f4 * f7 + 0.03125f;
            tessellator.func_78374_a((double)f15, 1.0, (double)(0.0f - f5), (double)f11, (double)f1);
            tessellator.func_78374_a((double)f15, 1.0, 0.0, (double)f11, (double)f1);
            tessellator.func_78374_a((double)f15, 0.0, 0.0, (double)f11, (double)f3);
            tessellator.func_78374_a((double)f15, 0.0, (double)(0.0f - f5), (double)f11, (double)f3);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        for (int k = 0; k < 32; ++k) {
            float f8 = (float)k / 32.0f;
            float f12 = f3 + (f1 - f3) * f8 - 0.001953125f;
            float f16 = f4 * f8 + 0.03125f;
            tessellator.func_78374_a(0.0, (double)f16, 0.0, (double)f, (double)f12);
            tessellator.func_78374_a((double)f4, (double)f16, 0.0, (double)f2, (double)f12);
            tessellator.func_78374_a((double)f4, (double)f16, (double)(0.0f - f5), (double)f2, (double)f12);
            tessellator.func_78374_a(0.0, (double)f16, (double)(0.0f - f5), (double)f, (double)f12);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        for (int l = 0; l < 32; ++l) {
            float f9 = (float)l / 32.0f;
            float f13 = f3 + (f1 - f3) * f9 - 0.001953125f;
            float f17 = f4 * f9;
            tessellator.func_78374_a((double)f4, (double)f17, 0.0, (double)f2, (double)f13);
            tessellator.func_78374_a(0.0, (double)f17, 0.0, (double)f, (double)f13);
            tessellator.func_78374_a(0.0, (double)f17, (double)(0.0f - f5), (double)f, (double)f13);
            tessellator.func_78374_a((double)f4, (double)f17, (double)(0.0f - f5), (double)f2, (double)f13);
        }
        tessellator.func_78381_a();
    }
}

