/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.blocks.tileentities.TileEntityBambooMug;
import tropicraft.drinks.ColorMixer;
import tropicraft.drinks.Drink;
import tropicraft.drinks.Ingredient;
import tropicraft.drinks.MixerRecipe;
import tropicraft.drinks.MixerRecipeRegistry;
import tropicraft.items.ItemTropicraftImpl;
import tropicraft.items.TropicraftItems;

public class ItemCocktail
extends ItemTropicraftImpl {
    private static final int DEFAULT_COLOR = 15973942;
    private Icon contentsIcon;

    public ItemCocktail(int i, String imgName, CreativeTabs tabs) {
        super(i, imgName, tabs);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77642_a(TropicraftItems.bambooMugEmpty);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack.field_77990_d == null) {
            return;
        }
        NBTTagList ingredients = par1ItemStack.field_77990_d.func_74761_m("Ingredients");
        for (int i = 0; i < ingredients.func_74745_c(); ++i) {
            NBTTagCompound ingredient = (NBTTagCompound)ingredients.func_74743_b(i);
            byte id = ingredient.func_74771_c("IngredientID");
            String ingredientName = Ingredient.ingredientsList[id].getIngredient().func_82833_r();
            par3List.add(ingredientName);
        }
        Drink drink = Drink.drinkList[par1ItemStack.field_77990_d.func_74771_c("DrinkID")];
        if (drink != null) {
            par3List.add("\u00a7o" + drink.displayName);
        }
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (MixerRecipe recipe : MixerRecipeRegistry.getInstance().getRecipes()) {
            par3List.add(ItemCocktail.makeCocktail(recipe));
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int par1, int par2) {
        return par2 == 0 ? this.field_77791_bV : this.contentsIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        if (par2 == 0) {
            return 0xFFFFFF;
        }
        return ItemCocktail.getCocktailColor(par1ItemStack);
    }

    public static int getCocktailColor(ItemStack stack) {
        if (stack.field_77990_d != null) {
            if (stack.field_77990_d.func_74764_b("Color")) {
                return stack.field_77990_d.func_74762_e("Color");
            }
            return 15973942;
        }
        return 15973942;
    }

    public static ItemStack makeCocktail(MixerRecipe recipe) {
        ItemStack stack = new ItemStack(TropicraftItems.cocktail);
        NBTTagCompound nbt = new NBTTagCompound();
        Drink drink = recipe.getCraftingResult();
        nbt.func_74774_a("DrinkID", (byte)drink.drinkId);
        NBTTagList tagList = new NBTTagList();
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : recipe.getIngredients()) {
            NBTTagCompound ingredientNbt = new NBTTagCompound();
            ingredientNbt.func_74774_a("IngredientID", (byte)ingredient.ingredientId);
            tagList.func_74742_a((NBTBase)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.func_74782_a("Ingredients", (NBTBase)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.func_74768_a("Color", color);
        stack.field_77990_d = nbt;
        return stack;
    }

    public static ItemStack makeCocktail(Ingredient[] ingredients) {
        ItemStack stack = new ItemStack(TropicraftItems.cocktail);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("DrinkID", (byte)0);
        NBTTagList tagList = new NBTTagList();
        Ingredient primary = null;
        LinkedList<Ingredient> additives = new LinkedList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            NBTTagCompound ingredientNbt = new NBTTagCompound();
            ingredientNbt.func_74774_a("IngredientID", (byte)ingredient.ingredientId);
            tagList.func_74742_a((NBTBase)ingredientNbt);
            if (ingredient.isPrimary()) {
                primary = ingredient;
                continue;
            }
            additives.add(ingredient);
        }
        nbt.func_74782_a("Ingredients", (NBTBase)tagList);
        int color = primary == null ? 15973942 : primary.getColor();
        for (Ingredient additive : additives) {
            color = ColorMixer.getInstance().alphaBlendRGBA(color, additive.getColor(), additive.getAlpha());
        }
        nbt.func_74768_a("Color", color);
        stack.field_77990_d = nbt;
        return stack;
    }

    public static Ingredient[] getIngredients(ItemStack stack) {
        if (stack.field_77993_c != TropicraftItems.cocktail.field_77779_bT || !stack.func_77942_o()) {
            return new Ingredient[0];
        }
        NBTTagCompound nbt = stack.func_77978_p();
        NBTTagList tagList = nbt.func_74761_m("Ingredients");
        Ingredient[] ingredients = new Ingredient[tagList.func_74745_c()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            byte id = ((NBTTagCompound)tagList.func_74743_b(i)).func_74771_c("IngredientID");
            ingredients[i] = Ingredient.ingredientsList[id];
        }
        return ingredients;
    }

    public static Drink getDrink(ItemStack stack) {
        if (stack.field_77993_c != TropicraftItems.cocktail.field_77779_bT || !stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        return Drink.drinkList[nbt.func_74771_c("DrinkID")];
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        int var11 = par3World.func_72798_a(par4, par5, par6);
        if (var11 == Block.field_72037_aS.field_71990_ca) {
            par7 = 1;
        } else if (!(var11 == Block.field_71998_bu.field_71990_ca || var11 == Block.field_71962_X.field_71990_ca || var11 == Block.field_71961_Y.field_71990_ca || Block.field_71973_m[var11] != null && Block.field_71973_m[var11].isBlockReplaceable(par3World, par4, par5, par6))) {
            if (par7 == 0) {
                --par5;
            } else if (par7 == 1) {
                ++par5;
            } else if (par7 == 2) {
                --par6;
            } else if (par7 == 3) {
                ++par6;
            } else if (par7 == 4) {
                --par4;
            } else if (par7 == 5) {
                ++par4;
            }
        }
        if (!par2EntityPlayer.func_82247_a(par4, par5, par6, par7, par1ItemStack)) {
            return false;
        }
        if (par3World.func_72931_a(TropicraftBlocks.bambooMug.field_71990_ca, par4, par5, par6, false, par7, (Entity)par2EntityPlayer, null)) {
            Block var12 = TropicraftBlocks.bambooMug;
            int var13 = this.func_77647_b(par1ItemStack.func_77960_j());
            int var14 = var12.func_85104_a(par3World, par4, par5, par6, par7, par8, par9, par10, var13);
            if (this.placeBlockAt(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10, var14)) {
                par3World.func_72908_a((double)((float)par4 + 0.5f), (double)((float)par5 + 0.5f), (double)((float)par6 + 0.5f), var12.field_72020_cn.func_82593_b(), (var12.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, var12.field_72020_cn.func_72678_c() * 0.8f);
                --par1ItemStack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!world.func_72832_d(x, y, z, TropicraftBlocks.bambooMug.field_71990_ca, metadata, 2)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == TropicraftBlocks.bambooMug.field_71990_ca) {
            TropicraftBlocks.bambooMug.func_71860_a(world, x, y, z, (EntityLivingBase)player, null);
            TropicraftBlocks.bambooMug.func_85105_g(world, x, y, z, metadata);
            TileEntityBambooMug mug = (TileEntityBambooMug)world.func_72796_p(x, y, z);
            mug.setCocktail(stack.func_77946_l());
            int var6 = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int meta = 2;
            if (var6 == 0) {
                meta = 2;
            } else if (var6 == 1) {
                meta = 5;
            } else if (var6 == 2) {
                meta = 3;
            } else if (var6 == 3) {
                meta = 4;
            }
            world.func_72921_c(x, y, z, meta, 2);
        }
        return true;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        Drink drink = ItemCocktail.getDrink(par1ItemStack);
        if (drink != null ? !par3EntityPlayer.func_71043_e(drink.alwaysEdible) : !par3EntityPlayer.func_71043_e(false)) {
            return par1ItemStack;
        }
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.burp", 0.5f, par2World.field_73012_v.nextFloat() * 0.1f + 0.9f);
        for (Ingredient ingredient : ItemCocktail.getIngredients(par1ItemStack)) {
            ingredient.onDrink(par3EntityPlayer);
        }
        Drink drink = ItemCocktail.getDrink(par1ItemStack);
        if (drink != null) {
            drink.onDrink(par3EntityPlayer);
        }
        return new ItemStack(TropicraftItems.bambooMugEmpty);
    }

    @Override
    public void func_94581_a(IconRegister iconRegistry) {
        super.func_94581_a(iconRegistry);
        this.contentsIcon = iconRegistry.func_94245_a("tropicraftmod:" + this.getImageName() + "contents");
    }
}

