/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.volleyball;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import tropicraft.volleyball.Court;
import tropicraft.volleyball.GameState;
import tropicraft.volleyball.Score;

public class Game {
    private List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    private Queue<EntityPlayer> lobby;
    private GameState gameState;
    private Score score;
    private Court court;
    private List<EntityPlayer> team1 = new ArrayList<EntityPlayer>();
    private List<EntityPlayer> team2 = new ArrayList<EntityPlayer>();
    private final int MAX_TEAM_SIZE;
    private Random rand;

    public Game(Court court) {
        this.lobby = new LinkedList<EntityPlayer>();
        this.gameState = GameState.BEFORE_GAME;
        this.score = Score.newScore();
        this.court = court;
        this.MAX_TEAM_SIZE = court.maxPlayersPerTeam();
        this.rand = new Random();
    }

    public void startGame() {
        this.gameState = GameState.IN_GAME;
        this.score = Score.newScore();
        this.determineTeams();
        this.onGameStart();
        this.lobby.clear();
    }

    private void determineTeams() {
        while (!this.lobby.isEmpty() && this.team1.size() <= this.MAX_TEAM_SIZE && this.team2.size() <= this.MAX_TEAM_SIZE) {
            EntityPlayer player = this.lobby.poll();
            int side = this.court.getSideOfCourt(player);
            if (side == 1) {
                this.team1.add(player);
            } else {
                this.team2.add(player);
            }
            System.err.printf("Adding %s to team%d\n", player.field_71092_bJ, side);
        }
    }

    public void joinGame(EntityPlayer player) throws IllegalArgumentException {
        if (!this.players.contains(player) && !this.lobby.contains(player)) {
            if (this.gameState == GameState.BEFORE_GAME) {
                this.lobby.add(player);
            } else {
                System.err.printf("%s cannot join the game while it is in progress!\n", player.field_71092_bJ);
            }
        } else {
            throw new IllegalArgumentException(String.format("Player %s who is already in game tried to join game!", player.field_71092_bJ));
        }
    }

    private void tryMergeLobby() {
        if (this.team1.size() > this.MAX_TEAM_SIZE || this.team2.size() > this.MAX_TEAM_SIZE) {
            System.err.println("Could not add anybody to teams because the game is full!");
            return;
        }
        if (this.lobby.isEmpty()) {
            System.err.println("Nobody in lobby, returning to game!");
            return;
        }
        while (!this.lobby.isEmpty() && this.team1.size() <= this.MAX_TEAM_SIZE && this.team2.size() <= this.MAX_TEAM_SIZE) {
            if (this.team1.size() > this.team2.size()) {
                this.team1.add(this.lobby.poll());
                continue;
            }
            if (this.team2.size() > this.team1.size()) {
                this.team2.add(this.lobby.poll());
                continue;
            }
            int team = this.rand.nextInt(2);
            if (team == 0) {
                this.team1.add(this.lobby.poll());
                continue;
            }
            this.team2.add(this.lobby.poll());
        }
    }

    public void onGameStart() {
        System.out.println("Starting game");
    }

    public void gameLoop() {
    }

    public void onGameEnd() {
    }

    public void onGamePause() {
    }

    public void saveGame(NBTTagCompound nbt) {
    }

    public void loadGame(NBTTagCompound nbt) {
    }

    public boolean hasPlayerJoined(EntityPlayer player) {
        return this.lobby.contains(player) || this.players.contains(player) || this.team1.contains(player) || this.team2.contains(player);
    }
}

