/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.mapgen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.world.biomes.BiomeGenTropicraft;
import tropicraft.world.perlin.NoiseModule;
import tropicraft.world.perlin.generator.Billowed;

public class MapGenVolcano {
    protected HashMap coordMap = new HashMap();
    public static List<BiomeGenBase> volcanoSpawnBiomesLand = Arrays.asList(new BiomeGenBase[]{BiomeGenTropicraft.tropics});
    public static List<BiomeGenBase> volcanoSpawnBiomesOcean = Arrays.asList(new BiomeGenBase[]{BiomeGenTropicraft.tropicsOcean});
    private World worldObj;
    private boolean useArrays;
    private final int CHUNK_SIZE_X = 16;
    private final int CHUNK_SIZE_Z = 16;
    private final int CHUNK_SIZE_Y = 127;
    private final int MAX_RADIUS = 40;
    private final int MIN_RADIUS = 30;
    private final int LAND_STEEPNESS_MOD = 6;
    private final int OCEAN_STEEPNESS_MOD = 11;
    private final int CALDERA_CUTOFF = 105;
    private final int VOLCANO_TOP = 98;
    private final int VOLCANO_CRUST = 95;
    private final int LAVA_LEVEL = 90;
    private final int CRUST_HOLE_CHANCE = 15;

    public MapGenVolcano(World worldObj, boolean useArrays) {
        this.worldObj = worldObj;
        this.useArrays = useArrays;
    }

    public short[] generate(int i, int k, short[] blocks, byte[] metas) {
        ChunkCoordinates volcanoCoords = this.getVolcanoNear(this.worldObj, i, k);
        if (volcanoCoords == null) {
            return blocks;
        }
        int[] heightmap = new int[256];
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 127; ++y) {
                    int blockID = this.getBlock(x, y, z, blocks);
                    if (blockID == 0 || blockID == TropicraftBlocks.tropicsWaterStationary.field_71990_ca) {
                        heightmap[x * 16 + z] = y;
                        continue block1;
                    }
                    if (y <= 75) continue;
                    heightmap[x * 16 + z] = y;
                    continue block1;
                }
            }
        }
        i *= 16;
        k *= 16;
        int volcCenterX = volcanoCoords.field_71574_a;
        int volcCenterZ = volcanoCoords.field_71573_c;
        int steepnessMod = volcanoCoords.field_71572_b == 1 ? 6 : 11;
        long seed = (long)volcCenterX * 341873128712L + (long)volcCenterZ * 132897987541L + this.worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        int radius = rand.nextInt(10) + 30;
        Billowed volcNoise = new Billowed(seed, 1, 1.0);
        volcNoise.amplitude = 13.0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                float relativeX = (float)(x + i - volcCenterX) / (float)radius;
                float relativeZ = (float)(z + k - volcCenterZ) / (float)radius;
                float distanceSquared = relativeX * relativeX + relativeZ * relativeZ;
                float perlin = (float)((NoiseModule)volcNoise).getNoise((double)(relativeX * 5.0f) + 1.0E-4, (double)(relativeZ * 5.0f) + 1.0E-4);
                float volcanoHeight = (float)steepnessMod / (distanceSquared + 1.0E-5f) - 5.0f - perlin;
                int groundHeight = heightmap[x * 16 + z];
                if (!(distanceSquared < (float)(radius * radius))) continue;
                for (int y = 127; y > 0; --y) {
                    if (volcanoHeight + (float)groundHeight < 105.0f) {
                        if (volcanoHeight + (float)groundHeight <= 98.0f) {
                            if (!((float)y <= volcanoHeight + (float)groundHeight) || y < groundHeight) continue;
                            this.placeBlock(x, y, z, TropicraftBlocks.chunkOHead.field_71990_ca, blocks);
                            continue;
                        }
                        if (y > 98) continue;
                        this.placeBlock(x, y, z, TropicraftBlocks.chunkOHead.field_71990_ca, blocks);
                        continue;
                    }
                    if (y == 95 && rand.nextInt(15) != 0) {
                        this.placeBlock(x, y, z, TropicraftBlocks.chunkOHead.field_71990_ca, blocks);
                    }
                    if (y > 90) continue;
                    this.placeBlock(x, y, z, Block.field_71938_D.field_71990_ca, blocks);
                }
            }
        }
        return blocks;
    }

    public void generate(int i, int k) {
        int volcCenterX = i;
        int volcCenterZ = k;
        int steepnessMod = this.worldObj.func_72807_a(i, k) == BiomeGenTropicraft.tropics ? 6 : 11;
        long seed = (long)volcCenterX * 341873128712L + (long)volcCenterZ * 132897987541L + this.worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        int radius = rand.nextInt(10) + 30;
        int[] heightmap = new int[radius * 2 * (radius * 2)];
        for (int x = -radius; x < radius; ++x) {
            block1: for (int z = -radius; z < radius; ++z) {
                for (int y = 127; y > 0; --y) {
                    int blockID = this.getBlock(x + i, y, z + k, null);
                    if (blockID == Block.field_71939_E.field_71990_ca || blockID == Block.field_71979_v.field_71990_ca || blockID == Block.field_71980_u.field_71990_ca) {
                        heightmap[(x + radius) * 16 + (z + radius)] = y;
                        continue block1;
                    }
                    if (y >= 30) continue;
                    heightmap[(x + radius) * 16 + (z + radius)] = y;
                    continue block1;
                }
            }
        }
        Billowed volcNoise = new Billowed(seed, 1, 1.0);
        volcNoise.amplitude = 15.0;
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                float relativeX = (float)x / (float)radius;
                float relativeZ = (float)z / (float)radius;
                float distanceSquared = relativeX * relativeX + relativeZ * relativeZ;
                float perlin = (float)((NoiseModule)volcNoise).getNoise((double)(relativeX * 5.0f) + 1.0E-4, (double)(relativeZ * 5.0f) + 1.0E-4);
                float volcanoHeight = (float)steepnessMod / (distanceSquared + 1.0E-5f) - 5.0f - perlin;
                int groundHeight = heightmap[(x + radius) * 16 + (z + radius)];
                if (!(distanceSquared < (float)(radius * radius))) continue;
                for (int y = 127; y > 0; --y) {
                    if (volcanoHeight + (float)groundHeight < 105.0f) {
                        if (volcanoHeight + (float)groundHeight <= 98.0f) {
                            if (!((float)y <= volcanoHeight + (float)groundHeight) || y < groundHeight) continue;
                            this.placeBlock(x + i, y, z + k, TropicraftBlocks.chunkOHead.field_71990_ca, null);
                            continue;
                        }
                        if (y > 98) continue;
                        this.placeBlock(x + i, y, z + k, TropicraftBlocks.chunkOHead.field_71990_ca, null);
                        continue;
                    }
                    if (y == 95 && rand.nextInt(15) != 0) {
                        this.placeBlock(x + i, y, z + k, TropicraftBlocks.chunkOHead.field_71990_ca, null);
                    }
                    if (y > 90) continue;
                    this.placeBlock(x + i, y, z + k, Block.field_71938_D.field_71990_ca, null);
                }
            }
        }
    }

    public void placeBlock(int x, int y, int z, int blockID, short[] blocks) {
        if (this.useArrays) {
            blocks[y << 8 | z << 4 | x] = (short)(blockID & 0xFFFF);
        } else {
            this.worldObj.func_94575_c(x, y, z, blockID);
        }
    }

    public int getBlock(int x, int y, int z, short[] blocks) {
        if (this.useArrays) {
            return blocks[y << 8 | z << 4 | x];
        }
        return this.worldObj.func_72798_a(x, y, z);
    }

    protected int canGenVolcanoAtCoords(World worldObj, int i, int j) {
        int numChunks = 32;
        int offsetChunks = 8;
        int oldi = i;
        int oldj = j;
        if (i < 0) {
            i -= numChunks - 1;
        }
        if (j < 0) {
            j -= numChunks - 1;
        }
        int randX = i / numChunks;
        int randZ = j / numChunks;
        long seed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldObj.func_72912_H().func_76063_b() + 4291726L;
        Random rand = new Random(seed);
        randX *= numChunks;
        randZ *= numChunks;
        if (oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks))) {
            if (worldObj.func_72959_q().func_76940_a(oldi * 16 + 8, oldj * 16 + 8, 0, volcanoSpawnBiomesLand)) {
                return 1;
            }
            if (worldObj.func_72959_q().func_76940_a(oldi * 16 + 8, oldj * 16 + 8, 0, volcanoSpawnBiomesOcean)) {
                return 2;
            }
        }
        return 0;
    }

    public ChunkCoordinates getVolcanoNear(World worldObj, int i, int j) {
        int range = 3;
        for (int x = i - range; x <= i + range; ++x) {
            for (int z = j - range; z <= j + range; ++z) {
                int biome = this.canGenVolcanoAtCoords(worldObj, x, z);
                if (biome == 0) continue;
                return new ChunkCoordinates(x * 16 + 8, biome, z * 16 + 8);
            }
        }
        return null;
    }
}

