/*
 * Decompiled with CFR 0.152.
 */
package tropicraft.world.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.MapData;
import tropicraft.blocks.TropicraftBlocks;
import tropicraft.items.TropicraftItems;

public class WorldGenTropicsTreasure
extends WorldGenerator {
    private static final List<Item> treasureList = new ArrayList<Item>();
    private static final List<Integer> sandBlocks = new ArrayList<Integer>();

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        int depth = random.nextInt(2) + 2;
        block0: for (int tries = 0; tries < 10; ++tries) {
            int surroundX;
            int surroundZ;
            int y;
            int x = i + random.nextInt(8) - random.nextInt(8);
            int z = k + random.nextInt(8) - random.nextInt(8);
            for (y = j = this.getTerrainHeightAt(world, x, z) - 1; y > j - depth; --y) {
                if (!sandBlocks.contains(world.func_72798_a(x, y, z))) continue block0;
            }
            int sandArea = 3;
            for (surroundZ = z - sandArea; surroundZ <= z + sandArea; ++surroundZ) {
                for (surroundX = x - sandArea; surroundX <= x + sandArea; ++surroundX) {
                    if (!sandBlocks.contains(world.func_72798_a(surroundX, j, surroundZ))) continue block0;
                }
            }
            for (surroundZ = z - sandArea; surroundZ <= z + sandArea; ++surroundZ) {
                for (surroundX = x - sandArea; surroundX <= x + sandArea; ++surroundX) {
                    if (!(random.nextFloat() < 0.2f)) continue;
                    world.func_94575_c(surroundX, j, surroundZ, TropicraftBlocks.purifiedSand.field_71990_ca);
                }
            }
            world.func_94575_c(x, y, z, TropicraftBlocks.bambooChest.field_71990_ca);
            TileEntityChest tileentitychest = (TileEntityChest)world.func_72796_p(x, y, z);
            if (tileentitychest == null) {
                return false;
            }
            boolean hasAddedMap = false;
            for (int e = 0; e < 8; ++e) {
                ItemStack itemstack;
                ItemStack itemStack = itemstack = e == 0 ? new ItemStack(TropicraftItems.recordBuriedTreasure) : this.pickCheckLootItem(world, random, x, y, z);
                if (itemstack == null || itemstack.func_77973_b() == Item.field_77744_bd && hasAddedMap) continue;
                if (itemstack.func_77973_b() == Item.field_77744_bd) {
                    hasAddedMap = true;
                    this.initializeMap(world, itemstack, x, y, z);
                }
                tileentitychest.func_70299_a(random.nextInt(tileentitychest.func_70302_i_()), itemstack);
            }
            return true;
        }
        return true;
    }

    int getTerrainHeightAt(World world, int x, int z) {
        for (int y = 128; y > 0; --y) {
            int id = world.func_72798_a(x, y, z);
            if (id == 0 || id == Block.field_71962_X.field_71990_ca || id == Block.field_72037_aS.field_71990_ca || id == Block.field_71952_K.field_71990_ca || id == Block.field_71951_J.field_71990_ca) continue;
            return y + 1;
        }
        return 0;
    }

    private ItemStack pickCheckLootItem(World world, Random random, int x, int y, int z) {
        Item loot = treasureList.get(random.nextInt(treasureList.size()));
        if (loot == Item.field_77703_o) {
            return new ItemStack(loot, random.nextInt(36) + 1);
        }
        if (loot == Item.field_77717_p) {
            return new ItemStack(loot, random.nextInt(46) + 1);
        }
        if (loot == Item.field_77702_n) {
            return new ItemStack(loot, random.nextInt(24) + 6);
        }
        if (loot == TropicraftItems.recordTradeWinds) {
            if (random.nextFloat() >= 0.5f) {
                return null;
            }
            return new ItemStack(loot);
        }
        if (loot == Item.field_77704_l) {
            return new ItemStack(loot, random.nextInt(45) + 1);
        }
        if (loot == Item.field_77733_bq) {
            return new ItemStack(loot, random.nextInt(40) + 1);
        }
        if (loot == TropicraftItems.oreDrops) {
            return new ItemStack(loot, random.nextInt(10) + 5, random.nextInt(5));
        }
        if (loot == TropicraftItems.shells) {
            return new ItemStack(loot, random.nextInt(4) + 2, random.nextInt(6));
        }
        return new ItemStack(loot);
    }

    private void initializeMap(World world, ItemStack mapItem, int x, int y, int z) {
        mapItem.func_77964_b(world.func_72841_b("map"));
        String mapName = "map_" + mapItem.func_77960_j();
        MapData data = new MapData(mapName);
        world.func_72823_a(mapName, (WorldSavedData)data);
        data.field_76201_a = x;
        data.field_76199_b = z;
        data.field_76197_d = (byte)3;
        data.func_76185_a();
    }

    static {
        treasureList.add(Item.field_77703_o);
        treasureList.add(Item.field_77717_p);
        treasureList.add(Item.field_77702_n);
        treasureList.add(TropicraftItems.oreDrops);
        treasureList.add(TropicraftItems.shells);
        treasureList.add(TropicraftItems.scaleHelm);
        treasureList.add(TropicraftItems.scaleBoots);
        treasureList.add(TropicraftItems.scaleChestplate);
        treasureList.add(TropicraftItems.scaleLeggings);
        treasureList.add(Item.field_77778_at);
        treasureList.add(Item.field_77704_l);
        treasureList.add(TropicraftItems.swordEudialyte);
        treasureList.add(TropicraftItems.swordZircon);
        treasureList.add(Item.field_77733_bq);
        treasureList.add((Item)Item.field_77744_bd);
        treasureList.add(Item.field_77728_bu);
        treasureList.add(TropicraftItems.recordTradeWinds);
        treasureList.add(TropicraftItems.recordEasternIsles);
        treasureList.add(TropicraftItems.recordBuriedTreasure);
        treasureList.add(TropicraftItems.recordLowTide);
        treasureList.add(TropicraftItems.recordSummering);
        treasureList.add(TropicraftItems.recordTheTribe);
        sandBlocks.add(Block.field_71939_E.field_71990_ca);
        sandBlocks.add(Block.field_71957_Q.field_71990_ca);
        sandBlocks.add(TropicraftBlocks.purifiedSand.field_71990_ca);
    }
}

