/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourModifier;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Map;
import mrtjp.projectred.ProjectRedIllumination;
import mrtjp.projectred.core.InvertX;
import mrtjp.projectred.illumination.FixturePart;
import mrtjp.projectred.illumination.RenderHalo;
import mrtjp.projectred.illumination.RenderLantern;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderFixture
implements IItemRenderer {
    public static RenderFixture instance = new RenderFixture();
    private static CCModel[] base;
    public static final Cuboid6[] lightBounds;

    public void renderFixture(FixturePart l) {
        ms icon = l.isOn() ? RenderLantern.onIcons[l.type] : RenderLantern.offIcons[l.type];
        TextureUtils.bindAtlas((int)0);
        CCRenderState.reset();
        CCRenderState.setBrightness((acf)l.world(), (int)l.x(), (int)l.y(), (int)l.z());
        CCRenderState.useModelColours((boolean)true);
        this.renderPart(icon, base[l.side], l.x(), l.y(), l.z());
    }

    public boolean handleRenderType(ye item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ye item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ye item, Object ... data) {
        int color = item.k();
        boolean on = item.b() == ProjectRedIllumination.itemPartInvFixture;
        switch (type) {
            case ENTITY: {
                this.renderInventory(on, color, -0.25, 0.0, -0.25, 0.75);
                return;
            }
            case EQUIPPED: {
                this.renderInventory(on, color, -0.15, -0.15, -0.15, 1.5);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderInventory(on, color, -0.15, -0.15, -0.15, 1.5);
                return;
            }
            case INVENTORY: {
                this.renderInventory(on, color, 0.0, -0.05, 0.0, 1.0);
                return;
            }
        }
    }

    public void renderInventory(boolean on, int color, double x, double y, double z, double scale) {
        ms icon = on ? RenderLantern.onIcons[color] : RenderLantern.offIcons[color];
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        CCRenderState.reset();
        TextureUtils.bindAtlas((int)0);
        CCRenderState.useNormals((boolean)true);
        CCRenderState.startDrawing((int)7);
        this.renderPart(icon, base[0], x, y, z);
        CCRenderState.draw();
        if (on) {
            RenderHalo.prepareRenderState();
            RenderHalo.renderHalo(bfq.a, lightBounds[0], color, (Transformation)new Translation(x, y, z));
            RenderHalo.restoreRenderState();
        }
        GL11.glPopMatrix();
    }

    public void renderPart(ms icon, CCModel cc, double x, double y, double z) {
        cc.render(0, cc.verts.length, (Transformation)new Translation(x, y, z), (IUVTransformation)new IconTransformation(icon), (IVertexModifier)ColourModifier.instance);
    }

    static {
        lightBounds = new Cuboid6[6];
        Map models = CCModel.parseObjModels((bjo)new bjo("projectred", "textures/obj/lights/fixture.obj"), (int)7, (Transformation)new InvertX());
        base = new CCModel[6];
        for (int i = 0; i < 6; ++i) {
            CCModel m = ((CCModel)models.get("base")).copy();
            m.apply((Transformation)new Translation(0.5, 0.0, 0.5));
            m.apply(Rotation.sideOrientation((int)i, (int)0).at(Vector3.center));
            m.computeLighting(LightModel.standardLightModel);
            m.shrinkUVs(5.0E-4);
            RenderFixture.base[i] = m.copy();
            Transformation t = Rotation.sideRotations[i].at(Vector3.center);
            RenderFixture.lightBounds[i] = new Cuboid6(0.15625, 0.0, 0.15625, 0.84375, 0.53125, 0.84375).apply(t).expand(-0.001);
        }
    }
}

