/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.lib.config.ConfigFile;
import codechicken.nei.DropDownWidget;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.SubSetRangeTag;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import org.lwjgl.opengl.GL11;

public class DropDownFile
extends ConfigFile {
    public ArrayList<SubSetRangeTag> sortedtags = new ArrayList();
    public int slotwidth = 0;
    public boolean hasscroll;
    protected int scrollclicky = -1;
    protected float scrollpercent;
    protected int scrollmousey;
    protected float percentscrolled;
    protected int lastslotclicked = -1;
    protected long lastslotclicktime;
    int x;
    int y;
    int height;
    int width;
    int contentheight;
    public boolean hidden;
    public static final int slotheight = 18;
    public static DropDownFile dropDownInstance = new DropDownFile(new File(atv.w().x, "config/NEISubset.cfg"));

    static {
        dropDownInstance.setComment("You can put your own custom SubSet Ranges in here\nFollow the following format (replace {something} with what you want.\n{Parent}.{Name}=[{item1}],[{item2}],[{item3}-{item4}],[{item5}:{damage}],[{item6}:{damage1}-{damage2}]\nEg. Blocks.Nether = [87-89],[112-115]\nEg2. Birch = [17:2],[6:2]");
    }

    public DropDownFile(File file) {
        super(file);
    }

    public SubSetRangeTag getTag(String tagname) {
        return (SubSetRangeTag)super.getTag(tagname);
    }

    public SubSetRangeTag getTag(String tagname, boolean createnew) {
        return (SubSetRangeTag)super.getTag(tagname, createnew);
    }

    public SubSetRangeTag getNewTag(String name) {
        return new SubSetRangeTag(this, name);
    }

    public void saveConfig() {
        super.saveConfig();
    }

    public boolean thisContains(int mousex, int mousey) {
        return mousex >= this.x && mousex < this.x + this.width && mousey >= this.y && mousey <= this.y + this.height;
    }

    public boolean contains(int mousex, int mousey) {
        if (this.thisContains(mousex, mousey)) {
            return true;
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            if (!tag.contains(mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    public int getScrollBarWidth() {
        return 5;
    }

    public int getScrollBarHeight() {
        int sbarh = (int)((float)this.height / (float)this.contentheight * (float)this.height);
        if (sbarh > this.height) {
            return this.height;
        }
        if (sbarh < this.height / 15) {
            return this.height / 15;
        }
        return sbarh;
    }

    public int getScrolledSlots() {
        int slots = this.childTagMap().size();
        int shownslots = this.height / 18;
        return (int)(this.percentscrolled * (float)(slots - shownslots) + 0.5f);
    }

    private int getClickedSlot(int mousey) {
        return (mousey - this.y) / 18 + this.getScrolledSlots();
    }

    public void calculatePercentScrolled() {
        int barempty = this.height - this.getScrollBarHeight();
        if (this.scrollclicky >= 0) {
            int scrolldiff = this.scrollmousey - this.scrollclicky;
            this.percentscrolled = (float)scrolldiff / (float)barempty + this.scrollpercent;
        }
        if (this.percentscrolled < 0.0f) {
            this.percentscrolled = 0.0f;
        }
        if (this.percentscrolled > 1.0f) {
            this.percentscrolled = 1.0f;
        }
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        this.percentscrolled = (float)(sbary - this.y) / (float)barempty;
    }

    public void processScrollMouse(int mousex, int mousey) {
        if (this.scrollclicky >= 0) {
            int scrolldiff = mousey - this.scrollclicky;
            int barupallowed = (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.scrollpercent) + 0.5);
            int bardownallowed = this.height - this.getScrollBarHeight() - barupallowed;
            this.scrollmousey = -scrolldiff > barupallowed ? this.scrollclicky - barupallowed : (scrolldiff > bardownallowed ? this.scrollclicky + bardownallowed : mousey);
            this.calculatePercentScrolled();
        }
    }

    public String updateMouseOver(int mousex, int mousey, String mouseovername) {
        this.processScrollMouse(mousex, mousey);
        String currentmouseover = "";
        int sloty = this.y;
        int slotx = this.x + (this.hasscroll ? this.getScrollBarWidth() : 0);
        int slot = 0;
        for (SubSetRangeTag tag : this.sortedtags) {
            String s;
            if (++slot <= this.getScrolledSlots()) continue;
            if (slotx <= mousex && this.x + this.width > mousex && sloty <= mousey && sloty + 18 > mousey) {
                currentmouseover = tag.qualifiedname;
            }
            if (!(s = tag.updateMouseOver(mousex, mousey, mouseovername)).equals("")) {
                currentmouseover = s;
            }
            sloty += 18;
        }
        return currentmouseover;
    }

    public boolean click(int mousex, int mousey, int button) {
        boolean inbounds = this.thisContains(mousex, mousey);
        if (!inbounds) {
            for (SubSetRangeTag tag : this.sortedtags) {
                tag.click(mousex, mousey, button);
            }
        }
        int barempty = this.height - this.getScrollBarHeight();
        int sbary = this.y + (int)((double)((float)barempty * this.percentscrolled) + 0.5);
        int contentx = this.x + this.getScrollBarWidth();
        if (this.hasscroll && button == 0 && this.getScrollBarHeight() < this.height && mousex >= this.x && mousex <= this.x + this.getScrollBarWidth() && mousey >= this.y && mousey <= this.y + this.height) {
            if (mousey < sbary) {
                this.percentscrolled = (float)(mousey - this.y) / (float)barempty;
                this.calculatePercentScrolled();
            } else if (mousey > sbary + this.getScrollBarHeight()) {
                this.percentscrolled = (float)(mousey - this.y - this.getScrollBarHeight() + 1) / (float)barempty;
                this.calculatePercentScrolled();
            } else {
                this.scrollclicky = mousey;
                this.scrollpercent = this.percentscrolled;
                this.scrollmousey = mousey;
            }
        } else if (mousex >= contentx && mousex < this.x + this.width && mousey >= this.y && mousey <= this.y + this.height) {
            int slot = this.getClickedSlot(mousey);
            if (slot == this.lastslotclicked && System.currentTimeMillis() - this.lastslotclicktime < 500L && button == 0) {
                this.slotClicked(slot, button, true);
            } else {
                this.slotClicked(slot, button, false);
            }
            if (button == 0) {
                this.lastslotclicked = slot;
                this.lastslotclicktime = System.currentTimeMillis();
            }
        }
        return true;
    }

    public void onMouseWheel(int i) {
        if (this.scrollclicky != -1) {
            return;
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            if (!tag.expanded) continue;
            tag.onMouseWheel(i);
            return;
        }
        this.scrollpercent += (float)i / (float)this.contentheight * 10.0f;
        if (this.scrollpercent > 1.0f) {
            this.scrollpercent = 1.0f;
        } else if (this.scrollpercent < 0.0f) {
            this.scrollpercent = 0.0f;
        }
    }

    private void slotClicked(int slot, int button, boolean doubleclick) {
        int i = 0;
        for (SubSetRangeTag tag : this.sortedtags) {
            if (slot == i) {
                tag.onClick(button, doubleclick);
                return;
            }
            ++i;
        }
    }

    public void hideAllItems() {
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.hideAllItems();
        }
    }

    public void showAllItems() {
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.showAllItems();
        }
    }

    public void mouseUp(int mousex, int mousey, int button) {
        if (this.scrollclicky >= 0 && button == 0) {
            this.scrollclicky = -1;
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.mouseUp(mousex, mousey, button);
        }
    }

    public void draw(int mousex, int mousey) {
        this.drawScrollBar();
        int drawy = this.y;
        int drawx = this.x + (this.hasscroll ? this.getScrollBarWidth() : 0);
        int slot = 0;
        for (SubSetRangeTag tag : this.sortedtags) {
            if (++slot <= this.getScrolledSlots()) continue;
            if (!this.hidden) {
                if (!DropDownWidget.texturedButtons) {
                    boolean contains = mousex >= drawx && mousex < drawx + this.slotwidth && mousey >= drawy && mousey < drawy + 18;
                    GuiDraw.drawRect((int)drawx, (int)drawy, (int)this.slotwidth, (int)18, (int)(contains ? -12578808 : -16777216));
                    GuiDraw.drawStringC((String)tag.name, (int)drawx, (int)drawy, (int)this.slotwidth, (int)18, (int)tag.getColourFromState(), (tag.state == 0 ? 1 : 0) != 0);
                } else {
                    GuiDraw.changeTexture((String)"textures/gui/widgets.png");
                    if (tag.state == 1) {
                        GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    int tex = tag.state == 0 ? 0 : 1;
                    LayoutManager.drawButtonBackground(drawx, drawy, this.slotwidth, 18, false, tex);
                    int textcolour = tag.state == 2 ? -2039584 : -6250336;
                    GuiDraw.drawStringC((String)tag.name, (int)drawx, (int)drawy, (int)this.slotwidth, (int)18, (int)textcolour);
                }
            }
            tag.draw(mousex, mousey);
            if ((drawy += 18) >= this.y + this.height) break;
        }
    }

    private void drawScrollBar() {
        if (this.hasscroll && !this.hidden) {
            int sbary = this.y + (int)((double)((float)(this.height - this.getScrollBarHeight()) * this.percentscrolled) + 0.5);
            GuiDraw.drawRect((int)this.x, (int)this.y, (int)5, (int)this.height, (int)-14671840);
            if (DropDownWidget.texturedButtons) {
                GuiDraw.drawRect((int)this.x, (int)sbary, (int)5, (int)this.getScrollBarHeight(), (int)-7631989);
                GuiDraw.drawRect((int)this.x, (int)sbary, (int)4, (int)(this.getScrollBarHeight() - 1), (int)-986896);
                GuiDraw.drawRect((int)(this.x + 1), (int)(sbary + 1), (int)4, (int)(this.getScrollBarHeight() - 1), (int)-11184811);
                GuiDraw.drawRect((int)(this.x + 1), (int)(sbary + 1), (int)3, (int)(this.getScrollBarHeight() - 2), (int)-3750202);
            } else {
                GuiDraw.drawRect((int)this.x, (int)sbary, (int)5, (int)this.getScrollBarHeight(), (int)-2039584);
            }
        }
    }

    public void position(int px, int py) {
        this.x = px;
        this.y = py;
        this.recalcSize();
        int suby = this.y;
        int subx = this.x + this.width;
        int slot = 0;
        for (SubSetRangeTag tag : this.sortedtags) {
            if (++slot <= this.getScrolledSlots()) continue;
            tag.position(subx, suby);
            if ((suby += 18) >= this.y + this.height) break;
        }
    }

    public void recalcSize() {
        int totalwidth;
        int maxheight = NEIClientUtils.getGuiContainer().h - this.y;
        this.contentheight = this.childTagMap().size() * 18;
        if (this.contentheight > maxheight) {
            this.height = maxheight / 18 * 18;
            this.hasscroll = true;
        } else {
            this.hasscroll = false;
            this.height = this.contentheight;
        }
        this.slotwidth = 0;
        avi fontRenderer = NEIClientUtils.mc().l;
        for (SubSetRangeTag tag : this.sortedtags) {
            int tagwidth = fontRenderer.a(tag.name);
            if (tagwidth <= this.slotwidth) continue;
            this.slotwidth = tagwidth;
        }
        this.slotwidth += 2;
        this.width = this.slotwidth;
        if (this.hasscroll) {
            this.width += 5;
        }
        this.hidden = (totalwidth = this.x + this.width - LayoutManager.dropDown.x) <= 0;
    }

    public void resetHashes() {
        this.sortedtags = this.getSortedTagList();
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.resetHashes();
        }
    }

    public void updateState() {
        ItemVisibilityHash vis = NEIClientConfig.vishash;
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.updateState(vis);
        }
    }

    public void addItemIfInRange(int item, int damage, by compound) {
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.addItemIfInRange(item, damage, compound);
        }
    }

    public int getWidthAtLevel(int hiddenlevel) {
        if (hiddenlevel == 0) {
            return this.width;
        }
        for (SubSetRangeTag tag : this.sortedtags) {
            int subwidth = tag.getWidthAtLevel(hiddenlevel - 1);
            if (subwidth == 0) continue;
            return subwidth;
        }
        return 0;
    }

    public Iterable<SubSetRangeTag> allTags() {
        LinkedList<SubSetRangeTag> tags = new LinkedList<SubSetRangeTag>();
        for (SubSetRangeTag tag : this.sortedtags) {
            tag.addChildTags(tags);
        }
        return tags;
    }
}

