/*
 * Decompiled with CFR 0.152.
 */
package dan200.quantum.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import dan200.QCraft;
import dan200.quantum.client.EntityQuantumDustFX;
import dan200.quantum.client.GuiItemTransfer;
import dan200.quantum.client.GuiQuantumComputer;
import dan200.quantum.shared.BlockQBlock;
import dan200.quantum.shared.BlockQuantumLogic;
import dan200.quantum.shared.ItemQBlock;
import dan200.quantum.shared.ItemQuantumGoggles;
import dan200.quantum.shared.QCraftProxyCommon;
import dan200.quantum.shared.TileEntityQuantumComputer;
import java.util.EnumSet;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class QCraftProxyClient
extends QCraftProxyCommon {
    private static final bjo QUANTUM_GOGGLE_HUD = new bjo("qcraft", "textures/gui/goggles.png");
    private static final bjo AO_GOGGLE_HUD = new bjo("qcraft", "textures/gui/anti_observation_goggles.png");
    private long m_tickCount = 0L;
    private bfr m_renderBlocks;

    @Override
    public void load() {
        if (QCraft.enableQuantumGoggles) {
            ItemQuantumGoggles.s_renderIndex = RenderingRegistry.addNewArmourRendererPrefix((String)"qgoggles");
        }
        super.load();
        if (QCraft.enableQuantumGates) {
            int gateID;
            QCraft.Blocks.quantumLogic.blockRenderID = gateID = RenderingRegistry.getNextAvailableRenderId();
        }
        if (QCraft.enableQBlock) {
            this.m_renderBlocks = new bfr();
            QCraft.Blocks.qBlock.blockRenderID = RenderingRegistry.getNextAvailableRenderId();
        }
        this.registerForgeHandlers();
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public Object getQuantumComputerGUI(ud inventory, TileEntityQuantumComputer computer) {
        return new GuiQuantumComputer(inventory, computer);
    }

    @Override
    public void showItemTransferGUI(uf entityPlayer, TileEntityQuantumComputer computer) {
        if (atv.w().n == null) {
            FMLClientHandler.instance().displayGuiScreen(entityPlayer, (awe)new GuiItemTransfer(computer));
        }
    }

    @Override
    public void spawnQuantumDustFX(abw world, double x, double y, double z) {
        atv mc = atv.w();
        double dx = mc.i.u - x;
        double dy = mc.i.v - y;
        double dz = mc.i.w - z;
        if (dx * dx + dy * dy + dz * dz < 256.0) {
            EntityQuantumDustFX fx = new EntityQuantumDustFX(world, x, y, z, 1.0f);
            mc.k.a((beg)fx);
        }
    }

    @Override
    public boolean isLocalPlayerWearingGoggles() {
        bdi player = atv.w().h;
        if (player != null) {
            return this.isPlayerWearingGoggles((uf)player);
        }
        return false;
    }

    @Override
    public boolean isLocalPlayerWearingQuantumGoggles() {
        bdi player = atv.w().h;
        if (player != null) {
            return this.isPlayerWearingQuantumGoggles((uf)player);
        }
        return false;
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        TickRegistry.registerTickHandler((ITickHandler)handlers, (Side)Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)handlers);
        if (QCraft.enableQuantumGates) {
            QuantumLogicBlockRenderingHandler logicHandler = new QuantumLogicBlockRenderingHandler();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)logicHandler);
        }
        if (QCraft.enableQBlock) {
            QBlockRenderingHandler qBlockHandler = new QBlockRenderingHandler();
            MinecraftForgeClient.registerItemRenderer((int)QCraft.Blocks.qBlock.cF, (IItemRenderer)qBlockHandler);
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)qBlockHandler);
        }
    }

    private void renderInventoryQBlock(bfr renderblocks, BlockQBlock block, ye item) {
        int[] types = ItemQBlock.getTypes(item);
        int type = this.cycleType(types);
        if (type < 0) {
            this.renderInventoryQBlock(renderblocks, block, 0, BlockQBlock.Appearance.Fuzz);
        } else {
            this.renderInventoryQBlock(renderblocks, block, type, BlockQBlock.Appearance.Block);
        }
    }

    private int cycleType(int[] types) {
        int type = -99;
        int cycle = (int)(this.m_tickCount % 120L);
        int subcycle = cycle % 20;
        if (subcycle > 5) {
            type = types[cycle / 20];
        }
        return type;
    }

    private void bindColor(int c) {
        float r = (float)(c >> 16 & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    private void renderInventoryQBlock(bfr renderblocks, BlockQBlock block, int type, BlockQBlock.Appearance appearance) {
        bfq tessellator = bfq.a;
        tessellator.b();
        this.bindColor(block.getColorForType(0, type));
        tessellator.b(0.0f, -1.0f, 0.0f);
        renderblocks.a((aqz)block, 0.0, 0.0, 0.0, block.getIconForType(0, type, appearance));
        tessellator.a();
        tessellator.b();
        this.bindColor(block.getColorForType(1, type));
        tessellator.b(0.0f, 1.0f, 0.0f);
        renderblocks.b((aqz)block, 0.0, 0.0, 0.0, block.getIconForType(1, type, appearance));
        tessellator.a();
        tessellator.b();
        this.bindColor(block.getColorForType(2, type));
        tessellator.b(0.0f, 0.0f, -1.0f);
        renderblocks.c((aqz)block, 0.0, 0.0, 0.0, block.getIconForType(2, type, appearance));
        tessellator.a();
        tessellator.b();
        this.bindColor(block.getColorForType(3, type));
        tessellator.b(0.0f, 0.0f, 1.0f);
        renderblocks.d((aqz)block, 0.0, 0.0, 0.0, block.getIconForType(3, type, appearance));
        tessellator.a();
        tessellator.b();
        this.bindColor(block.getColorForType(4, type));
        tessellator.b(-1.0f, 0.0f, 0.0f);
        renderblocks.e((aqz)block, 0.0, 0.0, 0.0, block.getIconForType(4, type, appearance));
        tessellator.a();
        tessellator.b();
        this.bindColor(block.getColorForType(5, type));
        tessellator.b(1.0f, 0.0f, 0.0f);
        renderblocks.f((aqz)block, 0.0, 0.0, 0.0, block.getIconForType(5, type, appearance));
        tessellator.a();
    }

    @Override
    public void renderQuantumGogglesOverlay(float width, float height) {
        this.renderOverlay(QUANTUM_GOGGLE_HUD, width, height);
    }

    @Override
    public void renderAOGogglesOverlay(float width, float height) {
        this.renderOverlay(AO_GOGGLE_HUD, width, height);
    }

    private void renderOverlay(bjo texture, float width, float height) {
        atv mc = atv.w();
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        mc.N.a(texture);
        bfq tessellator = bfq.a;
        tessellator.b();
        tessellator.a(0.0, (double)height, -90.0, 0.0, 1.0);
        tessellator.a((double)width, (double)height, -90.0, 1.0, 1.0);
        tessellator.a((double)width, 0.0, -90.0, 1.0, 0.0);
        tessellator.a(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private class QBlockRenderingHandler
    implements IItemRenderer,
    ISimpleBlockRenderingHandler {
        public boolean handleRenderType(ye item, IItemRenderer.ItemRenderType type) {
            switch (type) {
                case ENTITY: 
                case EQUIPPED: 
                case EQUIPPED_FIRST_PERSON: 
                case INVENTORY: {
                    return true;
                }
            }
            return false;
        }

        public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ye item, IItemRenderer.ItemRendererHelper helper) {
            switch (helper) {
                case ENTITY_ROTATION: 
                case ENTITY_BOBBING: 
                case EQUIPPED_BLOCK: 
                case BLOCK_3D: 
                case INVENTORY_BLOCK: {
                    return true;
                }
            }
            return false;
        }

        public void renderItem(IItemRenderer.ItemRenderType type, ye item, Object[] data) {
            switch (type) {
                case ENTITY: 
                case INVENTORY: {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                    QCraft.Blocks.qBlock.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    QCraftProxyClient.this.m_renderBlocks.a((aqz)QCraft.Blocks.qBlock);
                    QCraftProxyClient.this.renderInventoryQBlock(QCraftProxyClient.this.m_renderBlocks, QCraft.Blocks.qBlock, item);
                    GL11.glPopMatrix();
                    break;
                }
                case EQUIPPED: 
                case EQUIPPED_FIRST_PERSON: {
                    GL11.glPushMatrix();
                    QCraft.Blocks.qBlock.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    QCraftProxyClient.this.m_renderBlocks.a((aqz)QCraft.Blocks.qBlock);
                    QCraftProxyClient.this.renderInventoryQBlock(QCraftProxyClient.this.m_renderBlocks, QCraft.Blocks.qBlock, item);
                    GL11.glPopMatrix();
                    break;
                }
            }
        }

        public boolean shouldRender3DInInventory() {
            return true;
        }

        public int getRenderId() {
            return QCraft.Blocks.qBlock.blockRenderID;
        }

        public boolean renderWorldBlock(acf world, int i, int j, int k, aqz block, int modelID, bfr renderblocks) {
            if (modelID == this.getRenderId() && block == QCraft.Blocks.qBlock) {
                BlockQBlock.s_forceGrass = QCraft.Blocks.qBlock.getImpostorBlock(world, i, j, k) == aqz.z;
                QCraft.Blocks.qBlock.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                renderblocks.a((aqz)QCraft.Blocks.qBlock);
                renderblocks.p((aqz)QCraft.Blocks.qBlock, i, j, k);
                BlockQBlock.s_forceGrass = false;
                return true;
            }
            return false;
        }

        public void renderInventoryBlock(aqz block, int metadata, int modelID, bfr renderblocks) {
        }
    }

    private class QuantumLogicBlockRenderingHandler
    implements ISimpleBlockRenderingHandler {
        public boolean shouldRender3DInInventory() {
            return false;
        }

        public int getRenderId() {
            return QCraft.Blocks.quantumLogic.blockRenderID;
        }

        public boolean renderWorldBlock(acf world, int i, int j, int k, aqz block, int modelID, bfr renderblocks) {
            if (modelID == QCraft.Blocks.quantumLogic.blockRenderID) {
                int metadata = world.h(i, j, k);
                int direction = anw.j((int)metadata);
                int subType = ((BlockQuantumLogic)block).getSubType(metadata);
                switch (direction) {
                    case 0: {
                        renderblocks.t = 0;
                        break;
                    }
                    case 1: {
                        renderblocks.t = 1;
                        break;
                    }
                    case 2: {
                        renderblocks.t = 3;
                        break;
                    }
                    case 3: {
                        renderblocks.t = 2;
                    }
                }
                renderblocks.a(block);
                renderblocks.p(block, i, j, k);
                renderblocks.t = 0;
                return true;
            }
            return false;
        }

        public void renderInventoryBlock(aqz block, int metadata, int modelID, bfr renderblocks) {
        }
    }

    public class ForgeHandlers
    implements ITickHandler {
        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
            QCraftProxyClient.this.m_tickCount++;
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        }

        public EnumSet<TickType> ticks() {
            return EnumSet.of(TickType.CLIENT);
        }

        public String getLabel() {
            return "QCraft";
        }
    }
}

