/*
 * Decompiled with CFR 0.152.
 */
package dan200.quantum.shared;

import dan200.quantum.shared.QCraftProxyCommon;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class LostLuggage {
    public static final long MAX_LUGGAGE_AGE_HOURS = 24L;
    public static final LostLuggage Instance = new LostLuggage();
    private Set<Luggage> m_luggage = new HashSet<Luggage>();

    public void reset() {
        this.m_luggage.clear();
    }

    public void load() {
        File location = new File("./qcraft/luggage.bin");
        by nbt = QCraftProxyCommon.loadNBTFromPath(location);
        if (nbt != null) {
            this.readFromNBT(nbt);
        } else {
            this.reset();
        }
    }

    public void save() {
        File location = new File("./qcraft/luggage.bin");
        by nbt = new by();
        this.writeToNBT(nbt);
        QCraftProxyCommon.saveNBTToPath(location, nbt);
    }

    private void readFromNBT(by nbt) {
        this.m_luggage.clear();
        cg luggageList = nbt.m("luggage");
        for (int i = 0; i < luggageList.c(); ++i) {
            by luggageTag = (by)luggageList.b(i);
            Luggage luggage = new Luggage();
            luggage.m_timeStamp = luggageTag.f("timeStamp");
            if (luggageTag.b("originIP") && luggageTag.b("originPort")) {
                luggage.m_origin = new Address(luggageTag.i("originIP"), luggageTag.e("originPort"));
            }
            if (luggageTag.b("destinationIP") && luggageTag.b("destinationPort")) {
                luggage.m_destination = new Address(luggageTag.i("destinationIP"), luggageTag.e("destinationPort"));
            }
            luggage.m_luggage = luggageTag.j("luggage");
            this.m_luggage.add(luggage);
        }
    }

    private void writeToNBT(by nbt) {
        cg luggageList = new cg();
        for (Luggage luggage : this.m_luggage) {
            by luggageTag = new by();
            luggageTag.a("timeStamp", luggage.m_timeStamp);
            if (luggage.m_origin != null) {
                luggageTag.a("originIP", luggage.m_origin.getIP());
                luggageTag.a("originPort", luggage.m_origin.getPort());
            }
            if (luggage.m_destination != null) {
                luggageTag.a("destinationIP", luggage.m_destination.getIP());
                luggageTag.a("destinationPort", luggage.m_destination.getPort());
            }
            luggageTag.a("luggage", luggage.m_luggage);
            luggageList.a((cl)luggageTag);
        }
        nbt.a("luggage", (cl)luggageList);
    }

    public void storeLuggage(Address origin, Address destination, byte[] luggageData) {
        Luggage luggage = new Luggage();
        luggage.m_timeStamp = System.currentTimeMillis();
        luggage.m_origin = origin;
        luggage.m_destination = destination;
        luggage.m_luggage = luggageData;
        this.m_luggage.add(luggage);
    }

    public void removeOldLuggage() {
        long timeNow = System.currentTimeMillis();
        for (Luggage luggage : this.m_luggage) {
            long ageMillis = timeNow - luggage.m_timeStamp;
            if (ageMillis < 86400000L) continue;
            this.m_luggage.remove(luggage);
        }
    }

    public Collection<LuggageMatch> getMatchingLuggage(Address server) {
        ArrayList<LuggageMatch> luggages = new ArrayList<LuggageMatch>();
        for (Luggage luggage : this.m_luggage) {
            if (server.equals(luggage.m_destination)) {
                luggages.add(new LuggageMatch(true, luggage.m_luggage));
                continue;
            }
            if (!server.equals(luggage.m_origin)) continue;
            luggages.add(new LuggageMatch(false, luggage.m_luggage));
        }
        return luggages;
    }

    public void removeLuggage(byte[] luggageData) {
        for (Luggage luggage : this.m_luggage) {
            if (!Arrays.equals(luggageData, luggage.m_luggage)) continue;
            this.m_luggage.remove(luggage);
        }
    }

    public static class LuggageMatch {
        public boolean m_matchedDestination;
        public byte[] m_luggage;

        public LuggageMatch(boolean matchedDestination, byte[] luggage) {
            this.m_matchedDestination = matchedDestination;
            this.m_luggage = luggage;
        }
    }

    private static class Luggage {
        public long m_timeStamp;
        public Address m_origin;
        public Address m_destination;
        public byte[] m_luggage;

        private Luggage() {
        }
    }

    public static class Address {
        private final String m_ip;
        private final int m_port;

        public Address(String ip, int port) {
            this.m_ip = ip;
            this.m_port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o != null && o instanceof Address) {
                Address other = (Address)o;
                return other.m_ip.equals(this.m_ip) && other.m_port == this.m_port;
            }
            return false;
        }

        public String getIP() {
            return this.m_ip;
        }

        public int getPort() {
            return this.m_port;
        }
    }
}

