/*
 * Decompiled with CFR 0.152.
 */
package dan200.quantum.shared;

import dan200.quantum.shared.TileEntityQuantumComputer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortalRegistry {
    public static final PortalRegistry PortalRegistry = new PortalRegistry();
    public static final PortalRegistry ClientPortalRegistry = new PortalRegistry();
    private List<Server> m_servers = new ArrayList<Server>();
    private Map<String, TileEntityQuantumComputer.PortalLocation> m_portals = new HashMap<String, TileEntityQuantumComputer.PortalLocation>();

    public static PortalRegistry getPortalRegistry(abw world) {
        if (!world.I) {
            return PortalRegistry;
        }
        return ClientPortalRegistry;
    }

    public void reset() {
        this.m_servers.clear();
        this.m_portals.clear();
    }

    public void readFromNBT(by nbt) {
        int i;
        if (nbt.b("servers")) {
            cg servers = nbt.m("servers");
            for (i = 0; i < servers.c(); ++i) {
                by server = (by)servers.b(i);
                this.m_servers.add(new Server(server.i("name"), server.i("address")));
            }
        }
        cg portals = nbt.m("portals");
        for (i = 0; i < portals.c(); ++i) {
            by portal = (by)portals.b(i);
            this.m_portals.put(portal.i("id"), TileEntityQuantumComputer.PortalLocation.decode(portal));
        }
    }

    public void writeToNBT(by nbt) {
        cg servers = new cg();
        for (Server entry : this.m_servers) {
            by server = new by();
            server.a("name", entry.m_name);
            server.a("address", entry.m_address);
            servers.a((cl)server);
        }
        nbt.a("servers", (cl)servers);
        cg portals = new cg();
        for (Map.Entry<String, TileEntityQuantumComputer.PortalLocation> entry : this.m_portals.entrySet()) {
            by portal = entry.getValue().encode();
            portal.a("id", entry.getKey());
            portals.a((cl)portal);
        }
        nbt.a("portals", (cl)portals);
    }

    public String getUnusedID() {
        int id = 1;
        while (this.m_portals.containsKey("Gate " + id)) {
            ++id;
        }
        return "Gate " + id;
    }

    public boolean register(String id, TileEntityQuantumComputer.PortalLocation portal) {
        if (!this.m_portals.containsKey(id)) {
            this.m_portals.put(id, portal);
            return true;
        }
        return false;
    }

    public void unregister(String id) {
        if (this.m_portals.containsKey(id)) {
            this.m_portals.remove(id);
        }
    }

    public TileEntityQuantumComputer.PortalLocation getPortal(String id) {
        return this.m_portals.get(id);
    }

    public void registerServer(String name, String address) {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            if (!this.m_servers.get((int)i).m_address.equals(address)) continue;
            this.m_servers.get((int)i).m_name = name;
            return;
        }
        this.m_servers.add(new Server(name, address));
    }

    public void unregisterServer(String address) {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            if (!this.m_servers.get((int)i).m_address.equals(address)) continue;
            this.m_servers.remove(i);
            break;
        }
    }

    public String getServerAddressAfter(String address) {
        if (address == null) {
            return this.m_servers.size() >= 0 ? this.m_servers.get((int)0).m_address : null;
        }
        for (int i = 0; i < this.m_servers.size(); ++i) {
            if (!this.m_servers.get((int)i).m_address.equals(address)) continue;
            int indexAfter = i + 1;
            if (indexAfter >= this.m_servers.size()) {
                return null;
            }
            return this.m_servers.get((int)indexAfter).m_address;
        }
        return null;
    }

    public String getServerName(String address) {
        if (address != null) {
            for (int i = 0; i < this.m_servers.size(); ++i) {
                if (!this.m_servers.get((int)i).m_address.equals(address)) continue;
                return this.m_servers.get((int)i).m_name;
            }
        }
        return address;
    }

    private static class Server {
        public String m_name;
        public String m_address;

        public Server(String name, String address) {
            this.m_name = name;
            this.m_address = address;
        }
    }
}

